# -----------------------------------------------------------------------------
# $Id: Vanish.pm,v 1.4 2003/07/26 14:00:36 admin Exp $
# -----------------------------------------------------------------------------
package User::Vanish;
use strict;
use warnings;
use base qw(Module);
use Mask;
use Multicast;
our $DEBUG = 0;

sub message_arrived {
    my ($this,$msg,$sender) = @_;

    my $result = $msg;
    if ($sender->server_p) {
	my $method = 'cmd_'.$msg->command;
	if ($this->can($method)) {
	    if ($DEBUG) {
		my $original = $msg->serialize;
		$result = $this->$method($msg, $sender);
		my $filtered = (defined $result ? $result->serialize : '');
		if ($original ne $filtered) {
		    # Ƥ񴹤ؤ줿
		    my $debug_msg = "'$original' -> '$filtered'";
		    eval {
			substr($debug_msg, 400) = '...';
		    };
		    RunLoop->shared->notify_msg($debug_msg);
		}
	    }
	    else {
		$result = $this->$method($msg, $sender);
	    }
	}
    }
    elsif ($sender->client_p) {
	if ($msg->command eq 'VANISHDEBUG') {
	    $DEBUG = $msg->param(0);
	    RunLoop->shared->notify_msg("User::Vanish - debug-mode ".($DEBUG?'enabled':'disabled'));
	    $result = undef;
	}
    }

    $result;
}

*cmd_NOTICE = \&cmd_PRIVMSG;
sub cmd_PRIVMSG {
    my ($this,$msg,$sender) = @_;

    # ȯԸVanishоݤ
    my $ch_long = $msg->param(0);
    my $ch_short = Multicast::detach($ch_long);
    if (Multicast::nick_p($ch_short)) {
	$ch_long = '#___priv___@'.$sender->network_name;
    }

    if ($this->target_of_vanish_p($msg->prefix,$ch_long)) {
	undef;
    }
    else {
	$msg;
    }
}

sub cmd_JOIN {
    my ($this,$msg,$sender) = @_;
    my @channels; # ͥꥹȤƹ롣
    foreach my $channel (split m/,/,$msg->param(0)) {
	my ($ch_full,$mode) = ($channel =~ m/^([^\x07]+)(?:\x07(.*))?/);
	if (!$this->target_of_vanish_p($msg->prefix,$ch_full)) {
	    push @channels,$channel;
	}
    }

    if (@channels > 0) {
	# ƹη̡ͥ뤬ޤĤäƤ
	$msg->param(0,join(',',@channels));
    }
    else {
	$msg = undef;
    }

    $msg;
}

sub cmd_NJOIN {
    my ($this,$msg,$sender) = @_;
    my $ch_long = $msg->param(0);
    my $ch_short = Multicast::detach($ch_long);
    my $ch = $sender->channel($ch_short);
    if (defined $ch) {
	my @nicks;
	foreach my $mode_and_nick (split m/,/,$msg->param(1)) {
	    my ($mode,$nick) = ($mode_and_nick =~ m/^([@+]*)(.+)$/);
	    my $person = $ch->names($nick);
	    if (!defined $person || !$this->target_of_vanish_p) {
		push @nicks,$mode_and_nick;
	    }
	}

	if (@nicks > 0) {
	    # ƹη̡nickޤĤäƤ
	    $msg->param(1,join(',',@nicks));
	}
	else {
	    $msg = undef;
	}
    }

    $msg;
}

sub cmd_PART {
    my ($this,$msg,$sender) = @_;
    if ($this->target_of_vanish_p($msg->prefix,$msg->param(0))) {
	undef;
    }
    else {
	$msg;
    }
}

sub cmd_INVITE {
    my ($this,$msg,$sender) = @_;
    if ($this->target_of_vanish_p($msg->prefix,$msg->param(1))) {
	undef;
    }
    else {
	$msg;
    }
}

*cmd_QUIT = \&cmd_NICK;
sub cmd_NICK {
    my ($this,$msg,$sender) = @_;

    # ƶڤܤͥ̾ΥꥹȤ롣ΥꥹȤˤϥͥåȥ̾դƤʤ
    my $affected = $msg->remark('affected-channels');
    # ĤǤVanishоݤǤʤͥnickȤߤСNICK˴ʤ
    my $no_vanish;
    foreach (@$affected) {
	my $ch_long = Multicast::attach($_,$sender->network_name);
	if (!$this->target_of_vanish_p($msg->prefix,$ch_long)) {
	    $no_vanish = 1;
	    last;
	}
    }

    if ($no_vanish) {
	$msg;
    }
    else {
	undef;
    }
}

sub cmd_TOPIC {
    my ($this,$msg,$sender) = @_;
    if ($this->target_of_vanish_p($msg->prefix,$msg->param(0))) {
	if ($this->config->drop_topic_by_target) {
	    $msg->prefix('HIDDEN!HIDDEN@HIDDEN.BY.USER.BANISH');
	}
    }
    $msg;
}

sub cmd_353 {
    # RPL_NAMREPLY
    my ($this,$msg,$sender) = @_;

    my $ch_long = $msg->param(2);
    my $ch_short = Multicast::detach($ch_long);
    my $ch = $sender->channel($ch_short);
    if (defined $ch) {
	my @nicks;
	foreach my $mode_and_nick (split / /,$msg->param(3)) {
	    my ($mode,$nick) = ($mode_and_nick =~ m/^([@\+]{0,2})(.+)$/);
	    my $person = $ch->names($nick);
	    if (!defined $person || !$this->target_of_vanish_p($person->info,$ch_long)) {
		push @nicks,$mode_and_nick;
	    }
	}
	$msg->param(3,join(' ',@nicks));
    }

    $msg;
}

sub cmd_MODE {
    my ($this,$msg,$sender) = @_;

    # ȯԸVanishоݤ
    if ($this->target_of_vanish_p($msg->prefix,$msg->param(0))) {
	if ($this->config->drop_mode_by_target) {
	    # prefix
	    $msg->prefix('HIDDEN!HIDDEN@HIDDEN.BY.USER.VANISH');
	}
    }

    # +o/-o/+v/-vоݤVanishоݤ
    my $ch_long = $msg->param(0);
    my $ch_short = Multicast::detach($ch_long);
    my $ch = $sender->channel($ch_short);
    if (defined $ch && (sub{defined$_[0]?$_[0]:1}->($this->config->drop_mode_switch_for_target))) {
	my $n_params = @{$msg->params};
	my $plus = 0; # ɾΥ⡼ɤ+ʤΤ-ʤΤ
	my $mode_char_pos = 1; # ɾmode characterΰ֡
	my $mode_param_offset = 0; # $mode_char_posĤɲåѥ᥿򽦤ä

	my $fetch_param = sub {
	    $mode_param_offset++;
	    return $msg->param($mode_char_pos + $mode_param_offset);
	};

	my @params = ($ch_long); # ѥ᡼ƹۤ롣
	my $add = sub {
	    my ($char,$option) = @_;
	    push @params,($plus ? '+' : '-').$char;
	    if (defined $option) {
		push @params,$option;
	    }
	};

	for (;$mode_char_pos < $n_params;$mode_char_pos += $mode_param_offset + 1) {
	    $mode_param_offset = 0; # ꥻåȤ롣
	    foreach my $c (split //,$msg->param($mode_char_pos)) {
		if ($c eq '+') {
		    $plus = 1;
		}
		elsif ($c eq '-') {
		    $plus = 0;
		}
		elsif (index('bIk',$c) != -1) {
		    $add->($c,$fetch_param->());
		}
		elsif (index('Oov',$c) != -1) {
		    my $target = $fetch_param->();
		    my $person = $ch->names($target);
		    if (!defined $person || !$this->target_of_vanish_p($person->info,$ch_long)) {
			$add->($c,$target);
		    }
		}
		elsif ($c eq 'l') {
		    if ($plus) {
			$add->($c,$fetch_param->()); # ɲåѥ᥿ΤƤ
		    }
		    else {
			$add->($c);
		    }
		}
		else {
		    $add->($c);
		}
	    }
	}

	# ѥ᥿ƹη̡Ĥ̵ʤä顢Υå˴
	if (@params > 1) {
	    $msg = IRCMessage->new(
		Prefix => $msg->prefix,
		Command => $msg->command,
		Params => \@params);
	}
	else {
	    $msg = undef;
	}
    }
    $msg;
}

sub cmd_KICK {
    my ($this,$msg,$sender) = @_;

    if ($this->target_of_vanish_p($msg->prefix,$msg->param(0))) {
	if ($this->config->drop_kick_by_target) {
	    $msg->prefix('HIDDEN!HIDDEN@HIDDEN.BY.USER.BANISH');
	}
    }

    my $kicked_nick = $msg->param(1);
    my $ch = $sender->channel(Multicast::detach($msg->param(0)));
    if (defined $ch) {
	if ($this->config->drop_kick_for_target) {
	    $msg = undef;
	}
    }

    $msg;
}

sub target_of_vanish_p {
    # $userinfo: nick!name@hostΥ桼
    # $ch_long : ͥåȥ̾դΥͥ̾
    # : 
    my ($this,$userinfo,$ch_long) = @_;
    Mask::match_deep_chan([$this->config->mask('all')],$userinfo,$ch_long);
}

1;
