# -----------------------------------------------------------------------------
# $Id: Client.pm,v 1.1 2003/01/27 05:04:01 admin Exp $
# -----------------------------------------------------------------------------
package User::Away::Client;
use strict;
use warnings;
use base qw(Module);
use RunLoop;
use IRCMessage;

sub client_attached {
    my ($this,$client) = @_;
    # 饤Ȥ³줿Ȥϡ
    # ʤȤİʾΥ饤Ȥ¸ߤ˷ޤäƤ롣
    RunLoop->shared->broadcast_to_servers(
	IRCMessage->new(
	    Command => 'AWAY'));
}

sub client_detached {
    my ($this,$client) = @_;
    # 饤Ȥο1(Υ᥽åɤä0ˤʤ)ʤAWAY¹ԡ
    if (@{RunLoop->shared->clients} == 1 &&
	defined $this->config->away) {
	
	RunLoop->shared->broadcast_to_servers(
	    IRCMessage->new(
		Command => 'AWAY',
		Param => $this->config->away));
    }
}

sub connected_to_server {
    my ($this,$server,$new_connection) = @_;
    # 饤Ȥο0ʤAWAY¹ԡ
    if (@{RunLoop->shared->clients} == 0 &&
	defined $this->config->away) {
	
	$server->send_message(
	    IRCMessage->new(
		Command => 'AWAY',
		Param => $this->config->away));
    }
}

1;
