# -----------------------------------------------------------------------------
# $Id: Channel.pm,v 1.11 2003/11/16 19:04:39 topia Exp $
# -----------------------------------------------------------------------------
# Local: $Clovery: tiarra/module/Log/Channel.pm,v 1.4 2003/02/11 07:53:40 topia Exp $
package Log::Channel;
use strict;
use warnings;
use IO::File;
use File::Spec;
use Unicode::Japanese;
use base qw(Module);
use Module::Use qw(Tools::DateConvert Log::Logger);
use Tools::DateConvert;
use Log::Logger;
use ControlPort;
use Mask;
use Multicast;

sub new {
    my $class = shift;
    my $this = $class->SUPER::new;
    $this->{channels} = []; # Ǥ[ǥ쥯ȥ̾,ޥ]
    $this->{matching_cache} = {}; # <ͥ̾,ե̾>
    $this->{filehandle_cache} = {}; # <ͥ̾,[եѥ,IO::File]>
    $this->{sync_command} = do {
	my $sync = $this->config->sync;
	if (defined $sync) {
	    uc $sync;
	}
	else {
	    undef;
	}
    };
    $this->{distinguish_myself} = do {
	my $conf_val = $this->config->distinguish_myself;
	if (defined $conf_val) {
	    $conf_val;
	}
	else {
	    1;
	}
    };
    $this->{logger} =
	Log::Logger->new(
	    sub {
		$this->_search_and_write(@_);
	    },
	    $this,
	    'S_PRIVMSG','C_PRIVMSG','S_NOTICE','C_NOTICE');

    $this->_init;
}

sub _init {
    my $this = shift;
    foreach ($this->config->channel('all')) {
	my ($dirname,$mask) = split /\s+/;
	if (!defined($dirname) || $dirname eq '' ||
	    !defined($mask) || $mask eq '') {
	    die "Illegal definition in Log::Channel/channel : $_\n";
	}
	push @{$this->{channels}},[$dirname,$mask];
    }

    $this;
}

sub sync {
    my $this = shift;
    $this->flush_all_file_handles;
    RunLoop->shared->notify_msg("Channel logs synchronized.");
}

sub control_requested {
    my ($this,$request) = @_;
    if ($request->ID eq 'synchronize') {
	$this->sync;
	ControlPort::Reply->new(204,'No Content');
    }
    else {
	die "Log::Channel received control request of unsupported ID ".$request->ID."\n";
    }
}

sub message_arrived {
    my ($this,$message,$sender) = @_;

    # syncͭǡ饤ȤäåǤꡢĺΥޥɤsync˰פƤ뤫
    if (defined $this->{sync_command} &&
	$sender->isa('IrcIO::Client') &&
	$message->command eq $this->{sync_command}) {
	# Ƥեflush
	# ¾Υ⥸塼Ʊޥɤsync뤫ΤʤΤǡ
	# do-not-send-to-servers => 1ꤹ뤬
	# åΤ˴Ƥޤʤ
	$this->sync;
	$message->remark('do-not-send-to-servers',1);
	return $message;
    }

    # Log::Channel/command˥ޥå뤫
    if (Mask::match(lc($this->config->command || '*'),lc($message->command))) {
	$this->{logger}->log($message,$sender);
    }

    $message;
}

*S_PRIVMSG = \&PRIVMSG_or_NOTICE;
*S_NOTICE = \&PRIVMSG_or_NOTICE;
*C_PRIVMSG = \&PRIVMSG_or_NOTICE;
*C_NOTICE = \&PRIVMSG_or_NOTICE;
sub PRIVMSG_or_NOTICE {
    my ($this,$msg,$sender) = @_;
    my $target = Multicast::detatch($msg->param(0));
    my $is_priv = Multicast::nick_p($target);
    my $cmd = $msg->command;

    my $line = do {
	if ($is_priv) {
	    # privλϼʬɬ̤롣
	    if ($sender->isa('IrcIO::Client')) {
		sprintf(
		    $cmd eq 'PRIVMSG' ? '>%s< %s' : ')%s( %s',
		    $msg->param(0),
		    $msg->param(1));
	    }
	    else {
		sprintf(
		    $cmd eq 'PRIVMSG' ? '-%s- %s' : '=%s= %s',
		    $msg->nick || $sender->current_nick,
		    $msg->param(1));
	    }
	}
	else {
	    my $format = do {
		if ($this->{distinguish_myself} && $sender->isa('IrcIO::Client')) {
		    $cmd eq 'PRIVMSG' ? '>%s:%s< %s' : ')%s:%s( %s';
		}
		else {
		    $cmd eq 'PRIVMSG' ? '<%s:%s> %s' : '(%s:%s) %s';
		}
	    };
	    my $nick = do {
		if ($sender->isa('IrcIO::Client')) {
		    RunLoop->shared_loop->network(
		      (Multicast::detatch($msg->param(0)))[1])
			->current_nick;
		}
		else {
		    $msg->nick || $sender->current_nick;
		}
	    };
	    sprintf $format,$msg->param(0),$nick,$msg->param(1);
	}
    };

    [$is_priv ? 'priv' : $msg->param(0),$line];
}

sub _channel_match {
    # ꤵ줿ͥ̾˥ޥå¸եΥѥõ
    # Ĥޥåʤundef֤
    # Υ᥽åɤϸ̤$this->{matching_cache}¸ơ˺Ѥ롣
    my ($this,$channel) = @_;

    my $cached = $this->{matching_cache}->{$channel};
    if (defined $cached) {
	if ($cached eq '') {
	    # ޥå륨ȥ¸ߤʤȤ̤å夵Ƥ롣
	    return undef;
	}
	else {
	    return $cached;
	}
    }

    foreach my $ch (@{$this->{channels}}) {
	if (Mask::match($ch->[1],$channel)) {
	    # ޥå
	    my $fname_format = $this->config->filename || '%Y.%m.%d.txt';
	    my $fpath_format = $ch->[0]."/$fname_format";

	    $this->{matching_cache}->{$channel} = $fpath_format;
	    return $fpath_format;
	}
    }
    $this->{matching_cache}->{$channel} = '';
    undef;
}

sub _search_and_write {
    my ($this,$channel,$line) = @_;
    my $dirname = $this->_channel_match($channel);
    if (defined $dirname) {
	$this->_write($channel,$dirname,$line);
    }
}

sub _write {
    # ꤵ줿ե˥إåդɵ롣
    # ǥ쥯ȥ̾դΥޥִ롣
    my ($this,$channel,$abstract_fpath,$line) = @_;
    my $concrete_fpath = do {
	my $basedir = $this->config->directory;
	if (defined $basedir) {
	    Tools::DateConvert::replace("$basedir/$abstract_fpath");
	}
	else {
	    Tools::DateConvert::replace($abstract_fpath);
	}
    };
    my $header = Tools::DateConvert::replace(
	$this->config->header || '%H:%M'
    );
    my $mode = do {
	my $mode_conf = $this->config->mode;
	if (defined $mode_conf) {
	    oct('0'.$mode_conf);
	}
	else {
	    0600;
	}
    };
    # ǥ쥯ȥ̵꤬к롣
    $this->mkdirs($concrete_fpath);
    # եɵ
    my $make_path_fh_set = sub {
	[$concrete_fpath,
	 IO::File->new($concrete_fpath,O_CREAT | O_APPEND | O_WRONLY,$mode)];
    };
    my $fh = sub {
	# åͭ
	if ($this->config->keep_file_open) {
	    # Υͥϥå夵Ƥ뤫
	    my $cached_elem = $this->{filehandle_cache}->{$channel};
	    if (defined $cached_elem) {
		# å夵줿եѥϺΥեȰפ뤫
		if ($cached_elem->[0] eq $concrete_fpath) {
		    # ΥեϥɥѤɤ
		    #print "$concrete_fpath: RECYCLED\n";
		    return $cached_elem->[1];
		}
		else {
		    # ե̾㤦դѤäξ硣
		    # ŤեϥɥĤ롣
		    #print "$concrete_fpath: recached\n";
		    eval {
			$cached_elem->[1]->flush;
			$cached_elem->[1]->close;
		    };
		    # ʥեϥɥ
		    @$cached_elem = @{$make_path_fh_set->()};
		    return $cached_elem->[1];
		}
	    }
	    else {
		# å夵ƤʤΤǡեϥɥäƥå塣
		#print "$concrete_fpath: *cached*\n";
		my $cached_elem =
		    $this->{filehandle_cache}->{$channel} =
			$make_path_fh_set->();
		return $cached_elem->[1];
	    }
	}
	else {
	    # å̵
	    return $make_path_fh_set->()->[1];
	}
    }->();
    if (defined $fh) {
	$fh->print(
	    Unicode::Japanese->new("$header $line\n",'utf8')->conv(
		$this->config->charset || 'jis'));
    }
}

sub mkdirs {
    my ($this,$file) = @_;
    my (undef,$directories,undef) = File::Spec->splitpath($file);
    my $dir_mode = undef;

    # ľܤοƤ¸ߤ뤫
    if ($directories eq '' || -d $directories) {
	# ʾéʤ¸ߤΤǽλ
	return;
    }
    else {
	# ¸ߤʤΤǺ
	my @dirs = File::Spec->splitdir($directories);
	foreach (0 .. (scalar @dirs - 2)) {
	    my $dir = File::Spec->catdir(@dirs[0 .. $_]);
	    unless (-d $dir) {
		$dir_mode ||= do {
		    my $mode_conf = $this->config->dir_mode;
		    if (defined $mode_conf) {
			oct('0'.$mode_conf);
		    }
		    else {
			0700;
		    }
		};
		mkdir $dir, $dir_mode;
	    }
	}
    }
}

sub flush_all_file_handles {
    my $this = shift;
    foreach my $cached_elem (values %{$this->{filehandle_cache}}) {
	eval {
	    $cached_elem->[1]->flush;
	};
    }
}

sub destruct {
    my $this = shift;
    # ƤƤΥեϥɥĤơåˤ롣
    foreach my $cached_elem (values %{$this->{filehandle_cache}}) {
	eval {
	    $cached_elem->[1]->flush;
	    $cached_elem->[1]->close;
	};
    }
    %{$this->{filehandle_cache}} = ();
}

1;

=pod
info: ͥprivΥ⥸塼롣
default: off

# LogϤΥ⥸塼ǤϡʲΤ褦դִԤʤ롣
# %% : %
# %Y : ǯ(4)
# %m : (2)
# %d : (2)
# %H : (2)
# %M : ʬ(2)
# %S : (2)

# ¸ǥ쥯ȥꡣTiarraư֤Хѥ~ϻȤʤ
directory: log

# եʸɡά줿jis
charset: sjis

# ƹԤΥإåΥեޥåȡά줿'%H:%M'
header: %H:%M:%S

# ե̾Υեޥåȡά줿'%Y.%m.%d.txt'
filename: %Y.%m.%d.txt

# եΥ⡼(8ʿ)ά줿600
mode: 600

# ǥ쥯ȥΥ⡼(8ʿ)ά줿700
dir-mode: 700

# 륳ޥɤɽޥά줿鵭ϿΥޥɤϿ롣
command: privmsg,join,part,kick,invite,mode,nick,quit,kill,topic,notice

# PRIVMSGNOTICEϿݤˡʬȯ¾ͤȯǥեޥåȤѤ뤫ɤ1/0ǥեȤ1
distinguish-myself: 1

# ƥե򳫤äѤʤˤ뤫ɤ
# Υץ¿ξ硢ǥޤƸΨɤ¸ޤ
# Ͽ٤ƤΥե򳫤ޤޤˤΤǡ50100Υͥ
# ̡Υե˥褦ʾˤϻȤ٤ǤϤޤ
-keep-file-open: 1

# keep-file-openͭˤ硢ȯ٤˥եɵΤǤϤʤ
# ʬ̤ίޤäƤ񤭹ޤ롣Τᡢե򳫤Ƥ
# ǶȯϤޤ񤭹ޤƤʤǽ롣
# syncꤹȡ¨¤˥ǥ˽񤭹िΥޥɤɲä롣
# ά줿ϥޥɤɲäʤ
sync: sync

# ƥͥꡣͥ̾ʬϥޥǤ롣
# ĿͰƤ줿PRIVMSGNOTICEϥͥ̾"priv"ȤƸ롣
# Ҥ줿ǸΤǡƤΥͥ˥ޥå"*"ʤɤϺǸ˽񤫤ʤФʤʤ
# ꤵ줿ǥ쥯ȥ꤬¸ߤʤä顢Log::ChannelϤ򾡼˺롣
# եޥåȤϼ̤ꡣ
# channel: <ǥ쥯ȥ̾> (<ͥ̾> / 'priv')
# :
# filename: %Y.%m.%d.txt
# channel: IRCDanwasitu #IRCü@ircnet
# channel: others *
# Ǥϡ#IRCü@ircnetΥIRCDanwasitu/%Y.%m.%d.txtˡ
# ʳ(privޤ)Υothers/%Y.%m.%d.txt¸롣
channel: priv priv
channel: others *
=cut
