# -----------------------------------------------------------------------------
# $Id: Utils.pm,v 1.10 2003/07/31 07:34:14 topia Exp $
# -----------------------------------------------------------------------------
# $Clovery: tiarra/module/Auto/Utils.pm,v 1.16 2003/07/27 07:02:47 topia Exp $
package Auto::Utils;
use strict;
use warnings;
use Module::Use qw(Auto::AliasDB);
use Auto::AliasDB;
use Multicast;
use IRCMessage;

# get_ch_name  get_raw_ch_name Υꥢ(ߴΤ)
*get_ch_name = \&get_raw_ch_name;
sub get_raw_ch_name {
    # ͥåȥ̾ȴ(ͥ/nick)̾ or undef 
    my ($msg, $ch_place) = @_;

    if (defined($msg->param($ch_place)) && $msg->param($ch_place) ne '') {
	return(scalar(Multicast::detach($msg->param($ch_place))));
    } else {
	return undef;
    }
}

sub get_full_ch_name {
    # ͥåȥ̾դ(ͥ/nick)̾ or undef 
    my ($msg, $ch_place) = @_;

    if (defined($msg->param($ch_place)) && $msg->param($ch_place) ne '') {
	return($msg->param($ch_place));
    } else {
	return undef;
    }
}

sub sendto_channel_closure {
    # ͥ PRIVMSG / NOTICE 륯֤ޤ

    # -  -
    # $sendto	: ͥ̾ or ˥åͥåȥ̾դƲ
    # $command	: 'PRIVMSG' or 'NOTICE'¾Υޥɤ¤Ϥޤ󤬰̵̣Ǥ礦
    # $msg	: message_arrivedϤäƤ$msgꥢִ˻Ѥޤäơ
    #               Ҥ $use_alias  false ʤꤹɬפϤޤ
    #               ξ undef ǤϤƤޤ礦
    # $sender	: message_arrivedϤäƤ$sender˻Ȥޤɬܡ
    # $result	: message_arrived֤ͤˤλȡܺ٤򸫤ޤ礦
    # $use_alias	: ꥢ֤ԤɤάġάϹԤ
    # $extra_callbacks
    # 		: ɲäΥꥢִХåάġ
    #
    # ꥢִХå˴ؤƤ Auto::AliasDB 򻲾ȤƤ
    #
    # - ֤ -
    # 	$send_message
    # $send_message
    # 		: 㡣˥åʹߤɲäΥꥢ(άǽ)ꤷƸƤӽФ
    #               åȤundefϤ줿ϡ⤻˽λ롣
    #
    # -  -
    #       sub message_arrived {
    #           my ($this,$msg,$sender) = @_;
    #           my @result = ($msg);
    #           my $send_message = 
    #               sendto_channel_closure('#test@ircnet', 'NOTICE', $msg, $sender, \@result);
    #           $send_message->('message', 'hoge' => 'moge');
    #           return @result;
    #       }
    #

    my ($sendto, $command, $msg, $sender, $result, $use_alias, $extra_callbacks) = @_;

    $use_alias = 1 unless defined $use_alias;
    $extra_callbacks = [] unless defined $extra_callbacks;

    return sub {
	my ($str,%extra_replaces) = @_;
	return if !defined $str;
	my $msg_to_send = IRCMessage->new(
	    Command => $command,
	    Params => ['',	# 
		       ($use_alias ? Auto::AliasDB->shared->stdreplace_add(
			   $msg->prefix || $sender->fullname,
			   $str,
			   $extra_callbacks,
			   $msg,
			   $sender,
			   %extra_replaces)
			    : $str)]);
	if ($sender->isa('IrcIO::Server')) {
	    # ˤϥͥ̾˥ͥåȥ̾դʤ
	    my $for_server = $msg_to_send->clone;
	    $for_server->param(0, scalar(Multicast::detach($sendto)));
	    $sender->send_message($for_server);

	    # 饤Ȥˤϥͥ̾˥ͥåȥ̾դ롣
	    # ޤ饤ȤˤPrefixΥ桼ꤵ褦դ롣
	    my $for_client = $msg_to_send->clone;
	    $for_client->param(0, $sendto);
	    $for_client->remark('fill-prefix-when-sending-to-client',1);
	    push @$result,$for_client;
	} elsif ($sender->isa('IrcIO::Client')) {
	    # ͥ̾˥ͥåȥ̾դ롣
	    my $for_server = $msg_to_send->clone;
	    $for_server->param(0, $sendto);
	    push @$result,$for_server;

	    my $for_client = $msg_to_send->clone;
	    $for_client->prefix($sender->fullname);
	    $for_client->param(0, $sendto);
	    $sender->send_message($for_client);
	}
    };
}

sub generate_reply_closures {
    # Ԥ NOTICE 륯֤ޤ

    # -  -
    # $msg	: message_arrivedϤäƤ$msg
    # $sender	: message_arrivedϤäƤ$sender
    # $result	: message_arrived֤ͤˤλȡܺ٤򸫤ޤ礦
    # $use_alias	: ꥢ֤ԤɤάġάϹԤ
    # $extra_callbacks
    #		: ɲäΥꥢִХåάġ
    # $ch_place	: ͥ̾¸ߤ $msg->param ΰ֤ꤷޤά0(Ƭ)Ǥ
    #
    # ꥢִХå˴ؤƤ Auto::AliasDB 򻲾ȤƤ
    #
    # - ֤ -
    # 	($get_raw_ch_name, $reply, $reply_as_priv, $reply_anywhere, $get_full_ch_name)
    # $get_raw_ch_name	: 㡣ͥåȥ̵̾Υͥ̾ or undef ֤ޤ
    # $reply		: 㡣ͥޤ
    # $reply_as_priv	: 㡣Ԥľ priv ޤ
    # $reply_anywhere	: 㡣ͥ뤬ͭǤ $reply Ǥʤ $reply_as_priv Ǥ
    # $get_full_ch_name	: 㡣ͥåȥ̾դΥͥ̾ or undef ֤ޤ
    #
    # $reply* ˥åʹߤɲäΥꥢ(άǽ)ꤷƸƤӽФޤ
    # undefϤ줿ϡ⤻˽λޤ
    #
    # -  -
    #       sub message_arrived {
    #           my ($this,$msg,$sender) = @_;
    #           my @result = ($msg);
    #           my ($get_ch_name, $reply, $reply_as_priv, $reply_anywhere) = 
    #               sendto_channel_closure($msg, $sender, \@result);
    #           $reply_anywhere->('message', 'hoge' => 'moge');
    #           return @result;
    #       }
    #
    # -  -
    # $get_raw_ch_name ʤΤϲȤθߴΤᡢ
    # $get_full_ch_name 㡼ʤΤ϶ΤǤ

    my ($msg, $sender, $result, $use_alias, $extra_callbacks, $ch_place) = @_;
    $use_alias = 1 unless defined $use_alias;
    $extra_callbacks = [] unless defined $extra_callbacks;
    $ch_place = 0 unless defined $ch_place;

    my $raw_ch_name = get_raw_ch_name($msg, $ch_place);
    my $get_raw_ch_name = sub {
	$raw_ch_name;
    };
    my $full_ch_name = get_full_ch_name($msg, $ch_place);
    my $get_full_ch_name = sub {
	$full_ch_name;
    };
    my $reply = sub {
	sendto_channel_closure($msg->param($ch_place), 'NOTICE', $msg, $sender, $result,
			       $use_alias, $extra_callbacks)->(@_, 'channel' => $raw_ch_name);
    };
    my $reply_as_priv = sub {
	my ($str, %extra_replaces) = @_;
	return if !defined $str;
	$sender->send_message(IRCMessage->new(
	    Command => 'NOTICE',
	    Params => [$msg->nick,
		       ($use_alias ? Auto::AliasDB->shared->stdreplace_add(
			   $msg->prefix,
			   $str,
			   $extra_callbacks,
			   $msg,
			   $sender,
			   %extra_replaces)
			    : $str)]));
    };
    my $reply_anywhere = sub {
	if (defined($raw_ch_name) && Multicast::nick_p($raw_ch_name)) {
	    return $reply_as_priv;
	} else {
	    return $reply;
	}
    };
    return ($get_raw_ch_name,$reply,$reply_as_priv,$reply_anywhere->(),$get_full_ch_name);
}

1;
