# -----------------------------------------------------------------------------
# $Id: Template.pm,v 1.1 2003/08/04 09:29:20 admin Exp $
# -----------------------------------------------------------------------------
package Template;
use strict;
use warnings;
use Unicode::Japanese;
use Symbol;
use Carp;
use UNIVERSAL;
our $AUTOLOAD;

sub new {
    # $fpath: ƥץ졼ȤȤƻѤե
    # $strip_empty_line (άǽ): <!begin><!end>ľβԤ뤫ɤ
    my ($class,$fpath,$strip_empty_line) = @_;
    my $this = {
	original => undef, # ꡼դ<!mark:foo>ִȡ
	current => undef, # <&foo>ִΤΡ
	leaves => {}, # {̾ => Template}
	parent => undef, # 줬ȥåץ٥ǤʤС(Template)
	leafname => undef, # 줬ȥåץ٥ǤʤС꡼̾
    };
    bless $this,$class;

    local $/ = undef;
    my $fh = gensym;
    open($fh,'<',$fpath) or croak "couldn't open file $fpath";
    my $source = <$fh>;
    close($fh);
    ungensym($fh);

    # <!begin:foo><!end:foo>ľ夬ԥɤʤ顢ä
    # βԥɤϤޤ륹ڡޤϥ֤⡢ǥȤȸƾä
    if ($strip_empty_line) {
	$source =~ s/(<!begin:.+?>|<!end:.+?>)\x0d?\x0a[ \t]*/$1/g;
    }
    
    $this->_load($source);
    $this;
}

sub reset {
    my $this = shift;
    $this->{current} = $this->{original};
    $this;
}

sub expand {
    # $t->expand({foo => '---' , bar => '+++'});
    # ⤷
    # $t->expand(foo => '---' , bar => '+++');

    # Υ᥽åɤϡ˸줿
    # ϥե˥եХåޤ
    # Ĥޤꡢ<&foo-bar>Ȥ򡢥̾"foo_bar"ǻꤹޤ
    my $this = shift;
    my $hash = do {
	if (@_ == 1 && UNIVERSAL::isa($_[0],'HASH')) {
	    $_[0];
	}
	elsif (@_ % 2 == 0) {
	    my %h = @_;
	    \%h;
	}
	else {
	    croak "Illegal argument for Template->expand";
	}
    };
    while (my ($key,$value) = each %$hash) {
	# $key,$value˥顼ͤǤʤФʤʤ
	# եʤ饨顼
	if (!defined $value) {
	    croak "Values must not be undef; key: $key";
	}
	if (ref($key) ne '') {
	    croak "Keys and values must be scalar values: $key";
	}
	if (ref($value) ne '') {
	    croak "Keys and values must be scalar values: $value";
	}

	if ($this->{current} !~ s/<\&\Q$key\E>/$value/g) {
	    # ̵ϥեѤƤߤ롣
	    (my $tred_key = $key) =~ tr/_/-/;
	    if ($this->{current} !~ s/<\&\Q$tred_key\E>/$value/g) {
		# Τ褦ʥ¸ߤʤäٹ
		carp "No <\&$key> are in template, or you have replaced it already.";
	    }
	}
    }
    $this;
}

sub add {
    my $this = shift;
    
    # expand롣
    if (@_ > 0) {
	eval {
	    $this->expand(@_);
	}; if ($@) {
	    croak $@;
	}
    }

    # Ƥ¸ߤʤcroak
    if (!defined $this->{parent}) {
	croak "This template doesn't have its parent.";
    }

    # Ƥ<!mark:foo>ľˡΥ꡼դ
    my $str = $this->str;
    $this->{parent}{current} =~ s/(<!mark:\Q$this->{leafname}\E>)/$str$1/g;

    # ꥻå
    $this->reset;

    $this;
}

sub str {
    my $this = shift;
    my $result = $this->{current};

    # ִ̤<&foo>Фäcarp
    while ($result =~ s/<\&(.+?)>//) {
	carp "Unexpanded tag: <\&$1>";
    }

    # <!mark:foo>ä
    $result =~ s/<!mark:.+?>//g;

    $result;
}

sub leaf {
    my ($this,$leafname) = @_;
    $this->{leaves}{$leafname};
}

sub AUTOLOAD {
    my $this = shift;
    (my $leafname = $AUTOLOAD) =~ s/.+?:://g;

    # ϥϥեִ
    $leafname =~ tr/_/-/;
    $this->{leaves}{$leafname};
}

sub _new_leaf {
    my ($class,$parent,$leafname,$source) = @_;
    my $this = {
	original => undef,
	current => undef,
	leaves => {},
	parent => $parent,
	leafname => $leafname,
    };
    bless $this,$class;

    $this->_load($source);
}

sub _load {
    my ($this,$source) = @_;

    # <!begin:foo> ... <!end:foo><!mark:foo>ִĤġΥ꡼դ¸
    while ($source =~ s/<!begin:(.+?)>(.+?)<!end:\1>/<!mark:$1>/s) {
	my ($leafname,$source) = ($1,$2);
	
	if (defined $this->{leaves}{$leafname}) {
	    # ˤΥ꡼դƤcroak
	    croak "duplicated leaves in template: $leafname";
	}
	else {
	    $this->{leaves}{$leafname} = Template->_new_leaf($this,$leafname,$source);
	}
    }
    $this->{original} = $this->{current} = $source;
    
    $this;
}

1;
