# -----------------------------------------------------------------------------
# $Id: RunLoop.pm,v 1.49 2003/11/09 08:24:54 topia Exp $
# -----------------------------------------------------------------------------
# Υ饹TiarraΥᥤ롼פޤ
# select()¹ԤС䥯饤ȤȤI/OԤΤϤΥ饹Ǥ
# -----------------------------------------------------------------------------
# եå`before-select'ڤ`after-select'ѲǽǤ
# Υեåϡ줾select()¹ľľ˸ƤФޤ
# -----------------------------------------------------------------------------
package RunLoop;
use strict;
use warnings;
use UNIVERSAL;
use Carp;
use IO::Socket::INET;
use IO::Select;
use Configuration;
use IrcIO;
use IrcIO::Server;
use IrcIO::Client;
use Unicode::Japanese;
use ModuleManager;
use Multicast;
use Timer;
use ControlPort;
use Hook;
our @ISA = 'HookTarget';
our $_shared_instance;

BEGIN {
    # Time::HiResϻȤ뤫
    eval q{
        use Time::HiRes qw(time);
    }; if ($@) {
	# Ȥʤ
    }
}

*shared = \&shared_loop;
sub shared_loop {
    if (!defined $_shared_instance) {
	$_shared_instance = _new RunLoop;
    }
    $_shared_instance;
}

sub _new {
    my $class = shift;
    my $this = {
	# ѥ쥯륽åȤϾ˼ɬפ뤿ᡢ륽åȤϿƤ롣
	receive_selector => new IO::Select,

	# ѥ쥯åȤФ٤ǡϸ¤ƤơξˤΤϿƽ꼡롣
	send_selector => new IO::Select,

	# Tiarraꥹ˥󥰤ƥ饤Ȥդ뤿ΥåȡIO::Socket
	tiarra_server_socket => undef,

	# ߤnickƤΥСȥ饤Ȥδ֤ݤĤnickѹʤRunLoopѰդ롣
	current_nick => Configuration->shared_conf->general->nick,

	# Ǥ줿ư
	action_on_disconnected => do {
	    my $actions = {
		'part-and-join' => \&_action_part_and_join,
		'one-message' => \&_action_one_message,
		'message-for-each' => \&_action_message_for_each,
	    };
	    my $action_name = Configuration->shared_conf->networks->action_when_disconnected;
	    unless (defined $action_name) {
		$action_name = 'part-and-join';
	    }
	    my $act = $actions->{$action_name};
	    if (defined $act) {
		$act;
	    }
	    else {
		die "Unknown action specified as networks/action-when-disconnected: $action_name\n";
	    }
	},

	multi_server_mode => 1, # ޥС⡼ɤäƤ뤫ݤ

	networks => {}, # ͥåȥ̾  IrcIO::Server
	disconnected_networks => {}, # Ǥ줿ͥåȥ
	clients => [], # ³ƤƤΥ饤 IrcIO::Client

	timers => [], # 󥹥ȡ뤵ƤƤTimer
	external_sockets => [], # 󥹥ȡ뤵ƤƤExternalSocket
	#hooks_before_select => [], # 󥹥ȡ뤵ƤƤbefore-selectեå
	#hooks_after_select => [], # 󥹥ȡ뤵ƤƤafter-selectեå

	conf_reloaded_hook => undef, # βǥ󥹥ȡ뤹եå
    };
    bless $this, $class;

    $this->{conf_reloaded_hook} = Configuration::Hook->new(
	sub {
	    # ޥС⡼ɤOn/OffѤä
	    my $old = $this->{multi_server_mode} ? 1 : 0;
	    my $new = Configuration->shared->networks->multi_server_mode ? 1 : 0;
	    if ($old != $new) {
		# Ѥä
		$this->_multi_server_mode_changed;
	    }
	},
       )->install;

    $this;
}

sub DESTROY {
    my $this = shift;
    if (defined $this->{conf_reloaded_hook}) {
	$this->{conf_reloaded_hook}->uninstall;
    }
}

sub network {
    my ($this,$network_name) = @_;
    $this->{networks}->{$network_name};
}

sub networks {
    shift->{networks};
}

sub networks_list {
    values %{shift->{networks}};
}

sub clients {
    shift->{clients};
}

sub clients_list {
    @{shift->{clients}};
}

sub channel {
    # $ch_long: ͥåȥ̾դͥ̾
    # դäChannelInfoդʤundef֤
    my ($this,$ch_long) = @_;

    my ($ch_short,$net_name) = Multicast::detach($ch_long);
    my $network = $this->{networks}->{$net_name};
    if (!defined $network) {
	return undef;
    }

    $network->channel($ch_short);
}

sub current_nick {
    # 饤Ȥ鸫ߤnick
    # nickϼºݤ˻ȤƤnickȤϰۤʤäƤ礬롣
    # ʤ˾nick˻ȤƤǤ롣
    shift->{current_nick};
}

sub set_current_nick {
    my ($this,$new_nick) = @_;
    $this->{current_nick} = $new_nick;
}

sub change_nick {
    my ($this,$new_nick) = @_;

    foreach my $io (values %{$this->{networks}}) {
	$io->send_message(
	    new IRCMessage(
		Command => 'NICK',
		Param => $new_nick));
    }
}

sub multi_server_mode_p {
    shift->{multi_server_mode};
}

sub find_io_with_socket {
    my ($this,$sock) = @_;
    # networksclients椫ꤵ줿åȤIrcIOõޤ
    # դʤundef֤ޤ
    foreach my $io (values %{$this->{networks}}) {
	return $io if $io->sock == $sock;
    }
    foreach my $io (@{$this->{clients}}) {
	return $io if $io->sock == $sock;
    }
    undef;
}

sub _multi_server_mode_changed {
    my $this = shift;
    # öƤΥͥˤĤPARTȯԤ塢
    # ⡼ɤѤ³ͥåȥ򹹿NICKJOINȯԤ롣
    my $new = !$this->{multi_server_mode};

    foreach my $string (
	'Multi server mode *'.($new ? 'enabled' : 'disabled').'*',
	q{It looks as if you would part all channels, but it's just an illusion.}) {
	$this->broadcast_to_clients(
	    IRCMessage->new(
		Command => 'NOTICE',
		Params => [$this->current_nick, $string]));
    }

    my $iterate = sub {
	my $func = shift;
	foreach my $network ($this->networks_list) {
	    foreach my $ch ($network->channels_list) {
		foreach my $client ($this->clients_list) {
		    $func->($network, $ch, $client);
		}
	    }
	}
    };

    $iterate->(
	sub {
	    my ($network, $ch, $client) = @_;
	    $client->send_message(
		IRCMessage->new(
		    Prefix => $client->fullname,
		    Command => 'PART',
		    Params => [
			do {
			    if ($new) {
				# ޤǤϥͥåȥ̾դƤʤä
				$ch->name;
			    }
			    else {
				scalar Multicast::attach(
				    $ch->name, $network->network_name);
			    }
			},
			'[Caused by Tiarra] Clients have to part all channels.',
		       ],
		   )
	       );
	}
       );
    $this->{multi_server_mode} = $new;
    $this->update_networks;
    my $global_nick = (($this->networks_list)[0])->current_nick;
    if ($global_nick ne $this->current_nick) {
	$this->broadcast_to_clients(
	    IRCMessage->new(
		Command => 'NICK',
		Param => $global_nick,
		Remarks => {'fill-prefix-when-sending-to-client' => 1
			   }));

	$this->set_current_nick($global_nick);
    }
    foreach my $client ($this->clients_list) {
	$client->inform_joinning_channels;
    }
}

sub _update_send_selector {
    my $this = shift;
    # ɬפΤIrcIOȴФΥåȤ쥯Ͽ롣

    #my $add_or_remove = sub {
    #	my $io = shift;
    #	my $action = ($io->need_to_send ? 'add' : 'remove');
    #	$this->{send_selector}->$action($io->sock);
    #};

    #foreach my $io (values %{$this->{networks}}) {
    #	$add_or_remove->($io);
    #}
    #foreach my $io (@{$this->{clients}}) {
    #	$add_or_remove->($io);
    #}

    # ɤ⤳ư̵˺ѤʤƤɤ褦ʵ롣
    my $sel = $this->{send_selector} = IO::Select->new;
    foreach my $io (values %{$this->{networks}}) {
	if ($io->need_to_send) {
	    $sel->add($io->sock);
	}
    }
    foreach my $io (@{$this->{clients}}) {
	if ($io->need_to_send) {
	    $sel->add($io->sock);
	}
    }
    foreach my $esock (@{$this->{external_sockets}}) {
	if ($esock->want_to_write) {
	    $sel->add($esock->sock);
	}
    }
}

sub _cleanup_closed_link {
    # networksclients椫Ǥ줿󥯤õ
    # ΥåȤ򥻥쥯鳰
    # networksʤ饯饤Ȥ٤Τ򤷡³륿ޡ򥤥󥹥ȡ뤹롣
    my $this = shift;

    my %networks_closed = ();
    while (my ($network_name,$io) = each %{$this->{networks}}) {
	$networks_closed{$network_name} = $io unless $io->connected;
    }
    my $do_update_networks = 0;
    while (my ($network_name,$io) = each %networks_closed) {
	# 쥯鳰
	$this->{receive_selector}->remove($io->sock);
	$this->{send_selector}->remove($io->sock);
	# networksϺơdisconnected_networks롣
	delete $this->{networks}->{$network_name};
	$this->{disconnected_networks}->{$network_name} = $io;
	$do_update_networks = 1;
    }
    if ($do_update_networks) {
	Timer->new(
	    After => 3,
	    Code => sub {
		$this->update_networks;
	    },
	)->install($this);
    }

    for (my $i = 0; $i < @{$this->{clients}}; $i++) {
	my $io = $this->{clients}->[$i];
	unless ($io->connected) {
	    ::printmsg("Connection with ".$io->fullname." has been closed.");
	    $this->{receive_selector}->remove($io->sock);
	    splice @{$this->{clients}},$i,1;
	    $i--;
	}
    }
}

sub _action_part_and_join {
    # $event: 'connected' 㤷 'disconnected'
    # ΤȤΥ᥽åɤconfκˤǻˤήѤƤ롣
    my ($this,$network,$event) = @_;
    my $network_name = $network->network_name;
    if ($event eq 'connected') {
	$this->_rejoin_all_channels($network);
    }
    elsif ($event eq 'disconnected') {
	foreach my $client (@{$this->clients}) {
	    foreach my $ch (values %{$network->channels}) {
		$client->send_message(
		    IRCMessage->new(
			Prefix => $client->fullname,
			Command => 'PART',
			Params => [Multicast::attach($ch->name,$network_name),
				   $network->host." closed the connection."]));
	    }
	}
    }
}
sub _action_one_message {
    my ($this,$network,$event) = @_;
    my $network_name = $network->network_name;
    if ($event eq 'connected') {
	$this->_rejoin_all_channels($network);
	$this->broadcast_to_clients(
	    IRCMessage->new(
		Command => 'NOTICE',
		Params => [$this->current_nick,
			   '*** The connection has been revived between '.$network->network_name.'.']));
    }
    elsif ($event eq 'disconnected') {
	$this->broadcast_to_clients(
	    IRCMessage->new(
		Command => 'NOTICE',
		Params => [$this->current_nick,
			   '*** The connection has been broken between '.$network->network_name.'.']));
    }
}
sub _action_message_for_each {
    my ($this,$network,$event) = @_;
    my $network_name = $network->network_name;
    if ($event eq 'connected') {
	$this->_rejoin_all_channels($network);

	my $msg = IRCMessage->new(
	    Prefix => 'Tiarra',
	    Command => 'NOTICE',
	    Params => ['', # ͥ̾ϸꡣ
		       '*** The connection has been revived between '.$network->network_name.'.']);
	foreach my $ch (values %{$network->channels}) {
	    $msg->param(0,Multicast::attach($ch->name,$network_name));
	    $this->broadcast_to_clients($msg);
	}
    }
    elsif ($event eq 'disconnected') {
	my $msg = IRCMessage->new(
	    Prefix => 'Tiarra',
	    Command => 'NOTICE',
	    Params => ['', # ͥ̾ϸꡣ
		       '*** The connection has been broken between '.$network->network_name.'.']);
	foreach my $ch (values %{$network->channels}) {
	    $msg->param(0,Multicast::attach($ch->name,$network_name));
	    $this->broadcast_to_clients($msg);
	}
    }
}
sub _rejoin_all_channels {
    my ($this,$network) = @_;
    # networkƤƤΥͥJOIN롣
    # ⤽JOINƤʤͥ̾IrcIO::ServerϵƤʤ
    # СǤ줿㳰Ǥ롣
    # kicked-outդƤͥˤJOINʤ
    my @ch_with_key; # ѥɤäͥǤ["ͥ̾","ѥ"]
    my @ch_without_key; # ѥɤʤͥǤ"ͥ̾"
    foreach my $ch (values %{$network->channels}) {
	next if $ch->remarks('kicked-out');

	my $password = $ch->parameters('k');
	if (defined $password && $password ne '') {
	    push @ch_with_key,[$ch->name,$password];
	}
	else {
	    push @ch_without_key,$ch->name;
	}
    }
    # JOIN¹
    my ($buf_ch,$buf_key) = ('','');
    my $buf_flush = sub {
	return if ($buf_ch eq '');
	my $params = do {
	    if ($buf_key eq '') {
		[$buf_ch];
	    }
	    else {
		[$buf_ch,$buf_key];
	    }
	};
	$network->send_message(
	    IRCMessage->new(
		Command => 'JOIN',
		Params => $params));
	$buf_ch = $buf_key = '';
    };
    my $buf_put = sub {
	my ($ch,$key) = @_;
	$buf_ch .= ($buf_ch eq '' ? $ch : ",$ch");
	$buf_key .= ($buf_key eq '' ? $key : ",$key") if defined $key;
	if (length($buf_ch) + length($buf_key) > 400) {
	    # 400ХȤۤ鼫ưǥեå夹롣
	    $buf_flush->();
	}
    };
    # ѥդΥͥJOIN
    foreach (@ch_with_key) {
	$buf_put->($_->[0],$_->[1]);
    }
    $buf_flush->();
    # ѥ̵ΥͥJOIN
    foreach (@ch_without_key) {
	$buf_put->($_);
    }
    $buf_flush->();
}

sub update_networks {
    my $this = shift;
    # networks/nameɤߡˤޤ³ƤʤͥåȥФ³
    # ³ΥͥåȥǴnetworks/name󤵤ƤʤΤФǤ롣
    my $general_conf = Configuration::shared_conf->get('general');
    my @net_names = Configuration::shared_conf->get('networks')->name('all');
    my $do_update_networks_after = 0; # ÿ
    my $do_cleanup_closed_links_after = 0;
    my $host_tried = {}; # {³ߤۥ̾ => 1}

    # ޥС⡼ɤǤʤС@net_namesǤϰĤ˸¤٤
    # ǤʤзٹФƬΤΤĤƸϼΤƤ롣
    if (!$this->{multi_server_mode} && @net_names > 1) {
	$this->notify_warn("In single server mode, Tiarra will connect to just a one network; `".
			     $net_names[0]."'");
	@net_names = $net_names[0];
    }

    foreach my $net_name (@net_names) {
	my $net_conf = Configuration::shared_conf->get($net_name);

	if (defined($_ = $this->{networks}->{$net_name})) {
	    # ³Ƥ롣
	    # ΥСˤĤƤ꤬ѤäƤ顢ö³ڤ롣
	    if (!$net_conf->equals($_->config)) {
		$_->disconnect;
		$do_cleanup_closed_links_after = 1;
	    }
	    next;
	}

	# Ǥ줿ͥåȥΤʤ
	my $network = $this->{disconnected_networks}->{$net_name};
	eval {
	    if (defined $network) {
		# ³
		$network->reload_config;
		$network->connect;
		# disconnected_networksnetworksذܤ
		$this->{networks}->{$net_name} = $network;
		delete $this->{disconnected_networks}->{$net_name};
	    }
	    else {
		if ($host_tried->{$net_conf->host}) {
		    $do_update_networks_after = 15;
		    $network = undef;
		}
		else {
		    $host_tried->{$net_conf->host} = 1;

		    $network = IrcIO::Server->new($net_name);
		    $this->{networks}->{$net_name} = $network; # networksϿ
		}
	    }
	    if (defined $network) {
		$this->{receive_selector}->add($network->sock); # 쥯Ͽ
	    }
	}; if ($@) {
	    print $@;
	    # ޡľ
	    $do_update_networks_after = 3;
	}
    }

    if ($do_update_networks_after) {
	Timer->new(
	    After => $do_update_networks_after,
	    Code => sub {
		$this->update_networks;
	    },
	)->install($this);
    }

    if ($do_cleanup_closed_links_after) {
	$this->_cleanup_closed_link;
    }

    my @nets_to_disconnect;
    my @nets_to_forget;
    my $is_there_in_net_names = sub {
	my $network_name = shift;
	# Υͥåȥ@net_names󤵤Ƥ뤫
	foreach my $enumerated_net (@net_names) {
	    return 1 if $network_name eq $enumerated_net;
	}
	return 0;
    };
    # networksפʥͥåȥ
    while (my ($net_name,$server) = each %{$this->{networks}}) {
	# äƤʤäselector鳰Ǥ롣
	unless ($is_there_in_net_names->($net_name)) {
	    push @nets_to_disconnect,$net_name;
	}
    }
    foreach my $net_name (@nets_to_disconnect) {
	my $server = $this->{networks}->{$net_name};
	$this->disconnect_server($server);
	# ưͥؤPART
	$this->_action_part_and_join($server, 'disconnected');
    }
    # disconnected_networksפʥͥåȥ
    while (my ($net_name,$server) = each %{$this->{disconnected_networks}}) {
	# äƤʤä˺롣
	unless ($is_there_in_net_names->($net_name)) {
	    push @nets_to_forget,$net_name;
	}
    }
    foreach (@nets_to_forget) {
	delete $this->{disconnected_networks}->{$_};
    }
}

sub disconnect_server {
    # ꤵ줿СȤ³ڤ롣
    # fdδƻƤޤΤǡθIrcIO::ServerreceiveϤ⤦ƤФʤա
    # $server: IrcIO::Server
    my ($this,$server) = @_;
    $this->{receive_selector}->remove($server->sock);
    $this->{send_selector}->remove($server->sock);
    $server->disconnect;
    delete $this->{networks}->{$server->network_name};
}

sub reconnected_server {
    my ($this,$network) = @_;
    # ³äν
    $this->{action_on_disconnected}->($this,$network,'connected');
}

sub disconnected_server {
    my ($this,$network) = @_;
    $this->{action_on_disconnected}->($this,$network,'disconnected');
}

sub install_socket {
    my ($this,$esock) = @_;
    if (!defined $esock) {
	croak "RunLoop->install_socket, Arg[1] was undef.\n";
    }

    push @{$this->{external_sockets}},$esock;
    $this->{receive_selector}->add($esock->sock); # 쥯Ͽ
    undef;
}

sub uninstall_socket {
    my ($this,$esock) = @_;
    if (!defined $esock) {
	croak "RunLoop->uninstall_socket, Arg[1] was undef.\n";
    }

    for (my $i = 0; $i < @{$this->{external_sockets}}; $i++) {
	if ($this->{external_sockets}->[$i] == $esock) {
	    splice @{$this->{external_sockets}},$i,1;
	    $this->{receive_selector}->remove($esock->sock); # 쥯Ͽ
	    $i--;
	}
    }
    $this;
}

sub find_esock_with_socket {
    my ($this,$sock) = @_;
    foreach my $esock (@{$this->{external_sockets}}) {
	if ($esock->sock == $sock) {
	    return $esock;
	}
    }
    undef;
}

=pod
sub install_hook {
    my ($this,$hook_name,$hook) = @_;
    my $array = do {
	if ($hook_name eq 'before-select') {
	    $this->{hooks_before_select};
	}
	elsif ($hook_name eq 'after-select') {
	    $this->{hooks_after_select};
	}
	else {
	    croak "RunLoop->install_hook, hook name '$hook_name' is invalid.\n";
	}
    };
    push @$array,$hook;
    $this;
}

sub uninstall_hook {
    my ($this,$hook_name,$hook) = @_;
    my $array = do {
	if ($hook_name eq 'before-select') {
	    $this->{hooks_before_select};
	}
	elsif ($hook_name eq 'after-select') {
	    $this->{hooks_after_select};
	}
	else {
	    croak "RunLoop->uninstall_hook, hook name '$hook_name' is invalid.\n";
	}
    };
    @$array = grep {
	$_ != $hook;
    } @$array;
    $this;
}

sub call_hooks {
    my ($this,$hook_name) = @_;
    my $array = do {
	if ($hook_name eq 'before-select') {
	    $this->{hooks_before_select};
	}
	elsif ($hook_name eq 'after-select') {
	    $this->{hooks_after_select};
	}
	else {
	    croak "RunLoop->call_hooks, hook name '$hook_name' is invalid.\n";
	}
    };
    foreach my $hook (@$array) {
	eval {
	    $hook->call;
	}; if ($@) {
	    die "RunLoop: Exception in calling hook.\n$@\n";
	}
    }
}

=cut

sub install_timer {
    my ($this,$timer) = @_;
    push @{$this->{timers}},$timer;
    $this;
}

sub uninstall_timer {
    my ($this,$timer) = @_;
    for (my $i = 0; $i < scalar(@{$this->{timers}}); $i++) {
	if ($this->{timers}->[$i] == $timer) {
	    splice @{$this->{timers}},$i,1;
	    $i--;
	}
    }
    $this;
}

sub get_earliest_timer {
    # ϿƤǺǤⵯư֤ᤤޡ֤
    # ޡĤ̵undef֤
    my $this = shift;
    return undef if (scalar(@{$this->{timers}}) == 0);

    my $eariest = $this->{timers}->[0];
    foreach my $timer (@{$this->{timers}}) {
	if ($timer->time_to_fire < $eariest->time_to_fire) {
	    $eariest = $timer;
	}
    }
    return $eariest;
}

sub _execute_all_timers_to_fire {
    my $this = shift;

    # execute٤ޡ򽸤
    my @timers_to_execute = ();
    foreach my $timer (@{$this->{timers}}) {
	push @timers_to_execute,$timer if $timer->time_to_fire <= time;
    }

    # ¹
    foreach my $timer (@timers_to_execute) {
	$timer->execute;
    }
}

sub run {
    my $this = shift;
    my $conf_general = Configuration::shared_conf->get('general');

    # ޥС⡼
    $this->{multi_server_mode} =
      Configuration::shared->networks->multi_server_mode;

    # ޤtiarra-portlisten륽åȤ롣
    # άƤlistenʤ
    # ͤͤǤʤädie
    my $tiarra_port = $conf_general->tiarra_port;
    if (defined $tiarra_port) {
	if ($tiarra_port !~ /^\d+/) {
	    die "general/tiarra-port must be integer. '$tiarra_port' is invalid.\n";
	}

	# v4v6βȤ
	my @serversocket_args = (
	    LocalPort => $tiarra_port,
	    Proto => 'tcp',
	    Reuse => 1,
	    Listen => 0);
	my $ip_version = $conf_general->tiarra_ip_version || 'v4';
	my $tiarra_server_socket = do {
	    if ($ip_version eq 'v4') {
		my $bind_addr = $conf_general->tiarra_ipv4_bind_addr;
		my @args = do {
		    if (defined $bind_addr) {
			@serversocket_args,LocalAddr => $bind_addr;
		    }
		    else {
			@serversocket_args;
		    }
		};
		IO::Socket::INET->new(@args);
	    }
	    elsif ($ip_version eq 'v6') {
		if (!&::ipv6_enabled) {
		    ::printmsg("*** IPv6 support is not enabled ***");
		    ::printmsg("Set general/tiarra-ip-version to 'v4' or install Socket6.pm if possible.\n");
		    die;
		}
		my $bind_addr = $conf_general->tiarra_ipv6_bind_addr;
		my @args = do {
		    if (defined $bind_addr) {
			@serversocket_args,LocalAddr => $bind_addr;
		    }
		    else {
			@serversocket_args;
		    }
		};
		IO::Socket::INET6->new(@args);
	    }
	    else {
		die "Unknown ip-version '$ip_version' specified as general/tiarra-ip-version.\n";
	    }
	};
	if (defined $tiarra_server_socket) {
	    $tiarra_server_socket->autoflush(1);
	    $this->{tiarra_server_socket} = $tiarra_server_socket;
	    $this->{receive_selector}->add($tiarra_server_socket); # 쥯Ͽ
	    main::printmsg("Tiarra started listening ${tiarra_port}/tcp. (IP$ip_version)");
	}
	else {
	    # åȺʤä
	    die "Couldn't make server socket to listen ${tiarra_port}/tcp. (IP$ip_version)\n";
	}
    }

    # ³
    $this->update_networks;

    # 3ʬƤλPING륿ޡ򥤥󥹥ȡ롣
    # tcp³Ǥ˵դʤ뤿ᡣ
    # PONGϼΤƤ롣ΤPONG˴󥿤򥤥󥯥Ȥ롣
    # PONG˴󥿤IrcIO::Serverremarkǡ'pong-drop-counter'
    Timer->new(
	Interval => 3 * 60,
	Code => sub {
	    foreach my $network (values %{$this->{networks}}) {
		$network->send_message(
		    IRCMessage->new(
			Command => 'PING',
			Param => $network->host));

		my $cntr = $network->remark('pong-drop-counter');
		if (defined $cntr) {
		    $cntr++;
		}
		else {
		    $cntr = 1;
		}
		$network->remark('pong-drop-counter',$cntr);
	    }
	},
	Repeat => 1,
    )->install;

    # control-socket-nameꤵƤ顢ControlPort򳫤
    if ($conf_general->control_socket_name) {
	eval {
	    ControlPort->new($conf_general->control_socket_name);
	}; if ($@) {
	    ::printmsg($@);
	}
    }

    my $zerotime = {
	limit => 100,
	minimum_to_reset => 2,
	interval => 10,

	count => 0,
	last_warned => 0,
    };
    my $zerotime_warn = sub {
	my $elapsed = shift;

	if ($elapsed == 0) {
	    $zerotime->{count}++;
	    if ($zerotime->{count} >= $zerotime->{limit}) {
		$zerotime->{count} = 0;

		if ($zerotime->{last_warned} + $zerotime->{interval} < CORE::time) {
		    $zerotime->{last_warned} = CORE::time;

		    $this->notify_warn("Tiarra seems to be slowing down your system!");
		}
	    }
	}
	elsif ($elapsed < $zerotime->{minimum_to_reset}) {
	    $zerotime->{count} = 0;
	}
    };

    while (1) {
	# ή
	#
	# 񤭤߲ǽʥåȤ򽸤ơɬפн񤭹ࡣ
	# ɤ߹߲ǽʥåȤ򽸤ơ(ɤɬפϾˤΤ)ɤࡣ
	# ɤ̾IRCMessage֤äƤΤǡ
	# ɬפƤΥץ饰˽֤̤(ץ饰ϥե륿Ȥƹͤ롣)
	# 줬Сɤåäʤ顢ץ饰̤塢³ƤƤΥ饤Ȥˤž롣
	# 饤ȤĤ³ƤʤСIRCMessageϼΤƤ롣
	# 饤Ȥɤåäʤ顢ץ饰̤塢Ϥ٤Сž롣
	#
	# selectˤ륿ॢȤϼΤ褦ˤ롣
	# (ʤϲϿƤȻפ)ޡĤϿƤʤСॢȤundefǤ롣ʤॢȤʤ
	# ޡĤǤϿƤϡƤΥޡǺǤȯư֤ᤤΤĴ١
	# 줬ȯưޤǤλ֤selectΥॢȻ֤Ȥ롣
	my $timeout = undef;
	my $eariest_timer = $this->get_earliest_timer;
	if (defined $eariest_timer) {
	    $timeout = $eariest_timer->time_to_fire - time;
	}
	if ($timeout < 0) {
	    $timeout = 0;
	}

	$this->_update_send_selector; # 񤭹٤ǡ륽åȤsend_selectorϿ롣ǤʤåȤϽ
	# selectեåƤ
	$this->call_hooks('before-select');
	# select¹
	my $time_before_select = CORE::time;
	my ($readable_socks,$writable_socks) =
	    IO::Select->select($this->{receive_selector},$this->{send_selector},undef,$timeout);
	$zerotime_warn->(CORE::time - $time_before_select);
	# selectեåƤ
	$this->call_hooks('after-select');

	foreach my $sock ($this->{receive_selector}->can_read(0)) {
	    if (defined $this->{tiarra_server_socket} &&
		$sock == $this->{tiarra_server_socket}) {

		# 饤Ȥο³
		my $new_sock = $sock->accept;
		if (defined $new_sock) {
		    eval {
			my $client = new IrcIO::Client($new_sock);
			push @{$this->{clients}},$client;
			$this->{receive_selector}->add($new_sock);
		    }; if ($@) {
			print "$@\n";
		    }
		}
	    }
	    elsif (my $io = $this->find_io_with_socket($sock)) {
		eval {
		    $io->receive;

		    while (1) {
			my $msg = eval {
			    $io->pop_queue;
			}; if ($@) {
			    if (ref($@) && UNIVERSAL::isa($@,'QueueIsEmptyException')) {
				last;
			    }
			    else {
				::printmsg($@);
				last;
			    }
			}

			if (!defined $msg) {
			    next;
			}

			if ($io->isa("IrcIO::Server")) {
			    # ΥåPONGǤpong-drop-counter򸫤롣
			    if ($msg->command eq 'PONG') {
				my $cntr = $io->remark('pong-drop-counter');
				if (defined $cntr && $cntr > 0) {
				    # PONGϼΤƤ롣
				    $cntr--;
				    $io->remark('pong-drop-counter',$cntr);
				    next;
				}
			    }

			    # åMulticastΥե륿̤
			    my @received_messages =
				Multicast::from_server_to_client($msg,$io);
			    # ⥸塼̤
			    my $filtered_messages = $this->_apply_filters(\@received_messages,$io);
			    # 󥰥륵С⡼ɤʤ顢ͥåȥ̾곰
			    if (!$this->{multi_server_mode}) {
				@$filtered_messages = map {
				    Multicast::detach_network_name($_, $io);
				} @$filtered_messages;
			    }
			    # do-not-send-to-clients => 1դƤʤåƥ饤Ȥ롣
			    $this->broadcast_to_clients(
				grep {
				    !($_->remark('do-not-send-to-clients'));
				} @$filtered_messages);
			}
			else {
			    # 󥰥륵С⡼ɤʤ顢åMulticastΥե륿̤
			    my @received_messages =
				(!$this->{multi_server_mode}) ? Multicast::from_server_to_client($msg,$this->networks_list) : $msg;

			    # ⥸塼̤
			    my $filtered_messages = $this->_apply_filters(\@received_messages,$io);
			    # оݤȤʤ뻪롣
			    # NOTICEڤPRIVMSG֤äƤʤΤǡƱˤʳΥ饤Ȥž롣
			    # do-not-send-to-servers => 1դƤåϤ˴롣
			    foreach my $msg (@$filtered_messages) {
				if ($msg->remark('do-not-send-to-servers')) {
				    next;
				}

				my $cmd = $msg->command;
				if ($cmd eq 'PRIVMSG' || $cmd eq 'NOTICE') {
				    my $new_msg = undef; # ɬפˤʤä롣
				    foreach my $client (@{$this->{clients}}) {
					if ($client != $io) {
					    unless (defined $new_msg) {
						# ޤäƤʤä
						$new_msg = $msg->clone;
						$new_msg->prefix($io->fullname);
						# 󥰥륵С⡼ɤʤ顢ͥåȥ̾곰
						if (!$this->{multi_server_mode}) {
						    Multicast::detach_network_name($new_msg,$this->networks_list);
						}

					    }
					    $client->send_message($new_msg);
					}
				    }
				}

				Multicast::from_client_to_server($msg,$io);
			    }
			}
		    }
		}; if ($@) {
		    $this->notify_error($@);
		}
	    }
	    elsif (my $esock = $this->find_esock_with_socket($sock)) {
		eval {
		    $esock->read;
		}; if ($@) {
		    $this->notify_error($@);
		}
	    }
	}
	
	foreach my $sock ($this->{send_selector}->can_write(0)) {
	    if (my $io = $this->find_io_with_socket($sock)) {
		next unless $io->need_to_send;

		eval {
		    $io->send;
		}; if ($@) {
		    $this->notify_error($@);
		}
	    }
	    elsif (my $esock = $this->find_esock_with_socket($sock)) {
		next unless $esock->want_to_write;

		eval {
		    $esock->write;
		}; if ($@) {
		    $this->notify_error($@);
		}
	    }
	}

	# Ǥ줿åȤõơ٤Ԥʤ
	$this->_cleanup_closed_link;
	
	# ȯư٤ƤΥޡȯư
	$this->_execute_all_timers_to_fire;
    }
}

sub broadcast_to_clients {
    # IRCMessageǤʤƤΥ饤Ȥ롣
    # fill-prefix-when-sending-to-clientȤ᤬դƤ顢
    # Prefix򤽤Υ饤Ȥfullnameꤹ롣
    my ($this,@messages) = @_;
    foreach my $client (@{$this->{clients}}) {
	next if $client->logging_in;
	
	foreach my $msg (@messages) {
	    if ($msg->remark('fill-prefix-when-sending-to-client')) {
		$msg = $msg->clone;
		$msg->prefix($client->fullname);
	    }
	    $client->send_message($msg);
	}
    }
}

sub broadcast_to_servers {
    # IRCåƤΥС롣
    my ($this,@messages) = @_;
    foreach my $network (values %{$this->{networks}}) {
	foreach my $msg (@messages) {
	    $network->send_message($msg);
	}
    }
}

sub notify_modules {
    my ($this,$method,@args) = @_;
    my $mods = ModuleManager->shared->get_modules;
    foreach my $mod (@$mods) {
	eval {
	    $mod->$method(@args);
	}; if ($@) {
	    $this->notify_error("Exception in ".ref($mod).".\n".
				"when calling $method.\n".
				"   $@");
	}
    }
}

sub _apply_filters {
    # src_messagesѹʤ
    my ($this,$src_messages,$sender) = @_;
    my $mods = ModuleManager->shared_manager->get_modules;

    my $source = $src_messages;
    my $filtered = [];
    foreach my $mod (@$mods) {
	# sourceä餳ǽꡣ
	if (scalar(@$source) == 0) {
	    return $source;
	}
	
	foreach my $src (@$source) {
	    my @reply = ();
	    # ¹
	    eval {
		@reply = $mod->message_arrived($src,$sender);
		
	    }; if ($@) {
		$this->notify_error("Exception in ".ref($mod).".\n".
				    "The message was '".$src->serialize."'.\n".
				    "   $@");
	    }
	    
	    if (defined $reply[0]) {
		# ͤİʾ֤äƤ
		# IRCMessageΥ֥ȤʤɤǤʤХ顼
		foreach my $msg_reply (@reply) {
		    unless (UNIVERSAL::isa($msg_reply,'IRCMessage')) {
			$this->notify_error("Reply of ".ref($mod)."::message_arived contains illegal value.\n".
					    "It is ".ref($msg_reply).".");
			return $source;
		    }
		}
		
		# filteredɲá
		push @$filtered,@reply;
	    }	    
	}

	# sourcefilteredˡfiltered϶ˡ
	$source = $filtered;
	$filtered = [];
    }
    return $source;
}

sub notify_error {
    my ($this,$str) = @_;
    $this->notify_msg("===== ERROR =====\n$str");
}
sub notify_warn {
    my ($this,$str) = @_;
    $this->notify_msg(":: WARNING :: $str");
}
sub notify_msg {
    # Ϥ줿ʸSTDOUT˽ϤƱ饤ȤNOTICE롣
    # ԥLFǹԤʬ䤹롣
    # ʸɤUTF-8ǤʤФʤʤ
    my ($this,$str) = @_;
    $str =~ s/\n+$//s; # LFϾõ

    # STDOUT
    ::printmsg($str);

    # 饤Ȥ
    my $needed_sending = Configuration->shared_conf->general->notice_error_messages;
    if ($needed_sending) {
	my $client_charset = Configuration->shared_conf->general->client_out_encoding;
	if (@{$this->clients} > 0) {
	    $this->broadcast_to_clients(
		map {
		    IRCMessage->new(
			Command => 'NOTICE',
			Params => [$this->current_nick,
				   "*** $_"]);
		} split /\n/,$str
	    );
	}
    }
}

# -----------------------------------------------------------------------------
# RunLoop¹Ԥ٤˸ƤФեå
#
# my $hook = RunLoop::Hook->new(sub {
#     my $hook_itself = shift;
#     # 餫νԤʤ
# })->install('after-select'); # select¹ľˤΥեåƤ֡
# -----------------------------------------------------------------------------
package RunLoop::Hook;
#use strict;
#use warnings;
#use Carp;
use FunctionalVariable;
use base 'Hook';

our $HOOK_TARGET_NAME = 'RunLoop';
our @HOOK_NAME_CANDIDATES = qw/before-select after-select/;
our $HOOK_NAME_DEFAULT = 'after-select';
our $HOOK_TARGET_DEFAULT;
FunctionalVariable::tie(
    \$HOOK_TARGET_DEFAULT,
    FETCH => sub {
	RunLoop->shared;
    },
   );

=pod
sub new {
    my ($class,$code) = @_;
    my $this = {
	runloop => undef,
	hook_name => undef,

	code => $code,
    };

    if (!defined $code) {
	croak "RunLoop::Hook->new, Arg[0] was undef.\n";
    }
    elsif (ref($code) ne 'CODE') {
	croak "RunLoop::Hook->new, Arg[0] was bad type.\n";
    }

    bless $this,$class;
}

sub install {
    # $hook_name: 'before-select' ޤ 'after-select'
    #             줾selectľľ˸ƤФ롣ά줿undefϤ줿after-selectˤʤ롣
    # $runloop:   󥹥ȡ뤹RunLoopά줿RunLoop->shared
    my ($this,$hook_name,$runloop) = @_;
    $hook_name = 'after-select' if !defined $hook_name;
    $runloop = RunLoop->shared if !defined $runloop;

    if (defined $this->{runloop}) {
	croak "RunLoop::Hook->install, this hook is already installed.\n";
    }

    $this->{runloop} = $runloop;
    $this->{hook_name} = $hook_name;
    $runloop->install_hook($hook_name,$this);

    $this;
}

sub uninstall {
    my $this = shift;

    $this->{runloop}->uninstall_hook($this->{hook_name},$this);
    $this->{runloop} = undef;
    $this->{hook_name} = undef;

    $this;
}

sub call {
    my $this = shift;

    my ($caller_pkg) = caller;
    if ($caller_pkg->isa('RunLoop')) {
	$this->{code}->($this);
    }
    else {
	croak "Only RunLoop can call RunLoop::Hook->call\n";
    }
}

=cut

1;
