# -----------------------------------------------------------------------------
# $Id: ModuleManager.pm,v 1.12 2003/09/25 13:15:59 topia Exp $
# -----------------------------------------------------------------------------
# Υ饹ƤTiarra⥸塼ޤ
# ⥸塼ɤɤ˴ΤϤΥ饹Ǥ
# -----------------------------------------------------------------------------
package ModuleManager;
use strict;
use warnings;
use UNIVERSAL;
use Configuration;
use RunLoop;
our $_shared_instance;

*shared = \&shared_manager;
sub shared_manager {
    unless (defined $_shared_instance) {
	$_shared_instance = _new ModuleManager;
	$_shared_instance->update_modules;
    }
    $_shared_instance;
}

sub _new {
    my $class = shift;
    my $obj = {
	modules => [], # ߻ѤƤƤΥ⥸塼
	mod_configs => {}, # ߻ѤƤ⥸塼Configuration::Block
	mod_timestamps => {}, # ߻ѤƤ⥸塼뤪ӥ֥⥸塼νuse줿
	updated_once => 0, # update_modules¹Ԥ줿뤫
    };
    bless $obj,$class;
}

sub get_modules {
    # ⥸塼ؤλȤ֤ѹƤϤʤʤ
    shift->{modules};
}

sub get {
    my ($this,$modname) = @_;
    foreach (@{$this->{modules}}) {
	return $_ if ref $_ eq $modname;
    }
    undef;
}

sub terminate {
    # Tiarraλ˸Ƥֻ
    my $this = shift;
    foreach (@{$this->{modules}}) {
	eval {
	    $_->destruct;
	}; if ($@) {
	    print "$@\n";
	}
    }
    @{$this->{modules}} = ();
    %{$this->{mod_configs}} = ();
}

sub timestamp {
    my ($this,$module,$timestamp) = @_;
    if (defined $timestamp) {
	$this->{mod_timestamps}->{$module} = $timestamp;
    }
    $this->{mod_timestamps}->{$module};
}

sub update_modules {
    # +ǻꤵ줿⥸塼ɤߡmodulesƹ롣
    # ɬפʥ⥸塼뤬ޤɤƤʤХɤ
    # ϤɬפȤʤʤä⥸塼뤬˴롣
    # ܰʹߡĤޤ굯ưˤ줬¹Ԥ줿
    # ⥸塼Υɤ˴˴ؤˤåϤ롣
    my $this = shift;
    my $mod_configs = Configuration->shared_conf->get_list_of_modules;
    my ($new,$deleted,$changed,$not_changed) = $this->_check_difference($mod_configs);

    my $show_msg = sub {
	if ($this->{updated_once}) {
	    # ˰ٰʾ塢update_modules¹Ԥ줿롣
	    return sub {
		RunLoop->shared_loop
		    ->notify_msg( $_[0] );
	    };
	}
	else {
	    # ưʤΤǲ⤷ʤ̵̾ؿꡣ
	    return sub {};
	}
    }->();

    # $this->{modules}⥸塼̾ => ModuleΥơ֥ˡ
    my %loaded_mods = map {
	ref($_) => $_;
    } @{$this->{modules}};

    # ɲä줿⥸塼롢ľ줿⥸塼롢ѹʤä⥸塼
    # ⥸塼̾ => Moduleηǥơ֥ˤ롣
    my %new_mods = map {
	# ɲä줿⥸塼롣
	$show_msg->("Module ".$_->block_name." will be loaded newly.");	
	$_->block_name => $this->_load($_);
    } @$new;
    my %rebuilt_mods = map {
	# ľ⥸塼롣
	# %loaded_mods˸ŤʪäƤΤǡ˴롣
	$show_msg->("Configuration of the module ".$_->block_name." has been changed. It will be restarted.");
	$loaded_mods{$_->block_name}->destruct;
	$_->block_name => $this->_load($_);
    } @$changed;
    my %not_changed_mods = map {
	# ѹʤä⥸塼롣
	# %loaded_mods˼ʪäƤ롣
	$_->block_name => $loaded_mods{$_->block_name};
    } @$not_changed;

    # $mod_configs˽񤫤줿˽$this->{modules}ƹ
    # âɤ˼Ԥ⥸塼nullˤʤäƤΤǽ
    @{$this->{modules}} = grep { defined $_ } map {
	my $modname = $_->block_name;
	$not_changed_mods{$modname} || $rebuilt_mods{$modname} || $new_mods{$modname};
    } @$mod_configs;

    my $deleted_any = @$deleted > 0;
    foreach (@$deleted) {
	# 줿⥸塼롣
	# %loaded_mods˸ŤʪäƤΤ˴塢ɤ롣
	$show_msg->("Module ".$_->block_name." will be unloaded.");
	eval {
	    $loaded_mods{$_->block_name}->destruct;
	}; if ($@) {
	    $show_msg->($@);
	}
	$this->_unload($_);
    }

    if ($deleted_any > 0) {
	# ĤǤ⥢ɤ⥸塼뤬СỲȤʤʤä⥸塼뤬
	# 뤫ɤĴ١ĤǤ⤢mark and sweep¹ԡ
	my $fixed = $this->fix_USED_fields;
	if ($fixed) {
	    $this->gc;
	}
    }

    $this->{updated_once} = 1;
    $this;
}

sub _check_difference {
    # _check_difference¹Ի顢ߤΥ⥸塼꤬ɤΤ褦Ѳ
    # ͤ(<ɲ>,<>,<ѹ>,<̵ѹ>) 줾ARRAY<Configuration::Block>ؤλȤǤ롣
    # ɲäѹϤ줾쿷Configuration::Blockˤ(Τ̵Τ)ŤConfiguration::Block֤롣
    my ($this,$mod_configs) = @_;
    # ޤϿо줷⥸塼ȡѹ줿⥸塼õ
    my @new;
    my @changed;
    my @not_changed;
    foreach my $conf (@$mod_configs) {
	my $old_conf = $this->{mod_configs}->{$conf->block_name};
	if (defined $old_conf) {
	    # Υ⥸塼ϴƤ뤬ѹäƤϤʤ
	    if ($old_conf->equals($conf)) {
		# ѤäƤʤ
		push @not_changed,$conf;
	    }
	    else {
		# ƤѤä
		push @changed,$conf;
	    }
	}
	else {
	    # Ƹ⥸塼
	    push @new,$conf;
	}
    }
    # 줿⥸塼õ
    # Υ롼פŻ뤬ɤʬˤʤ롣
    my %names_of_old_modules
	= map { $_ => 1 } keys %{$this->{mod_configs}};
    foreach my $conf (@$mod_configs) {
	delete $names_of_old_modules{$conf->block_name};
    }
    my @deleted = map {
	$this->{mod_configs}->{$_};
    } keys %names_of_old_modules;
    # $this->{mod_configs}˿ͤꡣ
    %{$this->{mod_configs}} =
	map { $_->block_name => $_ } @$mod_configs;
    # λ
    return (\@new,\@deleted,\@changed,\@not_changed);
}

sub reload_modules_if_modified {
    # ɼΤƤ⥸塼뤬Сöɤƥɤľ
    # 󥹥󥹤ľ
    my $this = shift;

    my $show_msg = sub {
	RunLoop->shared_loop->notify_msg($_[0]);
    };

    my $mods_to_be_reloaded = {}; # ⥸塼̾ => 1
    my $check = sub {
	my ($modname,$timestamp) = @_;
	# ˹줿ΤȤƥޡƤȴ롣
	return if $mods_to_be_reloaded->{$modname};

	(my $mod_filename = $modname) =~ s|::|/|g;
	my $mod_fpath = $INC{$mod_filename.'.pm'};
	return if (!defined($mod_fpath) || !-f $mod_fpath);
	if ((stat($mod_fpath))[9] > $timestamp) {
	    # Ƥ롣ʤȤ⤳Υ⥸塼ϥɤ롣
	    $mods_to_be_reloaded->{$modname} = 1;
	    $show_msg->("$modname has been modified. It will be reloaded.");

	    my $trace;
	    $trace = sub {
		my $modname = shift;
		# Υ⥸塼%USEDƤ뤫
		my $USED = eval qq{ \\\%${modname}::USED };
		if (defined $USED) {
		    # USEDƤǤФƵŪ˥ޡդ롣
		    foreach my $used_elem (keys %$USED) {
			$show_msg->("$used_elem will be reloaded because of modification of $modname");
			$trace->($used_elem);
		    }
		}
	    };

	    $trace->($modname);
	}
    };

    while (my ($modname,$timestamp) = each %{$this->{mod_timestamps}}) {
	$check->($modname,$timestamp);
    }

    # ĤǤޡ줿⥸塼뤬С$this->{modules}β
    # ŪΥ⥸塼뤬ߤΤĴ٤뤿ˡ⥸塼̾ => ֤Υơ֥롣
    if (keys(%$mods_to_be_reloaded) > 0) {
	my $mod2index = {};
	for (my $i = 0; $i < @{$this->{modules}}; $i++) {
	    $mod2index->{ref $this->{modules}->[$i]} = $i;
	}

	# ޡ줿⥸塼ɤ뤬줬$mod2indexϿƤ
	# 󥹥󥹤ľ
	foreach my $modname (keys %$mods_to_be_reloaded) {
	    my $idx = $mod2index->{$modname};
	    if (defined $idx) {
		eval {
		    $this->{modules}->[$idx]->destruct;
		}; if ($@) {
		    $show_msg->($@);
		}

		my $conf_block = $this->{mod_configs}->{$modname};
		$this->_unload($conf_block);
		$this->{modules}->[$idx] = $this->_load($conf_block); # Ԥundef롣
	    }
	    else {
		# ɸ塢use
		# λ%USED¸롣@USE¸ʤ
		my %USED = eval qq{ \%${modname}::USED };
		$this->_unload($modname);
		eval qq{
		    use $modname;
		}; if ($@) {
		    $show_msg->($@);
		}
		eval qq{
                    \%${modname}::USED = \%USED;
                };
	    }
	}

	# ƤΥ⥸塼%USEDĴ٤ơ%USEDؤƤ⥸塼뤬
	# ˤΥ⥸塼򻲾ȤƤΤɤå
	# ⥸塼ιǺỲȤʤʤäƤС%USED롣
	# Τ褦ʻΤϥɻ%USED¸뤿Ǥ롣
	my $fixed = $this->fix_USED_fields;

	# %USEDդä顢ϤɬפȤʤʤä
	# ⥸塼뤬뤫Τʤgc¹ԡ
	if ($fixed) {
	    $this->gc;
	}

	# $this->{modules}ˤundefǤäƤ뤫ΤʤΤǡΤ褦ǤϽ롣
	@{$this->{modules}} = grep {
	    defined $_;
	} @{$this->{modules}};
    }
}

sub _load {
    # ⥸塼useƥ󥹥󥹤֤
    # Ԥundef֤
    my ($this,$mod_conf) = @_;
    my $mod_name = $mod_conf->block_name;

    # use
    eval qq {
	    use $mod_name;
    }; if ($@) {
	RunLoop->shared_loop->notify_error(
	    "Couldn't load module $mod_name because of exception.\n$@");
	return undef;
    }

    # ⥸塼̾ե̾Ѵ%INC򸡺
    # module/ǻϤޤäƤʤХ顼
    #(my $mod_filename = $mod_name) =~ s|::|/|g;
    #my $filepath = $INC{$mod_filename.'.pm'};
    #if ($filepath !~ m|^module/|) {
    #  RunLoop->shared_loop->notify_error(
    #      "Class $mod_name exists outside the module directory.\n$filepath\n");
    #  next;
    #}

    # Υ⥸塼ModuleΥ֥饹
    # ΤUNIVERSAL::isaϱդΤǼϤ@ISA򸡺롣
    # 5.6.0 for darwinǤϥ⥸塼ɤȱդ
    my $is_inherit_ok = sub {
	return 1 if UNIVERSAL::isa($mod_name,'Module');
	my @isa = eval qq{ \@${mod_name}::ISA };
	foreach (@isa) {
	    if ($_ eq 'Module') {
		::debug_printmsg('UNIVERSAL::isa tell a lie...');
		return 1;
	    }
	}
	undef;
    };
    unless ($is_inherit_ok->()) {
	RunLoop->shared_loop->notify_error(
	    "Class $mod_name doesn't inherit class Module.");
	return undef;
    }

    # 󥹥
    my $mod;
    eval {
	$mod = new $mod_name;
    }; if ($@) {
	RunLoop->shared_loop->notify_error(
	    "Couldn't instantiate module $mod_name because of exception.\n$@");
	return undef;
    }

    # Υ󥹥󥹤$mod_nameΤΤ
    if (ref($mod) ne $mod_name) {
	RunLoop->shared_loop->notify_error(
	    "A thing ".$mod_name."->new returned was not a instance of $mod_name.");
	return undef;
    }

    # timestampϿ
    $this->timestamp($mod_name,time);

    return $mod;
}

sub _unload {
    # ꤵ줿⥸塼롣
    # ⥸塼̾Configuration::BlockϤƤɤ
    my ($this,$modname) = @_;
    $modname = $modname->block_name if UNIVERSAL::isa($modname,'Configuration::Block');

    # Υ⥸塼useõ
    delete $this->{mod_timestamps}->{$modname};

    # Υ⥸塼Υե̾Ƥ
    (my $mod_filename = $modname) =~ s|::|/|g;
    $mod_filename .= '.pm';

    # ܥơ֥Ƥޤѿ䥵֥롼˥ʤʤ롣
    # ¿ʬǥ꤬
    #eval 'undef %'.$modname.'::;';
    # NGv5.6.0 built for darwinǤbus error롣
    # ʤäȤƤ˴Ǥ롣
    # ˥ܥơ֥ƤΥܥundef롣
    # ܥơ֥ʬΥϥ꡼뤬̵
    no strict;
    local(*stab) = eval qq{\*${modname}::};
    my $defined_on;
    while (my ($key,$val) = each(%stab)) {
	local(*entry) = $val;
	if (defined $entry) {
	    ::debug_printmsg("unload scalar: $key");
	    undef $entry;
	}
	if (defined @entry) {
	    ::debug_printmsg("unload array: $key");
	    undef @entry;
	}
	if (defined &entry) {
	    $defined_on = eval q{
		use B;
		B::svref_2object(\&entry)->FILE
	    };
	    if ($defined_on && $defined_on eq $INC{$mod_filename}) {
		::debug_printmsg("unload subroutine: $key");
		undef &entry;
	    } else {
		::debug_printmsg("not-unload subroutine: $key, on " .
				     ($defined_on || '(undefined)'));
	    }
	}
	if ($key ne "${modname}::" && defined %entry) {
	    ::debug_printmsg("unload symtable: $key");
	    undef %entry;
	}
    }

    # %INC
    delete $INC{$mod_filename};
}

sub fix_USED_fields {
    my $this = shift;
    my $result;
    foreach my $modname (keys %{$this->{mod_timestamps}}) {
	my $USED = eval qq{ \\\%${modname}::USED };
	if (defined $USED) {
	    my @mods_refer_me = keys %$USED;
	    foreach my $mod_refs_me (@mods_refer_me) {
		# Υ⥸塼@USEˤ$modnameäƤ뤫
		my $USE = eval qq{ \\\@${mod_refs_me}::USE };
		my $refers_actually = sub {
		    if (defined $USE) {
			foreach (@$USE) {
			    if ($_ eq $modname) {
				return 1;
			    }
			}
		    }
		    undef;
		}->();
		unless ($refers_actually) {
		    # ºݤˤϻȤƤʤä
		    delete $USED->{$mod_refs_me};
		    $result = 1;
		}
	    }
	}
    }
    $result;
}

sub gc {
    # $this->{modules}ãǽǤʤ֥⥸塼ƥɤ롣
    my $this = shift;
    my %all_mods = %{$this->{mod_timestamps}}; # ԡ
    # %all_modsǤͤˤʤäƤʬޡ줿Ľꡣ

    my $trace;
    $trace = sub {
	my $modname = shift;
	# ˥ޡƤ뤫⤷ϥ⥸塼뤬¸ߤʤȴ롣
	my $val = $all_mods{$modname};
	if (!defined($val) || $val eq '') {
	    return;
	}
	else {
	    # Υ⥸塼ޡ
	    $all_mods{$modname} = '';
	    # Υ⥸塼@USEƤ顢
	    # ƤΥ⥸塼ˤĤƺƵŪ˥ȥ졼
	    my $USE = eval qq{\\\@${modname}::USE};
	    if (defined $USE) {
		foreach (@$USE) {
		    $trace->($_);
		}
	    }
	}
    };

    for my $mod (@{$this->{modules}}) {
	my $modname = ref $mod;
	$trace->($modname);
    }

    # ޡʤä֥⥸塼ãԲǽʤΤǥɤ롣
    my $runloop = RunLoop->shared_loop;
    while (my ($key,$value) = each %all_mods) {
	if ($value ne '') {
	    eval qq{
		\&${key}::destruct();
	    };

	    $runloop->notify_msg(
		"Submodule $key is no longer required. It will be unloaded.");
	    $this->_unload($key);
	}
    }
}

1;
