# -----------------------------------------------------------------------------
# $Id: Mask.pm,v 1.12 2003/09/22 18:02:06 admin Exp $
# -----------------------------------------------------------------------------
# $Clovery: tiarra/main/Mask.pm,v 1.10 2003/07/24 03:08:26 topia Exp $
package Mask;
use strict;
use warnings;
use Carp;
use Multicast;

sub match {
  # matchϥ磻ɥɤȤäޥå󥰤ԤؿǤ
  # 磻ɥɰʳˤ⡢+-Ȥä䡢
  # re: Ȥäɽޥå󥰤Ԥޤ

  # $masksˤ','()ǶڤäޥåꥹȤϤƤ
  # ','()Ȥ'\,'Ƚ񤱤ޤ

  # ̾      : [] -  -
  # $match_type : [0] 0: Ǹ˥ޥå֤ͤޤ 1: ǽ˥ޥå֤ͤޤ
  # $use_re     : [1] 0: ɽޥåѤޤ 1: Ѥޤ
  # $use_flag   : [1] 0: +-Ѥޤ           1: Ѥޤ

  # ֤      : { 1 (true)  => + ˥ޥå,
  #                 0 (false) => - ˥ޥå,
  #                  (undef)  => ޤäޥåʤä
  my ($masks, $str, $match_type, $use_re, $use_flag) = @_;
  if (!defined $masks || !defined $str) {
    return undef;
  }

  return match_array([_split($masks)], $str, $match_type, $use_re, $use_flag);
}

sub match_deep {
  # match_deepϼΤ褦ʥޥβ˻Ȥޤ

  # mask: +*!*@*
  # mask: -example!*

  # ̾             : [] -  -
  # $masks_array       : [̵] ޥλȤϤޤ
  #  Mask::match_deep([Mask::mask_array_or_all($this->config->mask('all'))], $msg->prefix)
  #                    : Τ褦˻Ȥޤ
  # $global_match_type : [1] 0: Ǹ˥ޥåԤ֤ͤޤ 1: ǽ˥ޥåԤ֤ͤޤ
  my ($masks_array, $str, $g_match_type, $match_type, $use_re, $use_flag) = @_;
  if (!defined $masks_array) {
    return undef;
  }

  $g_match_type = 1 unless defined $g_match_type;

  my $g_matched = undef;
  foreach my $masks (@$masks_array) {
    my $matched = match_array([_split($masks)], $str, $match_type, $use_re, $use_flag);
    if (defined $matched) {
      $g_matched = $matched;
      return $g_matched if $g_match_type == 1;
    }
  }

  return $g_matched;
}

sub match_array {
  # match_arrayϡmatchƤФؿǤ̤˸ƤӽФƻȤȤǤޤ
  # match Ȥΰ㤤ϡޥޥλȤȤϤǤ

  # $match_type: 0: last matching rule, 1: first matching rule
  # $use_re    : use 're:' feature.
  # $use_flag  : use [+-] match flag.

  # <return value> : status { 1 (true)  => +, matched,
  #                           0 (false) => -, matched,
  #                            (undef)  => no-match }
  my ($mask_array, $str, $match_type, $use_re, $use_flag) = @_;

  if (!defined $mask_array || ref($mask_array) ne 'ARRAY' || !defined $str) {
    return undef;
  }

  $match_type = 0 unless defined $match_type;
  $use_re = 1 unless defined $use_re;
  $use_flag = 1 unless defined $use_flag;

  my $matched = undef;
  foreach my $part (@$mask_array) {
    my $work = $part;
    my $first = substr($work, 0, 1);
    my $include = 1;
    if (!$use_flag) {
      # noop
    } elsif ($first eq '+') {
      substr($work, 0, 1) = '';
    } elsif ($first eq '-') {
      $include = 0;
      substr($work, 0, 1) = '';
    }

    if ($use_re && substr($work, 0, 3) eq 're:') {
      # ɽ
      $work = substr($work,3);
      $work = eval {
	qr/$work/;
      }; if ($@) {
	$work = '';
	carp "error in regex: $@";
      }
    } else {
      $work = make_regex($work);
    }

    if ($str =~ m/$work/i) {
      # ޥå
      $matched = $include;
      return $matched if  $match_type == 1;
    }
  }
  return $matched;
}


# channel version
sub match_chan {
  my ($masks, $str, $chan, $match_type, $use_re, $use_flag) = @_;
  if (!defined $masks || !defined $str) {
    return undef;
  }

  return match_array_chan(_split_with_chan($masks), $str, $chan, $match_type, $use_re, $use_flag);
}

sub match_deep_chan {
  my ($masks_array, $str, $chan, $g_match_type, $match_type, $use_re, $use_flag) = @_;
  if (!defined $masks_array) {
    return undef;
  }

  $g_match_type = 1 unless defined $g_match_type;

  my $g_matched = undef;
  foreach my $masks (@$masks_array) {
    my $matched = match_array_chan(_split_with_chan($masks), $str, $chan, $match_type, $use_re, $use_flag);
    if (defined $matched) {
      $g_matched = $matched;
      return $g_matched if $g_match_type == 1;
    }
  }

  return $g_matched;
}

my $chanmask_mode = undef; # undefined,
my $CHANMASK_TIARRA = 1;
my $CHANMASK_PLUM = 2;

# tiarra Configuration check;
sub _check_chanmask_conf {
  # configuration ɤߡchanmask_mode ꤹ롣
  use Configuration;

  my $maskmode = Configuration::shared_conf->general->chanmask_mode;
  if (defined $maskmode) {
    if ($maskmode =~ /plum/i) {
      $chanmask_mode = $CHANMASK_PLUM;
    } elsif ($maskmode =~ /tiarra/i) {
      $chanmask_mode = $CHANMASK_TIARRA;
    } else {
      ::printmsg('Configure_variable [maskmode] ' . $maskmode . ' is not known... use Tiarra mode.');
      $chanmask_mode = $CHANMASK_TIARRA;
    }
  } else {
    # fallback
    $chanmask_mode = $CHANMASK_TIARRA;
  }
}

sub match_array_chan {
  # $match_type: 0: last matching rule, 1: first matching rule
  # $use_re    : use 're:' feature.
  # $use_flag  : use [+-] match flag.

  # <return value> : status { 1 (true)  => +, matched,
  #                           0 (false) => -, matched,
  #                            (undef)  => no-match }
  my ($usermask_array, $chanmask_array, $str, $chan, $match_type, $use_re, $use_flag) = @_;

  return undef if (!defined $str);
  foreach my $var ($usermask_array, $chanmask_array) {
    return undef if (!defined $var || ref($var) ne 'ARRAY');
  }

  _check_chanmask_conf() if (!defined($chanmask_mode));

  my ($chanmask_use_flag);
  if ($chanmask_mode == $CHANMASK_TIARRA) {
    $chanmask_use_flag = $use_flag;
  } elsif ($chanmask_mode == $CHANMASK_PLUM) {
    $chanmask_use_flag = 0;
  } else {
    croak 'chanmask_mode is unsupported value!';
  }

  # channelޥåԤäƤuserޥåԤ
  # channelޥåǤflagϻȤʤ
  my $matched = undef;
  if (Multicast::channel_p($chan)) {
    # $chanchannelλ̤˥ޥå
    $matched = match_array($chanmask_array, $chan, $match_type, $use_re, $chanmask_use_flag);
  } else {
    # $chanchannelǤʤȤprivʤΤ * ˥ޥå롣
    $matched = match_array($chanmask_array, '*', $match_type, $use_re, $chanmask_use_flag);
  }

  $matched = undef unless $matched; # matchʤäundef
  # channelǥޥåʤä餳ιԤ̵뤹롣
  if (defined $matched) {
    $matched = undef;
    $matched = match_array($usermask_array, $str, $match_type, $use_re, $use_flag);
  }

  return $matched;
}

# support functions
my $cache_limit = 150;
my @cache_keys;
my %cache_table;
sub make_regex {
    my $str = $_[0];

    if (my $cached = $cache_table{$str}) {
	$cached;
    }
    else {
	# å夵Ƥʤ
	if (@cache_keys >= $cache_limit) {
	    # å夵Ƥͤ˰ľä
	    my $to_delete = scalar(splice @cache_keys, int(rand @cache_keys), 1);
	    delete $cache_table{$to_delete};
	}

	my $regex = $str;
	$regex =~ s/(\W)/\\$1/g;
	$regex =~ s/\\\?/\./g;
	$regex =~ s/\\\*/\.\*/g;
	$regex = "^$regex\$";
	
	my $compiled = qr/$regex/;
	push @cache_keys, $str;
	$cache_table{$str} = $compiled;
	
	$compiled;
    }
}

sub _split {
    # ',' Ǥ櫓줿ޥˤ롣
    my $mask = shift;

    return map {
	s/\\,/,/g;
	$_;
    } split /(?<!\\),/,$mask;
}

sub _split_with_chan {
    # ͥդޥˤ롣
    # ѥ᡼: mask ץѥƥ
    # output (user-array-ref, channel-array-ref)
    _check_chanmask_conf() if (!defined($chanmask_mode));

    if ($chanmask_mode == $CHANMASK_TIARRA) {
	my ($chan, $user) = split(/\s+/, shift, 2);

	return [_split($user)], [_split($chan)];
    } elsif ($chanmask_mode == $CHANMASK_PLUM) {
	my ($user, @chanarray) = split(/\s+/, shift);

	@chanarray = '*' unless @chanarray;

	@chanarray = map {
	    s/\\,/,/g;
	    $_;
	} map {
	    split /(?<!\\),/;
	} @chanarray;

	return [_split($user)], [@chanarray];
    } else {
	croak 'chanmask_mode is unsupported value!';
    }
}

# not related but often use
sub array_or_default {
  my ($default, @array) = @_;

  unless (@array) {
    return $default;
  } else {
    return @array;
  }
}

sub array_or_all {
  return array_or_default(all_mask(), @_);
}

sub array_or_all_chan {
  return array_or_default(all_chan_mask(), @_);
}

sub all_mask {
  return '*';
}

sub all_chan_mask {
  _check_chanmask_conf() if (!defined($chanmask_mode));
  if ($chanmask_mode == $CHANMASK_TIARRA) {
    return '* *!*@*';
  } elsif ($chanmask_mode == $CHANMASK_PLUM) {
    return '*!*@*';
  } else {
    croak 'chanmask_mode is unsupported value!';
  }
}


1;
