# -----------------------------------------------------------------------------
# $Id: ExternalSocket.pm,v 1.7 2003/06/03 15:27:42 admin Exp $
# -----------------------------------------------------------------------------
# RunLoopǤդΥåȤƻ뤹뤬Ͽΰ٤ˤΥ饹Ѥ롣
# -----------------------------------------------------------------------------
# my $esock = ExternalSocket->new(
#     Socket => IO::Socket::INET->new(...), # IO::SocketΥ֥
#     Read => sub {
#               # åȤɤ߹߲ǽˤʤä˸ƤФ륯㡣
#               # ExternalSocketΥ֥ȼȤĤ˸ƤФ롣
#               my $sock = shift->sock;
#               ...
#             },
#     Write => sub {
#               # åȤ񤭹߲ǽˤʤä˸ƤФ륯㡣
#               my $sock = shift->sock;
#               ...
#             },
#     WantToWrite => sub {
#               # åȤ˽񤭹ɬפ뤫ɤRunLoopΤ٤˸ƤФ륯㡣
#               # ReadWriteƱ֤ͤʤФʤʤ
#               undef;
#             },
#     )->install;
#
# $esock->uninstall;
# -----------------------------------------------------------------------------
package ExternalSocket;
use strict;
use warnings;
use UNIVERSAL;
use Carp;

use SelfLoader;
1;
__DATA__

sub new {
    my ($class,%args) = @_;
    
    my $this = bless {
	socket => undef,
	read => undef,
	write => undef,
	wanttowrite => undef,
	runloop => undef,
	creator => (caller)[0],
    },$class;

    if (defined $args{Socket}) {
	if (ref $args{Socket} &&
	    UNIVERSAL::isa($args{Socket},'IO::Socket')) {

	    $this->{socket} = $args{Socket};
	}
	else {
	    croak "ExternalSocket->new, Arg{Socket} was illegal reference: ".ref($args{Socket})."\n";
	}
    }
    else {
	croak "ExternalSocket->new, Arg{Socket} not exists\n";
    }

    foreach my $key (qw/Read Write WantToWrite/) {
	if (defined $args{$key}) {
	    if (ref($args{$key}) eq 'CODE') {
		$this->{lc $key} = $args{$key};
	    }
	    else {
		croak "ExternalSocket->new, Arg{$key} was illegal reference: ".ref($args{$key})."\n";
	    }
	}
	else {
	    croak "ExternalSocket->new, Arg{$key} not exists\n";
	}
    }

    $this;
}

sub creator {
    shift->{creator};
}

*socket = \&sock;
sub sock {
    # ExternalSocketݻƤ륽åȤ֤
    shift->{socket};
}

sub install {
    # RunLoop˥󥹥ȡ뤹롣
    # άϥǥեȤRunLoop˥󥹥ȡ뤹롣
    my ($this,$runloop) = @_;

    if (defined $this->{runloop}) {
	croak "This ExternalSocket has been already installed to RunLoop\n";
    }

    $runloop = RunLoop->shared unless defined $runloop;
    $runloop->install_socket($this);

    $this->{runloop} = $runloop;
    $this;
}

sub uninstall {
    # 󥹥ȡ뤷RunLoop顢ΥåȤ򥢥󥤥󥹥ȡ뤹롣
    my $this = shift;

    if (!defined $this->{runloop}) {
	# 󥹥ȡ뤵Ƥʤ
	croak "This ExternalSocket hasn't been installed yet\n";
    }

    $this->{runloop}->uninstall_socket($this);
    $this->{runloop} = undef;
    $this;
}

sub read {
    # Read¹Ԥ롣RunLoopΤߤΥ᥽åɤƤ٤롣
    my $this = shift;

    my ($caller_pkg) = caller;
    if (!$caller_pkg->isa('RunLoop')) {
	croak "Only RunLoop may call method read/write/want_to_write of ExternalSocket\n";
    }
    
    $this->{read}->($this);
    $this;
}

sub write {
    # Write¹Ԥ롣
    my $this = shift;

    my ($caller_pkg) = caller;
    if (!$caller_pkg->isa('RunLoop')) {
	croak "Only RunLoop may call method read/write/want_to_write of ExternalSocket\n";
    }
    
    $this->{write}->($this);
    $this;
}

sub want_to_write {
    # WantToWrite¹Ԥ롣
    my $this = shift;

    my ($caller_pkg) = caller;
    if (!$caller_pkg->isa('RunLoop')) {
	croak "Only RunLoop may call method read/write/want_to_write of ExternalSocket\n";
    }
    
    $this->{wanttowrite}->($this);
}

1;
