# -----------------------------------------------------------------------------
# $Id: Preprocessor.pm,v 1.7 2003/07/26 14:00:38 admin Exp $
# -----------------------------------------------------------------------------
# tiarraconfեΥץץåǤ
# Υ饹ϼΤ褦ʵǽޤ
#
# "%PRE{""}ERP%"˶ޤ줿ʬperlʸȤɾ̤򤽤ξ롣
#
# @include ե̾
#   Τ褦ʹԤ򡢤ΥեȤ֤롣
#
# @define ʸA ʸB 
#   Τ褦ʹԤθ夫ϡեʸAʸB֤롣
#   ִϤɤǤäƤ⹽ʤ㤨мΤ褦ͭǤ롣
#   @define DEBUG 1
#   @if 'DEBUG' == '1'
#     debug: a
#   @endif
#   㳰@undefʸʸФƤִԤʤʤ
#
# @undef ʸA
#   @defineִ򡢼ιԤ饭󥻥뤹롣
#
# @if 
# @elsif
#   perlʸȤɾ̤ʤ@elsif@else@endifޤǤͭʹԤȤߤʤ
#   if-elsif-else-endifʸϴǤҤˤ롣
#
# @else
# @endif
#   פǤ
#
# @ifdef ʸ
# @ifndef ʸ
#   ʸ@defineƤ顢㤷ϤƤʤä顣
#
# @message ʸ
#   ɸϤˤʸФâʸɤѴϰڹԤʤΤ
#   ASCIIʸʳФΤϤ᤿ɤ
#
# -----------------------------------------------------------------------------
# %PRE{ }ERP%ɾ졢@ʸɾ롣
# %PRE{ }ERP%ʣιԤϤäƤɤ
# -----------------------------------------------------------------------------
package Configuration::Preprocessor;
use strict;
use warnings;
use Carp;
use IO::File;
use UNIVERSAL;
our %initial_definition;

sub preprocess {
    # IO::Handleޤϥե̾ļꡢץץη̤֤
    my $handle = shift;

    Configuration::Preprocessor
	->new
	->execute($handle);
}

sub new {
    my ($class,$filename) = @_;
    my $this = {
	included => {}, # եѥ => 1 (¿includeΥå˻Ȥ롣)
	consts => {%initial_definition}, # @define줿ޥ̾ => 
    };
    bless $this,$class;
}

sub initial_define {
    my ($key, $value) = @_;
    $initial_definition{$key} = $value;
}

sub defined_p {
    my ($this, $key) = @_;
    defined $this->{consts}{$key};
}

sub execute {
    my ($this,$filename) = @_;

    my $result = eval {
	$this->_execute($filename);
    };
    if ($@) {
	my $fname = do {
	    if (ref($filename) && UNIVERSAL::isa($filename,'IO::Handle')) {
		"HANDLE(".$filename->fileno.")";
	    }
	    else {
		$filename;
	    }
	};
	die "Exception in preprocessing $fname:\n$@\n";
    }

    $result;
}

sub _execute {
    my ($this,$filepath) = @_;

    my $handle = do {
	if (!defined $filepath) {
	    croak "Configuration::Preprocessor->_execute, Arg[1] was undef.\n";
	}
	elsif (ref($filepath) && UNIVERSAL::isa($filepath,'IO::Handle')) {
	    # IO::Handleä
	    # ʣåԲǽ
	    $filepath;
	}
	else {
	    if (exists $this->{included}->{$filepath}) {
		die "$filepath has already loaded or included before.\n";
	    }
	    else {
		$this->{included}->{$filepath} = 1;
	    }
	    
	    my $fh = IO::File->new($filepath,'r');
	    if (!defined $fh) {
		die "Couldn't open $filepath to read.\n";
	    }
	    $fh;
	}
    };

    # եƬǸޤɤࡣ
    my $body = '';
    foreach (<$handle>) {
	tr/\r\n//d;
	$body .= "$_\n";
    }
    undef $handle;

    # %PRE{ }ERP% ִ
    $body = $this->_eval_pre($body);

    # Ԥɤ@
    $body = $this->_eval_at($body);

    $body;
}

sub _eval_pre {
    my ($this,$body) = @_;

    my $evaluate = sub {
	my $script = shift;
	no strict; no warnings;
	my $result = eval "package Configuration::Implanted; $script";
	use warnings; use strict;
	if ($@) {
	    my $short = substr $script,0,50;
	    $short =~ tr/\n//d;
	    $short =~ s/^\s*|\s*$//g;
	    die "Exception in evaluating %PRE{ }ERP% block\nlike '$short'\n$@\n";
	}
	defined $result ? $result : '';
    };
    $body =~ s/\%PRE{(.+?)}ERP\%/$evaluate->($1)/seg;
    $body;
}

sub _eval_at {
    my ($this,$body) = @_;

    my @ifstack = (); # if,elsif,else,endifޤǤư(ʤĤʤä)

    my $result = '';
    foreach my $line (split /\n/,$body) {
	# ιԤ@undef,@ifdef,@ifndefʸǤʤʤ顢@define줿Ƥִ¹ԡ
	if ($line !~ m/^\s*\@\s*(?:undef|ifdef|ifndef)\s+/) {
	    while (my ($key,$value) = each %{$this->{consts}}) {
		$line =~ s/\Q$key\E/$value/g;
	    }
	}

	if (@ifstack > 0) {
	    # ifʸΥ֥åǤ롣
	    my $action = $ifstack[@ifstack - 1];
	    
	    if ($line =~ m/^\s*\@\s*(?:if|elsif|ifdef|ifndef|else|endif)/) {
		# ֤Ѥǽ롣
		# Ȥꤢ⤷ʤ
	    }
	    else {
		# ֤Ѥʤ
		# ΤƤɬפʤΤƤƼء
		if (!$action) {
		    next;
		}
	    }
	}
	
	if ($line =~ m/^\s*\@/) {
	    # @ǻϤޤäƤ롣
	    # ȤꤢƬ@äƺǽȺǸ\sоä
	    $line =~ s/^\s*\@\s*|\s*$//g;

	    # ifdefifndefifʸ˽񴹤
	    if ($line =~ m/^ifdef\s+(.+)$/) {
		$line = q{if $this->defined_p(q@}.$1.q{@)};
	    }
	    elsif ($line =~ m/^ifndef\s+(.+)$/) {
		$line = q{if !$this->defined_p(q@}.$1.q{@)};
	    }

	    if ($line =~ m/^include\s+(.+)$/) {
		$result .= $this->execute($1);
	    }
	    elsif ($line =~ m/^define\s+(.+?)(?:\s+(.+))?$/) {
		my $key = $1;
		my $value = (defined $2 ? $2 : '');
		
		if (defined $this->{consts}->{$key}) {
		    die "$key has already been \@defined before.\n";
		}
		$this->{consts}->{$key} = $value;
	    }
	    elsif ($line =~ m/^undef\s+(.+)$/) {
		if (!defined $this->{consts}->{$1}) {
		    die "$1 has not been \@defined.\n";
		}
		delete $this->{consts}->{$1};
	    }
	    elsif ($line =~ m/^message\s+(.+)$/) {
		print "$1\n";
	    }
	    elsif ($line =~ m/^if\s+(.+)$/) {
		if (@ifstack > 0 && !$ifstack[@ifstack - 2]) {
		    # Υե졼ब¸ߤĲΥե졼Υ'ä'ʤ顢̵˾ä
		    push @ifstack,0;
		}
		else {
		    # ɾ̤ʤ顢if,elsif,else,endifФƤޤǻĤʤ餽餬ФޤǾä
		    my $cond_evaluated = eval(defined $1 ? $1 : '');
		    if ($@) {
			die "Exception in evaluating: \@$line\n$@\n";
		    }
		    push @ifstack,$cond_evaluated;
		}
	    }
	    elsif ($line =~ m/^elsif\s+(.+)$/) {
		# elsifϿifե졼ɲäϤߤΥե졼˾񤭤롣
		#
		# ߤΥե졼Υ'Ĥ'ä...
		#   if,elsif,else,endifФƤޤ̵˾ä
		#
		# 'ä'ä...
		#   ʤif,elsif,else,endifФƤޤǻĤʤ餽餬ФޤǾä
		#
		# âߤΥե졼बȥåץ٥Ǥʤäǡ
		# βΥ٥Υ'ä'äϡ̵˾ä
		if (@ifstack > 1 && !$ifstack[@ifstack - 2]) {
		    pop @ifstack;
		    push @ifstack,0;
		}
		else {
		    if (@ifstack > 0) {
			if ($ifstack[@ifstack - 1]) {
			    pop @ifstack;
			    push @ifstack,0;
			}
			else {
			    my $cond_evaluated = eval(defined $1 ? $1 : '');
			    if ($@) {
				die "Exception in evaluating: \@$line\n$@\n";
			    }
			    pop @ifstack;
			    push @ifstack,$cond_evaluated;
			}
		    }
		    else {
			die "\@elsif without \@if block.\n";
		    }
		}
	    }
	    elsif ($line =~ m/^else$/) {
		# elseϿifե졼ɲä뤳ȤϤߤΥե졼˾񤭤롣
		#
		# ߤΥե졼Υ'Ĥ'ä...
		#   if,elsif,else,endifФƤޤ̵˾ä
		#
		# 'ä'ä...
		#   if,elsif,else,endifФƤޤ̵˻Ĥ
		#
		# âߤΥե졼बȥåץ٥Ǥʤäǡ
		# βΥ٥Υ'ä'äϡ̵˾ä
		if (@ifstack > 1 && !$ifstack[@ifstack - 2]) {
		    pop @ifstack;
		    push @ifstack,0;
		}
		else {
		    if (@ifstack > 0) {
			if ($ifstack[@ifstack - 1]) {
			    pop @ifstack;
			    push @ifstack,0;
			}
			else {
			    pop @ifstack;
			    push @ifstack,1;
			}
		    }
		    else {
			die "\@else without \@if block.\n";
		    }
		}
	    }
	    elsif ($line =~ m/^endif$/) {
		if (@ifstack > 0) {
		    # if֥åλ롣
		    pop @ifstack;
		}
		else {
		    die "\@endif without \@if block.\n";
		}
	    }
	    else {
		die "Invalid @ command: \@$line\n";
	    }
	}
	else {
	    $result .= "$line\n";
	}
    }

    # ǽŪ@ifstackˤʤäƤʤȤϡ@if֥åäƤʤȤ
    if (@ifstack > 0) {
	die "There's \@if block which is not terminated.\n"
    }

    $result;
}

1;
