# -----------------------------------------------------------------------------
# $Id: Recent.pm,v 1.4 2003/03/17 08:08:32 topia Exp $
# -----------------------------------------------------------------------------
# Local: $Clovery: tiarra/module/Log/Recent.pm,v 1.5 2003/02/11 07:59:32 topia Exp $
package Log::Recent;
use strict;
use warnings;
use base qw(Module);
use Module::Use qw(Tools::DateConvert Log::Logger);
use Tools::DateConvert;
use Log::Logger;
use IRCMessage;
use Mask;

sub new {
    my $class = shift;
    my $this = $class->SUPER::new;
    # ͥμ֤ʤᡢͥΥChannelInforemarks¸롣
    # privΥΥ饹ݻ
    $this->{priv_log} = []; # Ȥñʤʸ
    $this->{logger} =
	Log::Logger->new(
	    sub {
		$this->log(@_);
	    },
	    $this,
	    'S_PRIVMSG','C_PRIVMSG','S_NOTICE','C_NOTICE');
    $this;
}

sub message_arrived {
    my ($this,$msg,$sender) = @_;
    # Log::Recent/command˥ޥå뤫
    if (Mask::match($this->config->command || '*',$msg->command)) {
	$this->{logger}->log($msg,$sender);
    }
    $msg;
}

sub client_attached {
    my ($this,$client) = @_;
    # ޤpriv
    my $local_nick = RunLoop->shared->current_nick;
    foreach my $elem (@{$this->{priv_log}}) {
	$client->send_message(
	    IRCMessage->new(
		Command => 'NOTICE',
		Params => [$local_nick,$elem->[1]])); # $elem->[0]Ͼ'priv'
    }
    # ˳ƥͥ
    foreach my $network (values %{RunLoop->shared->networks}) {
	foreach my $ch (values %{$network->channels}) {
	    # Ϥ뤫
	    my $vec = $ch->remarks('recent-log');
	    if (defined $vec) {
		foreach my $elem (@$vec) {
		    $client->send_message(
			IRCMessage->new(
			    Prefix => 'Tiarra',
			    Command => 'NOTICE',
			    Params => [$elem->[0],$elem->[1]]));
		}
	    }
	}
    }
}

*S_PRIVMSG = \&PRIVMSG_or_NOTICE;
*S_NOTICE = \&PRIVMSG_or_NOTICE;
*C_PRIVMSG = \&PRIVMSG_or_NOTICE;
*C_NOTICE = \&PRIVMSG_or_NOTICE;
sub PRIVMSG_or_NOTICE {
    my ($this,$msg,$sender) = @_;
    my $target = Multicast::detatch($msg->param(0));
    my $is_priv = Multicast::nick_p($target);
    my $cmd = $msg->command;

    my $line = do {
	if ($is_priv) {
	    if ($sender->isa('IrcIO::Client')) {
		sprintf(
		    $cmd eq 'PRIVMSG' ? '>%s< %s' : ')%s( %s',
		    $msg->param(0),
		    $msg->param(1));
	    }
	    else {
		sprintf(
		    $cmd eq 'PRIVMSG' ? '-%s- %s' : '=%s= %s',
		    $msg->nick || $sender->current_nick,
		    $msg->param(1));
	    }
	}
	else {
	    my $format = do {
		if ($this->config->distinguish_myself && $sender->isa('IrcIO::Client')) {		    
		    $cmd eq 'PRIVMSG' ? '>%s< %s' : ')%s( %s';
		}
		else {
		    $cmd eq 'PRIVMSG' ? '<%s> %s' : '(%s) %s';
		}
	    };
	    my $nick = do {
		if ($sender->isa('IrcIO::Client')) {
		    RunLoop->shared_loop->network(
		      (Multicast::detatch($msg->param(0)))[1])
			->current_nick;
		}
		else {
		    $msg->nick || $sender->current_nick;
		}
	    };
	    sprintf $format,$nick,$msg->param(1);
	}
    };
    
    [$is_priv ? 'priv' : $msg->param(0),$line];
}

sub log {
    my ($this,$ch_full,$log_line) = @_;
    my $vec = do {
	if ($ch_full eq 'priv') {
	    # privϼʬ¸
	    $this->{priv_log};
	}
	else {
	    # privǤʤChannelInfo'recent-log'Ȥ¸
	    my ($ch_short,$network_name) = Multicast::detach($ch_full);
	    my $ch = RunLoop->shared->
		network($network_name)->channel($ch_short);
	    if (!defined $ch) {
		return;
	    }
	    my $log_vec = $ch->remarks('recent-log');
	    if (!defined $log_vec) {
		$log_vec = [];
		$ch->remarks('recent-log',$log_vec);
	    }
	    $log_vec;
	}
    };

    my $header = Tools::DateConvert::replace(
	$this->config->header || '%H:%M'
    );
    
    # ɲ
    # Ǥ[ͥ̾,]
    push @$vec,[$ch_full,"$header $log_line"];

    # 줿ʬä
    if (@$vec > $this->config->line) {
	splice @$vec,0,(@$vec - $this->config->line);
    }
}

1;
