# -----------------------------------------------------------------------------
# $Id: Rejoin.pm,v 1.2 2003/01/24 04:00:52 admin Exp $
# -----------------------------------------------------------------------------
# Υ⥸塼ư˷ǼĤdo-not-touch-mode-of-channelsȤޤ
# -----------------------------------------------------------------------------
package Channel::Rejoin;
use strict;
use warnings;
use base qw(Module);
use BulletinBoard;
use Multicast;
use RunLoop;

sub new {
    my $class = shift;
    my $this = $class->SUPER::new;
    $this->{sessions} = {}; # ͥե͡ => å
    # å : HASH
    # ch_fullname => ͥե͡
    # ch_shortname => ͥ륷硼ȥ͡
    # ch => ChannelInfo
    # server => IrcIO::Server
    # got_mode => MODEƤ뤫ɤ
    # got_blist => +bꥹȤ(ά
    # got_elist => +e(ά
    # got_Ilist => +I(ά
    # got_oper => PART->JOINƤ뤫ɤ
    # cmd_buf => ARRAY<IRCMessage>
    $this;
}

sub message_arrived {
    my ($this,$msg,$sender) = @_;
    if ($sender->isa('IrcIO::Server')) {
	# PART,KICK,QUIT,KILL줾ͤˤʤװ
	my $cmd = $msg->command;
	if ($cmd eq 'PART') {
	    foreach my $ch_fullname (split /,/,$msg->param(0)) {
		$this->check_channel(
		    scalar Multicast::detatch($ch_fullname),
		    $sender);
	    }
	}
	elsif ($cmd eq 'KICK') {
	    # RFC2812ˤȡʣΥͥKICKå
	    # 饤ȤϤ̵
	    $this->check_channel(
		scalar Multicast::detatch($msg->param(0)),
		$sender);
	}
	elsif ($cmd eq 'QUIT' || $cmd eq 'KILL') {
	    # affected-channels˱ƶΤäͥΥꥹȤäƤϤ
	    foreach (@{$msg->remark('affected-channels')}) {
		$this->check_channel($_,$sender);
	    }
	}

	$this->session_work($msg,$sender);
    }
    $msg;
}

sub check_channel {
    my ($this,$ch_name,$server) = @_;
    if ($ch_name =~ m/^\+/) {
	# +ͥ@դʤ
	return;
    }
    my $ch = $server->channel($ch_name);
    if (!defined $ch) {
	# ʬäƤʤ
	return;
    }
    if ($ch->switches('a')) {
	# +aͥǤϰͤˤʤäɤȽ꤬ݤǤˡ
	# @褵̵̣褵ʤ˾ޤ
	return;
    }
    if ($ch->names(undef,undef,'size') > 1) {
	# Ͱʾ夤롣
	return;
    }
    my $myself = $ch->names($server->current_nick);
    if ($myself->has_o) {
	# ʬ@äƤ롣
	return;
    }
    $this->rejoin($ch_name,$server);
}

sub rejoin {
    my ($this,$ch_name,$server) = @_;
    my $ch_fullname = Multicast::attach($ch_name,$server->network_name);
    RunLoop->shared->notify_msg(
	"Channel::Rejoin is going to rejoin to ${ch_fullname}.");

    ###############
    #   ή
    ### phase 1 ###
    # å
    # ǼĤˡ֤ΥͥΥ⡼ɤѹʡפȽ񤭹ࡣ
    # TOPICФ롣
    # switches-are-knownʤMODE #channel¹ԡ
    # ɬפʤMODE #channel +b,MODE #channel +e,MODE #channel +I¹ԡ
    ### phase 2 ###
    # 324(modeץ饤),368(+bꥹȽ),
    # 349(+eꥹȽ),347(+IꥹȽ)򤽤줾ɬפʤԤġ
    ### phase 3 ###
    # PART #channel¹ԡ
    # JOIN #channel¹ԡ
    # ʬJOINԤġ
    # ̿Хåեίޤäޥɤ¹ԤƤTimerѡ
    #   ̿ХåեˤMODETOPICäƤ롣
    # ǼĤä
    # å˴
    ###############

    # ͥ
    my $ch = $server->channel($ch_name);

    # åϿ
    my $session = $this->{sessions}->{$ch_fullname} = {
	ch_fullname => $ch_fullname,
	ch_shortname => $ch_name,
	ch => $ch,
	server => $server,
	cmd_buf => [],
    };
    
    # do-not-touch-mode-of-channels
    my $untouchables = BulletinBoard->shared->do_not_touch_mode_of_channels;
    if (!defined $untouchables) {
	$untouchables = {};
	BulletinBoard->shared->set('do-not-touch-mode-of-channels',$untouchables);
    }
    # Υͥե͡Ͽ
    $untouchables->{$ch_fullname} = 1;
    
    # TOPICФ롣
    if ($ch->topic ne '') {
	push @{$session->{cmd_buf}},IRCMessage->new(
	    Command => 'TOPIC',
	    Params => [$ch_name,$ch->topic]);
    }
    
    # ɬפʤMODE #channel¹ԡ
    #if ($ch->remarks('switches-are-known')) {
    #	$session->{got_mode} = 1;
    #	push @{$session->{cmd_buf}},IRCMessage->new(
    #	    Command => 'MODE',
    #}
    # äѤᡣݡɱBOTȤƻȤä餳ʥ⥸塼Ȥʤȡ
    #else {
    	$server->send_message(
    	    IRCMessage->new(
		Command => 'MODE',
		Param => $ch_name));
    #}
    
    # ɬפʤ+e,+b,+I¹ԡ
    if ($this->config->save_lists) {
	foreach (qw/+e +b +I/) {
	    $server->send_message(
		IRCMessage->new(
		    Command => 'MODE',
		    Params => [$ch_name,$_]));
	}
    }
    else {
	$session->{got_elist} =
	    $session->{got_blist} =
	    $session->{got_Ilist} = 1;
    }

    # ԤʤФʤʤΤϤ뤫
    if ($this->{got_mode} && $this->{got_elist} &&
	$this->{got_blist} && $this->{got_Ilist}) {
	# ⤦̵
	$this->part_and_join($session);
    }
}

sub part_and_join {
    my ($this,$session) = @_;
    $session->{got_oper} = 1;
    foreach (qw/PART JOIN/) {
	$session->{server}->send_message(
	    IRCMessage->new(
		Command => $_,
		Param => $session->{ch_shortname}));
    }
}

sub session_work {
    my ($this,$msg,$server) = @_;
    my $session;
    # åоݤˤʤΤJOIN,324,368,349,347

    my $got_reply = sub {
	my $type = shift;
	my ($flagname,$listname) = do {
	    if ($type eq 'b') {
		('got_blist','banlist');
	    }
	    elsif ($type eq 'e') {
		('got_elist','exceptionlist');
	    }
	    elsif ($type eq 'I') {
		('got_Ilist','invitelist');
	    }
	};
	
	$session = $this->{sessions}->{$msg->param(1)};
	if (defined $session) {
	    $session->{$flagname} = 1;
	    
	    my $list = $session->{ch}->$listname();
	    my $list_size = @$list;
	    # ĤĤޤȤ롣
	    for (my $i = 0; $i < $list_size; $i+=3) {
		my @masks = ($list->[$i]);
		push @masks,$list->[$i+1] if $i+1 < $list_size;
		push @masks,$list->[$i+2] if $i+2 < $list_size;
		
		push @{$session->{cmd_buf}},IRCMessage->new(
		    Command => 'MODE',
		    Params => [$session->{ch_shortname},
			       '+'.($type x scalar(@masks)),
			       @masks]);
	    }
	}
    };
    
    if ($msg->command eq '324') {
	# MODEץ饤
	$session = $this->{sessions}->{$msg->param(1)};
	if (defined $session) {
	    $session->{got_mode} = 1;
	    my $ch = $session->{ch};
	    
	    my $switches = join('',keys %{$ch->switches});
	    my $params_key = '';
	    my @params_val;
	    while (my ($key,$value) = each %{$ch->parameters}) {
		$params_key .= $key;
		push @params_val,$value;
	    }
	    if (length($switches . $params_key) > 0) {
		# ꤹ٤⡼ɤ롣
		push @{$session->{cmd_buf}},IRCMessage->new(
		    Command => 'MODE',
		    Params => [$session->{ch_shortname},
			       "+${switches}${params_key}",
			       @params_val]);
	    }
	}
    }
    elsif ($msg->command eq '368') {
	# +bꥹȽ
	$got_reply->('b');
    }
    elsif ($msg->command eq '349') {
	# +eꥹȽ
	$got_reply->('e');
    }
    elsif ($msg->command eq '347') {
	# +IꥹȽ
	$got_reply->('I');
    }
    elsif ($msg->command eq 'JOIN') {
	$session = $this->{sessions}->{$msg->param(0)};
	if (defined $session && defined $msg->nick &&
	    $msg->nick eq RunLoop->shared->current_nick) {
	    # ľ
	    $session->{got_oper} = 1; # ˥åȤƤȦǰΤ
	    $this->revive($session);
	}
    }

    # $sessionǤʤСɬפʾ·äǽ롣
    if (defined $session && !$session->{got_oper} &&
	$session->{got_mode} && $session->{got_blist} &&
	$session->{got_elist} && $session->{got_Ilist}) {
	$this->part_and_join($session);
    }
}

sub revive {
    my ($this,$session) = @_;
    Timer->new(
	Interval => 1,
	Repeat => 1,
	Code => sub {
	    my $timer = shift;
	    my $cmd_buf = $session->{cmd_buf};
	    if (@$cmd_buf > 0) {
		# ٤ĤФ
		my $msg_per_trigger = 2;
		for (my $i = 0; $i < @$cmd_buf && $i < $msg_per_trigger; $i++) {
		    $session->{server}->send_message($cmd_buf->[$i]);
		}
		splice @$cmd_buf,0,$msg_per_trigger;
	    }
	    if (@$cmd_buf == 0) {
		# cmd_bufä齪λ
		# untouchablesõ
		my $untouchables = BulletinBoard->shared->do_not_touch_mode_of_channels;
		delete $untouchables->{$session->{ch_fullname}};
		# sessionõ
		delete $this->{sessions}->{$session->{ch_fullname}};
		# ޡ򥢥󥤥󥹥ȡ
		$timer->uninstall;
	    }
	})->install;
}

1;
