# -----------------------------------------------------------------------------
# $Id: Grant.pm,v 1.5 2003/03/02 04:15:52 topia Exp $
# -----------------------------------------------------------------------------
package Channel::Mode::Oper::Grant;
use strict;
use warnings;
use base qw(Module);
use Mask;
use Multicast;
use IRCMessage;
use Timer;

sub new {
    my $class = shift;
    my $this = $class->SUPER::new;
    $this->{queue} = {}; # network name => [[IrcIO::Server,channel(short),nick]]
    $this->{timer} = undef; # queueǤʤɬפˤʤTimer
    $this;
}

sub destruct {
    my ($this) = @_;
    if (defined $this->{timer}) {
	$this->{timer}->uninstall;
    }
}

sub message_arrived {
    my ($this,$msg,$sender) = @_;
    # ˿ʤिξ:
    # 1. СΥåǤ
    # 2. ޥɤJOINǤ
    # 3. ʬJOINǤϤʤ
    # 4. @դJOINǤϤʤ
    # 5. ΥͥǼʬ@äƤ
    # 6. mask˰פ
    if ($sender->isa('IrcIO::Server') &&
	$msg->command eq 'JOIN' &&
	defined $msg->nick &&
	$msg->nick ne RunLoop->shared->current_nick) {
	foreach (split /,/,$msg->param(0)) {
	    my ($ch_full,$mode) = (m/^(.+?)(?:\x07(.*))?$/);
	    my $ch_short = Multicast::detatch($ch_full);
	    my $ch = $sender->channel($ch_short);
	    my $myself = $ch->names($sender->current_nick);
	    if ($myself->has_o && (!defined $mode || $mode !~ /o/)) {
		if (Mask::match_deep_chan([$this->config->mask('all')],$msg->prefix,$ch_full)) {
		    # waitǻꤵ줿ÿηвˡ塼롣
		    # Ʊ˥塼òޡ롣
		    $this->push_to_queue($sender,$ch_short,$msg->nick);
		}
	    }
	}
    }
    $msg;
}

sub push_to_queue {
    my ($this,$server,$ch_short,$nick) = @_;
    Timer->new(
	After => $this->config->wait || 0,
	Code => sub {
	    # оݤοͤ+oƤߡ
	    my $ch = $server->channel($ch_short);
	    return if !defined $ch;
	    my $target = $ch->names($nick);
	    return if !defined $target;
	    return if $target->has_o;
	    
	    my $queue = $this->{queue}->{$server->network_name};
	    if (!defined $queue) {
		$queue = $this->{queue}->{$server->network_name} = [];
	    }
	    push @$queue,[$server,$ch_short,$nick];
	    $this->prepare_timer;
	})->install;
}

sub prepare_timer {
    my ($this) = @_;
    # 塼òޡ¸ߤʤк
    if (!defined $this->{timer}) {
	$this->{timer} = Timer->new(
	    Interval => 0, # ǽtriggerѹ롣
	    Repeat => 1,
	    Code => sub {
		my ($timer) = @_;
		$timer->interval(1);
		
		# 3Ĥľò롣
		# ͥ˺磳ĤŻ롣
		my $queue_has_elem;
		foreach my $queue (values %{$this->{queue}}) {
		    my $channels = {}; # ch_shortname => [nick,nick,...]
		    for (my $i = 0; $i < @$queue && $i < 3; $i++) {
			my $elem = $queue->[$i];
			my $nicks = $channels->{$elem->[1]};
			if (!defined $nicks) {
			    $nicks = $channels->{$elem->[1]} = [];
			}
			push @$nicks,$elem->[2];
		    }
		    while (my ($ch_short,$nicks) = each %$channels) {
			$queue->[0]->[0]->send_message(
			    IRCMessage->new(
				Command => 'MODE',
				Params => [$ch_short,
					   '+'.('o' x @$nicks),
					   @$nicks]));
		    }
		    splice @$queue,0,3;
		    # 塼Ǥʤ$queue_has_elem1롣
		    if (@$queue > 0) {
			$queue_has_elem = 1;
		    }
		}

		# ƤΥ塼ˤʤä齪λ
		if (!$queue_has_elem) {
		    $timer->uninstall;
		    $this->{timer} = undef;
		}
	    })->install;
    }
}

1;
