# -----------------------------------------------------------------------------
# $Id: ChannelWithoutOper.pm,v 1.2 2003/02/06 11:51:45 admin Exp $
# -----------------------------------------------------------------------------
package Auto::ChannelWithoutOper;
use strict;
use warnings;
use base qw(Module);
use Multicast;
use IRCMessage;

sub new {
    my ($class) = @_;
    my $this = $class->SUPER::new;
    $this->{last_message_time} = 0; # ǸˤΥ⥸塼뤬ȯ
    $this->{table} = do {
	my %hash = map {
	    my ($ch_long,$msg) = m/^(.+?)\s+(.+)$/;
	    $ch_long => $msg;
	} $this->config->channel('all');
	\%hash;
    };
    $this;
}

sub message_arrived {
    my ($this,$msg,$sender) = @_;
    my @result = ($msg);

    my $notify = sub {
	my ($ch_long,$ch_short,$str) = @_;
	my $msg_to_send = IRCMessage->new(
	    Command => 'NOTICE',
	    Params => ['',$str]); # ͥ̾ϸ
	# ˤϥͥåȥ̾դʤ
	my $for_server = $msg_to_send->clone;
	$for_server->param(0,$ch_short);
	$sender->send_message($for_server);

	# 饤Ȥˤդ롣Prefix⼫ưꤹ롣
	my $for_client = $msg_to_send->clone;
	$for_client->param(0,$ch_long);
	$for_client->remark('fill-prefix-when-sending-to-client',1);
	push @result,$for_client;
    };
    
    if ($sender->isa('IrcIO::Server') &&
	defined $msg->nick &&
	$msg->nick ne RunLoop->shared->current_nick &&
	$msg->command eq 'JOIN') {

	foreach (split /,/,$msg->param(0)) {
	    my ($ch_long) = m/^([^\x07]+)/;
	    # Υͥ˳Ƥ줿åϤ뤫
	    my $msg_for_ch = $this->{table}->{$ch_long};
	    if (defined $msg_for_ch) {
		my $ch_short = Multicast::detach($ch_long);
		my $ch = $sender->channel($ch_short);
		# Υͥ+ͥǤʤ+a+rꤵƤʤ
		if (defined $ch &&
		    $ch->name !~ m/^\+/ &&
		    !$ch->switches('a') &&
		    !$ch->switches('r')) {
		    
		    # ʤȤïäƤ뤫
		    my $oper_exists;
		    foreach my $person (values %{$ch->names}) {
			if ($person->has_o) {
			    $oper_exists = 1;
			}
		    }
		    if (!$oper_exists) {
			# ȯƤ1ðʾФäƤСȯ
			if (time > $this->{last_message_time} + 1) {
			    $notify->($ch_long,$ch_short,$msg_for_ch);
			    $this->{last_message_time} = time;
			}
		    }
		}
	    }
	}
    }
    @result;
}

1;

