# -----------------------------------------------------------------------------
# $Id: CacheManager.pm,v 1.1 2003/01/27 13:19:11 admin Exp $
# -----------------------------------------------------------------------------
# Υ饹϶̤Υ󥹥󥹤ޤ
# å奵ͭ¤ʤɤAuto::CacheԤʤޤ
#
# ºݤΥͥδݤʤΤǡåΤ
# ChannelInforemarks/cache-of-auto-modules¸ޤ
#
# cache-of-auto-modules: ARRAY
# : [ȯ,ȯ]
# -----------------------------------------------------------------------------
package Auto::CacheManager;
use strict;
use warnings;
our $_shared;

sub shared {
    if (!defined $_shared) {
	$_shared = Auto::CacheManager->_new;
    }
    $_shared;
}

sub _new {
    my ($class) = @_;
    my $this = {
	size => 0, # ǥեȤΥå奵
	expire => 600, # ǥեȤͭ¡ñ̤á
    };
    bless $this,$class;
}

sub cached_p {
    # ch: ChannelInfo
    # str: SCALAR
    # å夵Ƥ1֤ޤ
    my ($this,$ch,$str) = @_;
    my $cache = $this->get_cache($ch);
    $this->expire($cache);
    
    foreach (@$cache) {
	if ($_->[0] eq $str) {
	    return 1;
	}
    }
    undef;
}

sub cache {
    my ($this,$ch,$str) = @_;
    my $cache = $this->get_cache($ch);
    $this->expire($cache);
    
    # åɲ
    push @$cache,[$str,time];
    # å奵줿ʬϺ
    if (@$cache > $this->{size}) {
	splice @$cache,(@$cache - $this->{size});
    }
}

sub get_cache {
    my ($this,$ch) = @_;
    my $cache = $ch->remarks('cache-of-auto-modules');
    if (!defined $cache) {
	$cache = [];
	$ch->remarks('cache-of-auto-modules',$cache);
    }
    $cache;
}

sub expire {
    my ($this,$cache) = @_;
    # ޤexpireܤĤǤ⤢뤫ɤĴ٤롣
    my $limit = time - $this->{expire};
    
    my $expired_some = sub {
	foreach (@$cache) {
	    if ($_->[1] < $limit) {
		return 1;
	    }
	}
	undef;
    }->();

    if ($expired_some) {
	# åƹ
	@$cache = grep {
	    $_->[1] >= $limit;
	} @$cache;
    }
}

1;
