# -----------------------------------------------------------------------------
# $Id: Timer.pm,v 1.6 2003/07/19 05:15:57 admin Exp $
# -----------------------------------------------------------------------------
# RunLoopϿ졢ꤵ줿˵ư륿ޡǤ
# ߤμǤϡ٤äȤʤäƤޤ
# ޡɬפʥѥ᡼ϡ1)ư륵֥롼2)ưϵưޤǤÿ
# 3)ưޤǤÿꤷϵư˺ƤӥޡRunLoop˾褻뤫ɤǤ
#
# ư륵֥롼ȤƤϡCODEͤʤ鲿Ǥ⹽ޤ
# TimerϤCODEˡȤƼʬȤϤƥ뤷ޤ
#
# 3øHello, world!ɽ롣
# my $timer = Timer->new(
#     After => 3,
#     Code => sub { print "Hello, world!"; }
# )->install;
#
# 3Hello, world!ɽ롣
# my $timer = Timer->new(
#     After => 3, # IntervalǤɤ
#     Code => sub { print "Hello, world!"; },
#     Repeat => 1
# )->install;
#
# 3øHello, world!ɽ롣
# my $timer = Timer->new(
#     At => time + 3,
#     Code => sub { print "Hello, world!"; }
# )->install;
# -----------------------------------------------------------------------------
package Timer;
use strict;
use warnings;
use Carp;
use RunLoop;

sub new {
    my ($class,%args) = @_;
    my $obj = {
	fire_time => undef, # ȯưΥݥåá
	interval => undef, # repeatϡδֳ֡ʤ̤
	code => undef, # 餻륳
	runloop => undef, # RunLoopϿƤϡRunLoop
    };
    bless $obj,$class;

    # AfterIntervalƱ
    $args{'After'} = $args{'Interval'} if exists($args{'Interval'});

    # Atǻꤹ뤫AfterޤIntervalǻꤹ뤫Τɤ餫ǤʤФʤʤ
    if (exists($args{'At'}) && exists($args{'After'})) {
	croak "Timer cannot be made with both parameters At and After (or Interval).\n";
    }

    # AtAfterޤIntervalΤɤ餫Ĥɬס
    if (!exists($args{'At'}) && !exists($args{'After'})) {
	croak "Either parameter At or After (or Interval) is required to make Timer.\n";
    }
    
    # CodeϾɬס
    if (!exists($args{'Code'})) {
	croak "Code is always required to make Timer.\n";
    }
    
    # CodeCODEǤʤdie
    if (ref($args{'Code'}) ne 'CODE') {
	croak "Parameter Code was not valid CODE ref.\n";
    }

    $obj->{code} = $args{'Code'};
    
    if (defined $args{'At'}) {
	# Atǵư郎Ϳ줿ϡRepeatϽʤ
	if ($args{'Repeat'}) {
	    carp "Warning: It can't repeat that Timer made with At.\n";
	}

	$obj->{fire_time} = $args{'At'};
    }
    elsif (defined $args{'After'}) {
	# RepeatǤСֳ֤AfterޤIntervalͿ줿ͤȤ롣
	if ($args{'Repeat'}) {
	    $obj->{interval} = $args{'After'};
	}
	
	$obj->{fire_time} = time + $args{'After'};	
    }

    $obj;
}

sub time_to_fire {
    shift->{fire_time};
}

sub install {
    # RunLoop˥󥹥ȡ뤹롣
    # άϥǥեȤRunLoop˥󥹥ȡ뤹롣
    my ($this,$runloop) = @_;

    if (defined $this->{runloop}) {
	# ˥󥹥ȡѤߤä
	croak "This Timer has been already installed to RunLoop.\n";
    }
    
    $runloop = RunLoop->shared_loop unless defined $runloop;
    $runloop->install_timer($this);
    
    $this->{runloop} = $runloop;
    $this;
}

sub uninstall {
    # 󥹥ȡ뤷RunLoop顢Υޡ򥢥󥤥󥹥ȡ뤹롣
    my $this = shift;

    unless (defined $this->{runloop}) {
	# 󥹥ȡ뤵Ƥʤ
	croak "This Timer hasn't been installed yet\n";
    }
    
    $this->{runloop}->uninstall_timer($this);
    $this->{runloop} = undef;
    $this;
}

sub execute {
    my $this = shift;
    # Code¹ԤɬפʤԡȤ롣
    # RunLoopΤߤΥ᥽åɤƤ٤롣
    my ($package_of_caller,undef,undef) = caller;
    unless ($package_of_caller->isa('RunLoop')) {
	croak "Only RunLoop may call method execute of Timer.\n";
    }
    
    $this->{code}->($this);

    if (defined $this->{interval}) {
	$this->{fire_time} += $this->{interval};
    }
    else {
	$this->uninstall;
    }
    
    $this;
}

sub interval {
    # ŪundefϤСinterval롣
    my ($this,$value) = @_;
    if (defined $value) {
	$this->{interval} = $value;
    }
    elsif (@_ >= 2) {
	$this->{interval} = undef;
    }
    $this->{interval};
}

1;
