# -----------------------------------------------------------------------------
# $Id: PersonalInfo.pm,v 1.5 2003/06/03 15:27:42 admin Exp $
# -----------------------------------------------------------------------------
# nick,username,userhostĸĿ;ݻ饹
# Υ֥ȤIrcIO::Server롣
# 
# my $info = new PersonalInfo(Nick => 'saitama');
# print $info->nick;
# $info->nick("taiyou");
# -----------------------------------------------------------------------------
package PersonalInfo;
use strict;
use warnings;
use Carp;
our $AUTOLOAD;

sub new {
    my ($class,%args) = @_;
    my $def_or_null = sub{ defined $_[0] ? $_[0] : '' };
    my $obj = {
	nick => $def_or_null->($args{Nick}),
	username => $def_or_null->($args{UserName}),
	userhost => $def_or_null->($args{UserHost}),
	realname => $def_or_null->($args{RealName}),
	server => $def_or_null->($args{Server}),
    };
    bless $obj,$class;

    # NickꤵƤɤ
    unless (defined $obj->{nick}) {
	croak "PersonalInfo must be created with Nick parameter.\n";
    }
    
    $obj;
}

sub info {
    my ($this) = @_;
    sprintf('%s!%s@%s',$this->nick||'',$this->username||'',$this->userhost||'');
}

sub AUTOLOAD {
    my ($this,$option) = @_;
    (my $key = $AUTOLOAD) =~ s/^.*?:://g;

    if ($key eq 'DESTROY') {
	return;
    }
    
    unless (defined $this->{$key}) {
	croak "PersonalInfo doesn't have the information $key.\n";
    }

    if (defined $option) {
	$this->{$key} = $option;
    }
    return $this->{$key};
}

1;
