# -----------------------------------------------------------------------------
# $Id: Multicast.pm,v 1.16 2003/08/17 15:18:53 topia Exp $
# -----------------------------------------------------------------------------
# С饯饤Ȥ˥åήȤΥ饹ϥե륿Ȥ
# ͥåȥ̾ղäޤ
# 饤Ȥ饵СήȤΥ饹ϥͥåȥ̾ѡ
# ٤ƥСޤ
# 뢫ХnickѴ⤳ǹԤޤ
# -----------------------------------------------------------------------------
package Multicast;
use strict;
use warnings;
use Configuration;
use Carp;
my $runloop = undef; # ǥեȤRunLoopΥå塣
my $default_network = ''; # ǥեȤΥͥåȥ̾Υå塣
my $separator = ''; # ѥ졼Υå塣cast_messageƤФ٤˹롣

sub _ISON_from_client {
    # nickͥåȥʬह롣
    my ($message, $sender) = @_;
    my $networks = classify($message->params);

    while (my ($network_name,$params) = each %$networks) {
	my $network = $runloop->networks->{$network_name};
	@$params = map( local_to_global($_,$network) ,@$params);

	forward_to_server(new IRCMessage(
			      Command => $message->command,
			      Params => $params),
			  $network_name);
    }
}

sub _INVITE_from_server {
    my ($message,$sender) = @_;
    # nickϤΤޤޡͥˤϥͥåȥ̾դ롣
    $message->nick(global_to_local($message->nick,$sender));
    $message->params->[0] = global_to_local($message->params->[0],$sender);
    $message->params->[1] = attach($message->params->[1],$sender->network_name);
    return $message;
}
sub _INVITE_from_client {
    my ($message,$sender) = @_;
    # nickϥѡǼΤƤ롣ͥΥѡ̤򸫤롣
    my $to = '';
    ($message->params->[0]) = detatch($message->params->[0]);
    ($message->params->[1],$to) = detatch($message->params->[1]);
    $message->params->[0] = local_to_global($message->params->[0],$to); # ʬINVITEʤ̵Τɬפ̵
    forward_to_server($message,$to);
}

sub _JOIN_from_server {
    my ($message,$sender) = @_;
    # ޤǶڤʣΥͥ뤬ꤵƤȤƤ
    # Ƥ˥ͥåȥ̾ղä롣(ޤ̵)
    $message->nick(global_to_local($message->nick,$sender));

    my @channels = split(/,/,$message->params->[0]);
    my $n_channels = @channels;
    for (my $i = 0; $i < $n_channels; $i++) {
	$channels[$i] = attach($channels[$i],$sender->network_name);
    }
    $message->params->[0] = join(',',@channels);
    return $message;
}
sub _JOIN_from_client {
    my ($message,$sender) = @_;
    # ѥɤʬϮ餺ͥåȥ̾ѡƼ
    # ƥͥͥåȥʬह롣
    if ($message->params->[0] eq '0') {
	# 0ü졣
	# ƤΥСJOIN 0롣
	distribute_to_servers(
	    new IRCMessage(
		Command => 'JOIN',
		Param => '0'));
    }
    else {
	my @targets = split(/,/,$message->params->[0]);
	my $networks = classify(\@targets);
	while (my ($network_name,$channels) = each %$networks) {
	    $message->params->[0] = join(',',@$channels);
	    forward_to_server($message,$network_name);
	}
    }
}

sub _KICK_from_server {
    my ($message,$sender) = @_;
    # ͥ̾ˤͥåȥ̾ղä롣
    $message->nick(global_to_local($message->nick,$sender));
    $message->params->[0] = attach($message->params->[0],$sender->network_name);
    $message->params->[1] = global_to_local($message->params->[1],$sender);
    return $message;
}
sub _KICK_from_client {
    my ($message,$sender) = @_;
    my @channels = split(/,/,$message->params->[0]);
    my @nicks = split(/,/,$message->params->[1]);
    if (scalar(@channels) == scalar(@nicks)) {
	# ͥnickаб롣
	# ͥΥͥåȥ̾ѤnickΥͥåȥ̾ϼΤƤ롣
	for (my $i = 0; $i < @channels; $i++) {
	    my ($raw_channel,$to) = detatch($channels[$i]);
	    my ($raw_nick) = detatch($nicks[$i]);

	    $message->params->[0] = $raw_channel;
	    $message->params->[1] = local_to_global($raw_nick,$runloop->networks->{$to});
	    forward_to_server($message,$to);		    
	}
    }
    elsif (@channels == 1) {
	# ĤΥͥ뤫ʣnick򽳤Ф
	# ͥΥͥåȥ̾ѤnickΥͥåȥ̾ϼΤƤ롣
	my ($raw_channel,$to) = detatch($channels[0]);
	my $network = $runloop->networks->{$to};
	$message->params->[0] = $raw_channel;

	foreach my $nick (@nicks) {
	    my ($raw_nick) = detatch($nick);
	    $message->params->[1] = local_to_global($raw_nick,$network);

	    forward_to_server($message,$to);
	}
    }
}

sub _LIST_from_client {
    my ($message,$sender) = @_;
    # ͥΥͥåȥ̾ʬࡣ
    if (defined $message->params->[0]) {
	my @targets = split(/,/,$message->params->[0]);
	my $networks = classify(\@targets);

	while (my ($network_name,$channels) = each %$networks) {
	    $message->params->[0] = join(',',@$channels);
	    forward_to_server($message,$network_name);
	}
    }
    else {
	forward_to_server($message, $default_network);
    }
}

sub _MODE_from_server {
    my ($message,$sender) = @_;
    $message->nick(global_to_local($message->nick,$sender));
    @{$message->params} = map( global_to_local($_,$sender) ,@{$message->params});
    
    my $target = $message->params->[0];
    unless (nick_p($target)) {
	# nick(Ĥޤ꼫ʬ)ξϤΤޤޥ饤Ȥۡ
	# ξϥͥʤΤǡͥåȥ̾ղá
	$message->params->[0] = attach($target,$sender->network_name);	
    }
    return $message;
}
sub _MODE_from_client {
    my ($message,$sender) = @_;
    my $to;
    ($message->params->[0],$to) = detatch($message->params->[0]);

    my $network = $runloop->networks->{$to};
    @{$message->params} = map( local_to_global($_,$network) ,@{$message->params});
    
    forward_to_server($message,$to);
}

sub _NICK_from_client {
    # ͥåȥ̾ꤵƤ顢λˤΤNICK
    # ǤʤƤλ롣
    my ($message,$sender) = @_;
    my $to;
    my $specified;
    ($message->params->[0],$to,$specified) = detatch($message->params->[0]);
    
    if ($specified) {	
	forward_to_server($message,$to);
    }
    else {
	distribute_to_servers($message);
    }
}

sub _NJOIN_from_server {
    my ($message,$sender) = @_;
    $message->param(0,attach($message->param(0),$sender->network_name));
    $message->param(1,
		    join(',',
			 map{ s/^([@+]*)(.+)$/$1.global_to_local($2,$sender)/e; $_; } split(/,/,$message->param(1))));
    $message;
}

sub _WHOIS_from_client {
    my ($message,$sender) = @_;
    my $to;
    ($message->params->[0],$to) = detatch($message->params->[0]);
    
    my $network = $runloop->networks->{$to};
    $message->params->[0] = local_to_global($message->params->[0],$runloop->networks->{$to});
    
    # nickΥХnickۤʤäƤ顢λݤ򥯥饤Ȥ𤹤롣
    # WHOISоݤʬäΤߡ
    my $local_nick = $runloop->current_nick;
    my $global_nick = $network->current_nick;
    if (($message->command eq 'WHOIS' || $message->command eq 'WHO') &&
	$message->param(0) eq $global_nick &&
	$local_nick ne $global_nick) {
	$sender->send_message(
	    new IRCMessage(Command => 'NOTICE',
			   Params => [$local_nick,
				      "*** Your global nick in $to is currently '$global_nick'."]));
    }
    
    forward_to_server($message,$to);
}

sub _RPL_USERHOST {
    my ($message,$sender) = @_;
    $message->params->[1] =~ s/^([^*=]+)(.+)$/global_to_local($1,$sender).$2/e;
    $message;
}

sub _RPL_ISON {
    my ($message,$sender) = @_;
    $message->params->[1] =
	join(' ',
	     map {
		 global_to_local($_,$sender);
	     } split / /,$message->params->[1]);
    $message;
}

sub _RPL_INVITING {
    my ($message,$sender) = @_;
    $message->param(1,attach($message->param(1),$sender->network_name));
    $message->param(2,global_to_local($message->param(2),$sender));
    $message;
}

sub _RPL_WHOREPLY {
    my ($message,$sender) = @_;
    $message->param(1,attach($message->param(1),$sender->network_name));
    $message->param(5,global_to_local($message->param(5),$sender));
    $message;
}

sub _RPL_NAMREPLY {
    my ($message,$sender) = @_;
    $message->param(2,attach($message->param(2),$sender->network_name));
    $message->params->[3] =
	join(' ',
	     map {
		 s/^([@+]*)(.+)$/$1.global_to_local($2,$sender)/e; $_;
	     } split / /,$message->params->[3]);
    $message;
}

my $g2l_cache = {};
sub _gen_g2l_translator {
    my $index = shift;
    
    unless (exists $g2l_cache->{$index}) {
	$g2l_cache->{$index} = sub {
	    my ($message,$sender) = @_;
	    $message->params->[$index] = global_to_local($message->params->[$index],$sender);
	    $message;
	};
    }
    $g2l_cache->{$index};
}

my $attach_cache = {};
sub _gen_attach_translator {
    my $index = shift;

    unless (exists $attach_cache->{$index}) {
	$attach_cache->{$index} = sub {
	    my ($message,$sender) = @_;
	    $message->param($index,attach($message->param($index),$sender->network_name));
	    $message;
	};
    }
    $attach_cache->{$index};
}

my $detach_cache = {};
sub _gen_detach_translator {
    my $index = shift;

    if (!exists $detach_cache->{$index}) {
	$detach_cache->{$index} = sub {
	    my ($message, $sender) = @_;
	    $message->param(
		$index,
		detach($message->param($index)));
	    forward_to_server($message, $sender);
	};
    }
    $detach_cache->{$index};
}

my $server_sent = {
    'INVITE' => \&_INVITE_from_server,
    'JOIN' => \&_JOIN_from_server,
    'KICK' => \&_KICK_from_server,
    'MODE' => \&_MODE_from_server,
    'NICK' => undef, # ΤϻNICKϮʤ򸫤ƾ򹹿ΤIrcIO::ServerǤ롣
    'NOTICE' => \&_MODE_from_server, # MODEƱɤPrefixϮȤСϥ⥸塼ܡ
    'PART' => \&_JOIN_from_server, # JOINƱɤ
    'PING' => undef,
    'PRIVMSG' => \&_MODE_from_server, # NOTICEƱɤ
    'QUIT' => undef, # QUITΤʬäΤƤ롢ȤäIrcIO::ServerԤʤ
    'SQUERY' => \&_MODE_from_server, # ¿ʬϻɤʬʤ
    'TOPIC' => \&_MODE_from_server,
    'NJOIN' => \&_NJOIN_from_server,
    '301' => _gen_g2l_translator(1), # AWAY
    '302' => \&_RPL_USERHOST,
    '303' => \&_RPL_ISON,
    '311' => _gen_g2l_translator(1), # WHOISUSER
    '312' => _gen_g2l_translator(1), # WHOISSERVER
    '313' => _gen_g2l_translator(1), # WHOISOPERATOR
    '317' => _gen_g2l_translator(1), # WHOISIDLE
    '318' => _gen_g2l_translator(1), # ENDOFWHOIS
    '319' => _gen_g2l_translator(1), # WHOISCHANNELS
    '314' => _gen_g2l_translator(1), # WHOWASUSER
    '369' => _gen_g2l_translator(1), # ENDOFWHOWAS
    '322' => _gen_attach_translator(1), # LIST
    '325' => \&_RPL_INVITING, # UNIQOPIS (INVITINGƱ)
    '324' => _gen_attach_translator(1), # CHANNELMODEIS
    '331' => _gen_attach_translator(1), # NOTOPIC
    '332' => _gen_attach_translator(1), # TOPIC
    '341' => \&_RPL_INVITING,
    '346' => _gen_attach_translator(1), # INVITELIST
    '347' => _gen_attach_translator(1), # ENDOFINVITELIST
    '348' => _gen_attach_translator(1), # EXCEPTLIST
    '349' => _gen_attach_translator(1), # ENDOFEXCEPTLIST
    '352' => \&_RPL_WHOREPLY,
    '315' => _gen_attach_translator(1), # ENDOFWHO
    '353' => \&_RPL_NAMREPLY,
    '366' => _gen_attach_translator(1), # ENDOFNAMES
    '367' => _gen_attach_translator(1), # BANLIST
    '368' => _gen_attach_translator(1), # ENDOFBANLIST
    # TRACEϤΥץ饤TiarraϴΤʤʤȤ⺣ΤȤϡ
};

my $client_sent = {
    'ISON' => \&_ISON_from_client,
    'INVITE' => \&_INVITE_from_client,
    'JOIN' => \&_JOIN_from_client,
    'KICK' => \&_KICK_from_client,
    'LIST' => \&_LIST_from_client,
    'MODE' => \&_MODE_from_client,
    'NAMES' => \&_LIST_from_client, # LISTƱɤ
    'NICK' => \&_NICK_from_client,
    'NOTICE' => \&_LIST_from_client, # LISTƱɤ
    #'MODE' => \&_MODE_from_client, # MODEƱɤ
    #տ
    'PART' => \&_LIST_from_client, # LISTƱɤ
    'PASS' => \&_MODE_from_client, # ܤ˽ʤSERVICEʤMODEƱɤ
    'PONG' => undef,
    'PRIVMSG' => \&_LIST_from_client, # NOTICEƱɤ
    'QUIT' => undef, # QUITȥåפΤIrcIO::ClientĤޤꤳˤϷ褷QUITήʤ
    'SERVICE' => \&_MODE_from_client, # ɤʬʤȤꤢMODEƱˤ롣
    'SERVLIST' => \&_MODE_from_client, # ɤʬʤMODEƱˡ
    'SERVSET' => \&_MODE_from_client, # ⡣
    'SQUERY' => \&_MODE_from_client, # 
    'STATS' => \&_MODE_from_client,
    'SUMMON' => \&_MODE_from_client,
    'TIME' => \&_MODE_from_client,
    'TOPIC' => \&_MODE_from_client,
    'TRACE' => \&_MODE_from_client,
    'UMODE' => \&_MODE_from_client,
    'USER' => undef,
    'USERHOST' => \&_ISON_from_client,
    'USERS' => \&_MODE_from_client,
    'VERSION' => \&_MODE_from_client,
    'WHO' => \&_WHOIS_from_client,
    'WHOIS' => \&_WHOIS_from_client,
    'WHOWAS' => \&_WHOIS_from_client,
    'CLOSE' => \&_MODE_from_client,
    'CONNECT' => \&_MODE_from_client, # ̵뤬
    'DIE' => \&_MODE_from_client,
    'KILL' => \&_MODE_from_client,
    'REHASH' => \&_MODE_from_client,
    'RESTART' => \&_MODE_from_client,
    'SQUIT' => \&_MODE_from_client,
    'ERROR' => undef,
    'NJOIN' => undef, # 饤ȤNJOINȯԤΤ̵̣
    'RECONNECT' => undef,
    'SERVER' => undef,
    'WALLOPS' => \&_MODE_from_client, # 饤ȤWALLOPSȯԽΤɤΤʤ
    # ʲץ饤detach_network_nameΰ٤ˤ롣
    '322' => _gen_detach_translator(1), # LIST
    '325' => _gen_detach_translator(1), # UNIQOPIS (INVITINGƱ)
    '324' => _gen_detach_translator(1), # CHANNELMODEIS
    '331' => _gen_detach_translator(1), # NOTOPIC
    '332' => _gen_detach_translator(1), # TOPIC
    '341' => _gen_detach_translator(1), # INVITING
    '346' => _gen_detach_translator(1), # INVITELIST
    '347' => _gen_detach_translator(1), # ENDOFINVITELIST
    '348' => _gen_detach_translator(1), # EXCEPTLIST
    '349' => _gen_detach_translator(1), # ENDOFEXCEPTLIST
    '352' => _gen_detach_translator(1), # WHOREPLY
    '315' => _gen_detach_translator(1), # ENDOFWHO
    '353' => _gen_detach_translator(2), # NAMREPLY
    '366' => _gen_detach_translator(1), # ENDOFNAMES
    '367' => _gen_detach_translator(1), # BANLIST
    '368' => _gen_detach_translator(1), # ENDOFBANLIST
};


sub _update_cache {
    my $networks = Configuration->shared_conf->networks;

    if (RunLoop->shared->multi_server_mode_p) {
	$default_network = $networks->default;
    }
    else {
	$default_network = (RunLoop->shared->networks_list)[0]->network_name;
    }

    $separator = $networks->channel_network_separator;
    $runloop = RunLoop->shared_loop;
}

sub from_server_to_client {
    no warnings;
    my ($message, $sender) = @_;
    &_update_cache;
    # server -> clientήǤϡĤΥåʣʬ䤵̵
    # δؿϰĤIRCMessage֤

    if ($message->command =~ /^\d+$/) {
	# ˥塼åץ饤0ܤΥѥ᥿nick
	$message->params->[0] = global_to_local($message->params->[0],$sender);
    }

    eval {
	# ե륿̵äꡢե륿μ¹㳰äꤷϤΤޤ֤
	$message = $server_sent->{$message->command}->($message, $sender);
    }; if ($@) {
	$message->nick(global_to_local($message->nick,$sender));
    }
    return $message;
}

sub from_client_to_server {
    no warnings;
    my ($message, $sender) = @_;
    &_update_cache;
    # client -> serverήǤϡĤΥåʣʬ䤵롣
    # δؿϥå򻪤ľꡢ֤ͤʤ
    eval {
	$client_sent->{$message->command}->($message, $sender);
    }; if ($@) {
	forward_to_server($message,$default_network);
    }
}

sub detach_network_name {
    no strict;
    no warnings;
    my ($message, $sender) = @_;
    &_update_cache;
    my $result;
    local $hijack_forward_to_server = sub {
	my ($msg, $network_name) = @_;
	$result = $msg;
    };
    local $hijack_local_to_global = 1;
    eval {
	$client_sent->{$message->command}->($message, $sender);
    }; if ($@) {
	$hijack_forward_to_server->($message, $default_network);
    }
    $result;
}

*detatch = \&detach; # 㤤Ƥdetach
sub detach {
    # : (ѥ졼ʸ,ͥåȥ̾,ͥåȥ̾줿ɤ)
    # 顼ƥȤǤϥѥ졼ʸΤߤ֤
    my $str = shift;

    if (!defined $str) {
	croak "Arg[0] was undef.\n";
    }
    elsif (ref($str) ne '') {
	croak "Arg[0] was ref.\n";
    }

    my ($pkg_caller) = caller;
    _update_cache() unless $pkg_caller->isa('Multicast');

    my @result;
    if ((my $sep_index = index($str,$separator)) != -1) {
	my $before_sep = substr($str,0,$sep_index);
	my $after_sep = substr($str,$sep_index+length($separator));
	if ((my $colon_pos = index($after_sep,':')) != -1) {
	    # #@taiyou:*.jp    #:*.jp + taiyou
	    @result = ($before_sep.substr($after_sep,$colon_pos),
		       substr($after_sep,0,$colon_pos),
		       1);
	}
	else {
	    # #@taiyou    # + taiyou
	    @result = ($before_sep,$after_sep,1);
	}
    }
    else {
	@result = ($str,$default_network,undef);
    }
    return wantarray ? @result : $result[0];
}

sub attach {
    # $strChannelInfoΥ֥ȤǤɤ
    # $network_nameϾάǽIrcIO::ServerΥ֥ȤǤɤ
    my ($str,$network_name) = @_;
    if (ref($str) eq 'ChannelInfo') {
	$str = $str->name;
    }
    if (ref($network_name) eq 'IrcIO::Server') {
	$network_name = $network_name->network_name;
    }

    if (!defined $str) {
	croak "Arg[0] was undef.\n";
    }
    elsif (ref($str) ne '') {
	croak "Arg[0] was ref.\n";
    }

    my ($pkg_caller) = caller;
    _update_cache() unless $pkg_caller->isa('Multicast');

    $network_name = $default_network if $network_name eq '';
    if ((my $pos_colon = index($str,':')) != -1) {
	# #:*.jp    #@taiyou:*.jp
	$str =~ s/:/$separator.$network_name.':'/e;
    }
    else {
	# #    #@taiyou
	$str .= $separator.$network_name;
    }
    $str;
}

sub classify {
    # array: ؤλ
    # : ͥåȥ̾ѡʸ¤٤ؤλ
    my $array = shift;
    my $networks = {};
    foreach my $target (@$array) {
	my ($str,$network_name) = detatch($target);
	if (defined $networks->{$network_name}) {
	    push @{$networks->{$network_name}},$str;
	}
	else {
	    # Ƹ줿ͥåȥǤ롣
	    $networks->{$network_name} = [$str];
	}
    }
    return $networks;
}

sub forward_to_server {
    # δؿϡưŪפ֤줿ѿ
    # $hijack_forward_to_serverƤ顢
    # ؿեȸƥС˸Ƥ֡
    no strict;
    my ($msg, $network_name) = @_;

    if (defined $hijack_forward_to_server) {
	#::printmsg("forward_to_server HIJACKED");
	$hijack_forward_to_server->($msg, $network_name);
    }
    else {
	my $io = $runloop->network($network_name);
	if (defined $io) {
	    $io->send_message($msg);
	}
    }
}

sub distribute_to_servers {
    my $msg = shift;
    foreach my $server (values %{$runloop->networks}) {
	$server->send_message($msg);
    }
}

sub nick_p {
    # ʸnickȤƵǤ뤫ɤ򿿵֤ͤ
    my $str = detach(shift);
    return undef unless length($str);

    my $first_char = '[a-zA-Z_\[\]\\\`\^\{\}]';
    my $remaining_char = '[0-9a-zA-Z_\-\[\]\\\`\^\{\}]';
    return $str =~ /^${first_char}${remaining_char}*$/;
}

sub channel_p {
    # ʸchannelȤƵǤ뤫ɤ򿿵֤ͤ
    my $str = detach(shift);
    return undef unless length($str);

    my $first_char = '[\#\&\+\!]';
    my $suffix_spec = '(?::[a-z*.]+)?';
    return $str =~ /^${first_char}.*${suffix_spec}$/
}

sub local_to_global {
    # δؿϡưŪפ֤줿ѿ
    # $hijack_local_to_globalƤ顢
    # ѹ֤
    no strict;
    my ($str, $server) = @_;
    if (defined $hijack_local_to_global) {
	$str;
    }
    else {
	if (defined($str) && $str eq $runloop->current_nick) {
	    $server->current_nick;
	}
	else {
	    $str;
	}
    }
}

sub global_to_local {
    my ($str,$server) = @_;
    if (defined($str) && $str eq $server->current_nick) {
	return $runloop->current_nick;
    }
    else {
	return $str;
    }
}

1;
