# -----------------------------------------------------------------------------
# $Id: Server.pm,v 1.44 2003/07/28 12:35:58 admin Exp $
# -----------------------------------------------------------------------------
# IrcIO::ServerIRCС³IRCåꤹ륯饹Ǥ
# Υ饹ϥСåäƥͥ丽ߤnickʤɤݻޤ
# äå⥸塼̤ƥ饤ȤžϤޤ
# RunLoopܤǤ
# -----------------------------------------------------------------------------
package IrcIO::Server;
use strict;
use warnings;
use base qw(IrcIO);
use Carp;
use ChannelInfo;
use PersonalInfo;
use PersonInChannel;
use Configuration;
use UNIVERSAL;

sub new {
    my ($class,$network_name) = @_;
    my $obj = $class->SUPER::new;
    $obj->{network_name} = $network_name;
    $obj->{current_nick} = ''; # ߻nick󤷤Ƥʤж
    $obj->reload_config;

    $obj->{logged_in} = 0; # ΥСؤΥƤ뤫ɤ
    $obj->{new_connection} = 1;
    $obj->{remarks} = {}; # {key => value}
    
    $obj->{receiving_namreply} = {}; # RPL_NAMREPLY<ͥ̾,1>ˤʤꡢRPL_ENDOFNAMESȤΥͥǤä롣
    $obj->{receiving_banlist} = {}; # Ʊ塣RPL_BANLIST
    $obj->{receiving_exceptlist} = {}; # Ʊ塣RPL_EXCEPTLIST
    $obj->{receiving_invitelist} = {}; # Ʊ塢RPL_INVITELIST

    $obj->{channels} = {}; # ͥ̾ => ChannelInfo
    $obj->{people} = {}; # nick => PersonalInfo
    
    $obj->connect;
}

sub network_name {
    shift->{network_name};
}

sub current_nick {
    shift->{current_nick};
}

sub channels {
    # @options(άǽ):
    #   'even-if-kicked-out': ˼ʬФƤ֤ͥưϹ®Ǥ롣
    my ($this, @options) = @_;
    if (defined $options[0] && $options[0] eq 'even-if-kicked-out') {
	$this->{channels};
    }
    else {
	# kicked-outե饰ΩĤƤʤͥΤ֤
	my %result = map {
	    ($_, $this->{channels}{$_});
	} grep {
	    !$this->{channels}{$_}->remarks('kicked-out');
	} keys %{$this->{channels}};
	\%result;
    }
}

sub channels_list {
    # @options(άǽ):
    #   'even-if-kicked-out': ˼ʬФƤ֤ͥưϹ®Ǥ롣
    my ($this, @options) = @_;
    if (defined $options[0] && $options[0] eq 'even-if-kicked-out') {
	values %{$this->{channels}};
    }
    else {
	# kicked-outե饰ΩĤƤʤͥΤ֤
	grep {
	    !$_->remarks('kicked-out');
	} values %{$this->{channels}};
    }
}

sub person_list {
    values %{shift->{people}};
}

sub host {
    shift->{server_host};
}

sub fullname {
    $_[0]->{current_nick}.'!'.$_[0]->{user_shortname}.'@'.$_[0]->{server_host};
}

sub config {
    # Υ֥ȤѤ줿Configuration::Block֤
    shift->{config};
}

sub reload_config {
    my $this = shift;
    my $conf = $this->{config} = Configuration->shared->get($this->{network_name});
    my $general = Configuration->shared->general;
    $this->{server_host} = $conf->host;
    $this->{server_port} = $conf->port;
    $this->{destination} = do {
	if ($this->{server_host} =~ m/^[0-9a-fA-F:]+$/) {
	    "[$this->{server_host}]:$this->{server_port}";
	}
	else {
	    "$this->{server_host}:$this->{server_port}";
	}
    };
    my $def = sub{defined$_[0]?$_[0]:$_[1]};
    $this->{server_password} = $conf->password;
    $this->{initial_nick} = $def->($conf->nick,$general->nick); # ꤹnick
    $this->{user_shortname} = $def->($conf->user,$general->user);
    $this->{user_realname} = $def->($conf->name,$general->name);
}

sub remark {
    my ($this,$key,$newvalue) = @_;
    if (defined $newvalue) {
	$this->{remarks}{$key} = $newvalue;
    }
    $this->{remarks}{$key};
}

sub person {
    # nickʳƾάǽ
    # ̤Τnickꤵ줿Ͽɲä롣
    my ($this,$nick,$username,$userhost,$realname,$server) = @_;
    return if !defined $nick;
    
    my $info = $this->{people}->{$nick};
    if (!defined($info)) {
	$info = $this->{people}->{$nick} =
	    new PersonalInfo(Nick => $nick,
			     UserName => $username,
			     UserHost => $userhost,
			     RealName => $realname,
			     Server => $server);
    }
    else {
	$info->username($username);
	$info->userhost($userhost);
	$info->realname($realname);
	$info->server($server);	
    }
    $info;
}

sub channel {
    my ($this,$channel_name) = @_;
    $this->{channels}->{$channel_name};
}

sub connect {
    my $this = shift;
    return if $this->connected;

    # ٤եɤ
    $this->{nick_retry} = 0;
    $this->{logged_in} = undef;

    my $server_host = $this->{server_host};
    my $server_port = $this->{server_port};

    # ɲåѥ᡼
    my $conf = Configuration->shared;
    my $additional_ipv4 = {};
    my $ipv4_bind_addr =
	$conf->get($this->{network_name})->ipv4_bind_addr ||
	$conf->general->ipv4_bind_addr ||
	$conf->get($this->{network_name})->bind_addr ||
	$conf->general->bind_addr; # ʾĤϲߴΰ٤˻Ĥ
    if (defined $ipv4_bind_addr) {
	$additional_ipv4->{LocalAddr} = $ipv4_bind_addr;
    }
    my $additional_ipv6 = {};
    my $ipv6_bind_addr =
	Configuration->shared->get($this->{network_name})->ipv6_bind_addr ||
	Configuration->shared->general->ipv6_bind_addr;
    if (defined $ipv6_bind_addr) {
	$additional_ipv6->{LocalAddr} = $ipv6_bind_addr;
    }
    
    # åȤ򳫤ʤädie
    # ³ϼΤ褦ˤƹԤʤ
    # 1. ۥȤIPv4ɥ쥹ǤСIPv4Ȥ³ߤ롣
    # 2. ۥȤIPv6ɥ쥹ǤСIPv6Ȥ³ߤ롣
    # 3. ɤηǤʤ(Ĥޤۥ̾)ǤС
    #    a. IPv6ѲǽʤIPv6Ǥ³ߤ塢ܤʤIPv4˥եХå
    #    b. IPv6ѲǽǤʤСǽ餫IPv4Ǥ³ߤ롣
    my @new_socket_args = (
	PeerAddr => $server_host,
	PeerPort => $server_port,
	Proto => 'tcp',
	Timeout => 5,
    );
    my $sock = do {
	if ($server_host =~ m/^(?:\d+\.){3}\d+$/) {
	    IO::Socket::INET->new(@new_socket_args,%$additional_ipv4);
	}
	elsif ($server_host =~ m/^[0-9a-fA-F:]+$/) {
	    if (&::ipv6_enabled) {
		IO::Socket::INET6->new(@new_socket_args,%$additional_ipv6);
	    }
	    else {
		die qq{Host $server_host seems to be an IPv6 address, }.
		    qq{but IPv6 support is not enabled. }.
		    qq{Use IPv4 server or install Socket6.pm if possible.\n};
	    }
	}
	else {
	    if (&::ipv6_enabled) {
		my $s = IO::Socket::INET6->new(@new_socket_args,%$additional_ipv6);
		if (defined $s) {
		    # IPv6Ǥ³
		    $s;
		}
		else {
		    # IPv4˥եХå
		    IO::Socket::INET->new(@new_socket_args,%$additional_ipv4);
		}
	    }
	    else {
		IO::Socket::INET->new(@new_socket_args,%$additional_ipv4);
	    }
	}
    };
    if (defined $sock) {
	$sock->autoflush(1);
	$this->{sock} = $sock;
	$this->{connected} = 1;
	my $ip_version = do {
	    if ($sock->isa('IO::Socket::INET')) {
		'IPv4';
	    }
	    else {
		'IPv6';
	    }
	};
	::printmsg("Opened connection to $this->{destination} ($ip_version)");
    }
    else {
	die "Couldn't connect to $this->{destination}\n";
    }
    
    # (PASS) -> NICK -> USERν롣
    # NICKɤ³receive᥽åɤȽǤ롣
    my $server_password = $this->{server_password};
    if (defined $server_password && $server_password ne '') {
	$this->send_message(new IRCMessage(
				Command => 'PASS',
				Param => $this->{server_password}));
    }
    if (!defined $this->{current_nick} || $this->{current_nick} eq '') {
	$this->{current_nick} = $this->{initial_nick};
    }
    $this->send_message(new IRCMessage(
			    Command => 'NICK',
			    Param => $this->{current_nick}));

    # +iʤɤʸ󤫤桼⡼ͤ򻻽Ф롣
    my $usermode = 0;
    if (my $usermode_str = Configuration->shared->general->user_mode) {
	if ($usermode_str =~ /^\+/) {
	    foreach my $c (split //,substr($usermode_str,1)) {
		if ($c eq 'w') {
		    $usermode |= (1 << 2);
		}
		elsif ($c eq 'i') {
		    $usermode |= (1 << 3);
		}
	    }
	}
    }
    $this->send_message(new IRCMessage(
			    Command => 'USER',
			    Params => [$this->{user_shortname},
				       $usermode,
				       '*',
				       $this->{user_realname}]));
    $this;
}

sub disconnect {
    my $this = shift;
    
    $this->SUPER::disconnect;
    ::printmsg("Disconnected from $this->{destination}.");
}

sub send_message {
    my ($this,$msg) = @_;

    if (!defined $msg) {
	croak "IrcIO::Server->send_message, Arg[1] was undef.\n";
    }
    elsif (!ref($msg)) {
	croak "IrcIO::Server->send_message, Arg[1] was not ref.\n";
    }
    elsif (!UNIVERSAL::isa($msg, 'IRCMessage')) {
	croak "IrcIO::Server->send_message, Arg[1] was bad ref: ".ref($msg)."\n";
    }

    # ƥ⥸塼
    RunLoop->shared->notify_modules('notification_of_message_io',$msg,$this,'out');
    
    $this->SUPER::send_message(
	$msg,
	Configuration->shared->get($this->{network_name})->out_encoding ||
	Configuration->shared->general->server_out_encoding);
}

sub receive {
    my $this = shift;
    my @receipts = $this->SUPER::receive(
	Configuration->shared->get($this->{network_name})->in_encoding ||
	Configuration->shared->general->server_in_encoding);

    # ³ڤ줿顢ƥ⥸塼RunLoop
    if (!$this->connected) {
	RunLoop->shared->notify_modules('disconnected_from_server',$this);
	RunLoop->shared->disconnected_server($this);
    }
}

sub pop_queue {
    my ($this) = shift;
    my $msg = $this->SUPER::pop_queue;
    
    # Υ᥽åɤϥ󤷤ƤʤХ󤹤뤬
    # ѥɤ㤦ʤɤǲ٤ľƤ븫ߤ̵
    # ³ڤäƤdieޤ
    if (defined $msg) {
	# ƥ⥸塼
	RunLoop->shared->notify_modules('notification_of_message_io',$msg,$this,'in');
	
	# 椫
	if ($this->{logged_in}) {
	    # Ǥʤ
	    return $this->_receive_after_logged_in($msg);
	}
	else {
	    return $this->_receive_while_logging_in($msg);
	}
    }
    return $msg;
}

sub _receive_while_logging_in {
    my ($this,$first_msg) = @_;
    
    # ޤǤΤʤ顢ɤ
    # ǽ˼äԤ001()433(nickʣ)ʳȽǤ롣
    my $reply = $first_msg->command;
    if ($reply eq '001') {
	# 
	$this->{current_nick} = $first_msg->param(0);
	$this->{logged_in} = 1;
	$this->person($this->{current_nick},
		      $this->{user_shortname},
		      $this->{user_realname});
	
	::printmsg("Logged-in successfuly into $this->{destination}.");

	# ƥ⥸塼˥СɲäΤԤʤ
	RunLoop->shared->notify_modules('connected_to_server',$this,$this->{new_connection});
	# ³äν
	if (!$this->{new_connection}) {
	    RunLoop->shared->reconnected_server($this);
	}
	$this->{new_connection} = undef;
    }
    elsif ($reply eq '433') {
	# nickʣ
	$this->_set_to_next_nick($first_msg->param(1));
	return; # ֤ʤ饤ȤˤϤη̤Τ餻ʤ
    }
    else {
	# ʳǤ褦ʤΤconnectionǤƤޤ
	# â˥塼åץ饤Ǥʤ̵뤹롣
	if ($reply =~ m/^\d+/) {
	    $this->disconnect;
	    die "Server replied $reply.\n".$first_msg->serialize."\n";
	}
	else {
	    return;
	}
    }
    return $first_msg;
}

sub _receive_after_logged_in {
    my ($this,$msg) = @_;

    $this->person($msg->nick,$msg->name,$msg->host); # namehostФƤ
    
    if ($msg->command eq 'NICK') {
	# nickѤΤʬʤ顢򥯥饤Ȥˤʤ
	my $current_nick = $this->{current_nick};
	if ($msg->nick eq $current_nick) {
	    $this->{current_nick} = $msg->param(0);
	    
	    # ǾäƤޤȥץ饰ˤNICKԤʤʤ롣
	    # ä"do-not-send-to-clients => 1"Ȥդ롣
	    $msg->remark('do-not-send-to-clients',1);
	    
	    # nickȰäƤСλݤΤ롣
	    # ânetworks/always-notify-new-nickꤵƤоΤ롣
	    my $local_nick = RunLoop->shared_loop->current_nick;
	    if (Configuration->shared->networks->always_notify_new_nick ||
		$this->{current_nick} ne $local_nick) {

		RunLoop->shared_loop->broadcast_to_clients(
		    IRCMessage->new(
			Command => 'NOTICE',
			Params => [$local_nick,
				   "*** Your global nick in ".
				   $this->{network_name}.
				   " is currently '".$this->{current_nick}."'."]));
	    }
	}
	$this->_NICK($msg);
    }
    elsif ($msg->command eq '433') {
	# nick˻
	$this->_set_to_next_nick($msg->param(1));
	
	# ⥯饤Ȥˤʤ
	$msg = undef;
    }
    elsif ($msg->command eq 'JOIN') {
	$this->_JOIN($msg);
    }
    elsif ($msg->command eq 'KICK') {
	$this->_KICK($msg);
    }
    elsif ($msg->command eq 'MODE') {
	$this->_MODE($msg);
    }
    elsif ($msg->command eq 'NJOIN') {
	$this->_NJOIN($msg);
    }
    elsif ($msg->command eq 'PART') {
	$this->_PART($msg);
    }
    elsif ($msg->command eq 'QUIT' || $msg->command eq 'KILL') {
	# QUITKILLƱ褦˰
	$this->_QUIT($msg);
    }
    elsif ($msg->command eq 'TOPIC') {
	$this->_TOPIC($msg);
    }
    elsif ($msg->command eq '311') {
	$this->_RPL_WHOISUSER($msg);
    }
    elsif ($msg->command eq '312') {
	$this->_RPL_WHOISSERVER($msg);
    }
    elsif ($msg->command eq '324') {
	$this->_RPL_CHANNELMODEIS($msg);
    }
    elsif ($msg->command eq '331') {
	$this->_RPL_NOTOPIC($msg);
    }
    elsif ($msg->command eq '332') {
	$this->_RPL_TOPIC($msg);
    }
    elsif ($msg->command eq '346') {
	$this->_RPL_INVITELIST($msg);
    }
    elsif ($msg->command eq '347') {
	$this->_RPL_ENDOFINVITELIST($msg);
    }
    elsif ($msg->command eq '348') {
	$this->_RPL_EXCEPTLIST($msg);
    }
    elsif ($msg->command eq '349') {
	$this->_RPL_ENDOFEXCEPTLIST($msg);
    }
    elsif ($msg->command eq '352') {
	$this->_RPL_WHOREPLY($msg);
    }
    elsif ($msg->command eq '353') {
	$this->_RPL_NAMREPLY($msg);
    }
    elsif ($msg->command eq '366') {
	$this->_RPL_ENDOFNAMES($msg);
    }
    elsif ($msg->command eq '367') {
	$this->_RPL_BANLIST($msg);
    }
    elsif ($msg->command eq '368') {
	$this->_RPL_ENDOFBANLIST($msg);
    }
    return $msg;
}

sub _KICK {
    my ($this,$msg) = @_;
    my @ch_names = split(/,/,$msg->param(0));
    my @nicks = split(/,/,$msg->param(1));
    my $kick = sub {
	my ($ch,$nick_to_kick) = @_;
	if ($nick_to_kick eq $this->{current_nick}) {
	    # KICK줿Τʬä
	    $ch->remarks('kicked-out','1');
	}
	else {
	    $ch->names($nick_to_kick,undef,'delete');
	}
    };
    if (@ch_names == @nicks) {
	# ͥ̾nick11б
	map {
	    my ($ch_name,$nick) = ($ch_names[$_],$nicks[$_]);
	    my $ch = $this->{channels}->{$ch_name};
	    if (defined $ch) {
		#$ch->names($nick,undef,'delete');
		$kick->($ch,$nick);
	    }
	} 0 .. $#ch_names;
    }
    elsif (@ch_names == 1) {
	# ĤΥͥ뤫1Ͱʾkick
	my $ch = $this->{channels}->{$ch_names[0]};
	if (defined $ch) {
	    map {
		#$ch->names($_,undef,'delete');
		$kick->($ch,$_);
	    } @nicks;
	}
    }
}

sub _MODE {
    my ($this,$msg) = @_;
    if ($msg->param(0) eq $this->{current_nick}) {
	# MODEоݤʬʤΤǤǤ̵롣
	return;
    }

    my $ch = $this->{channels}->{$msg->param(0)};
    if (defined $ch) {
	my $n_params = @{$msg->params};
	
	my $plus = 0; # ɾΥ⡼ɤ+ʤΤ-ʤΤ
	my $mode_char_pos = 1; # ɾmode characterΰ֡
	my $mode_param_offset = 0; # $mode_char_posĤɲåѥ᥿򽦤ä

	my $fetch_param = sub {
	    $mode_param_offset++;
	    return $msg->param($mode_char_pos + $mode_param_offset);
	};
	
	for (;$mode_char_pos < $n_params;$mode_char_pos += $mode_param_offset + 1) {
	    $mode_param_offset = 0; # ꥻåȤ롣
	    foreach my $c (split //,$msg->param($mode_char_pos)) {
		my $add_or_delete = ($plus ? 'add' : 'delete');
		my $undef_or_delete = ($plus ? undef : 'delete');
		if ($c eq '+') {
		    $plus = 1;
		}
		elsif ($c eq '-') {
		    $plus = 0;
		}
		elsif (index('aimnpqrst',$c) != -1) {
		    $ch->switches($c,1,$undef_or_delete);
		}
		elsif ($c eq 'b') {
		    $ch->banlist($add_or_delete,&$fetch_param);
		}
		elsif ($c eq 'e') {
		    $ch->exceptionlist($add_or_delete,&$fetch_param);
		}
		elsif ($c eq 'I') {
		    $ch->invitelist($add_or_delete,&$fetch_param);
		}
		elsif ($c eq 'k') {
		    $ch->parameters('k',&$fetch_param,$undef_or_delete);
		}
		elsif ($c eq 'l') {
		    $ch->parameters('l',($plus ? &$fetch_param : undef),$undef_or_delete);
		}
		elsif ($c eq 'o' || $c eq 'O') {
		    # oOƱ
		    eval {
			$ch->names(&$fetch_param)->has_o($plus);
		    };
		}
		elsif ($c eq 'v') {
		    eval {
			$ch->names(&$fetch_param)->has_v($plus);
		    };
		}
	    }
	}
    }
}

sub _JOIN {
    my ($this,$msg) = @_;
    
    map {
	m/^([^\x07]+)(?:\x07(.*))?/;
	my ($ch_name,$mode) = ($1,(defined $2 ? $2 : ''));
	
	my $ch = $this->{channels}->{$ch_name};
	if (defined $ch) {
	    # ΤäƤͥ롣⤷kickedե饰ΩäƤ饯ꥢ
	    $ch->remarks('kicked-out',undef,'delete');
	}
	else {
	    # Τʤͥ롣
	    $ch = $this->{channels}->{$ch_name} = ChannelInfo->new($ch_name,$this->{network_name});
	}
	$ch->names($msg->nick,
		   new PersonInChannel(
		       $this->person($msg->nick,$msg->name,$msg->host),
		       index($mode,"o") != -1 || index($mode,"O") != -1, # oO⺣Ʊ
		       index($mode,"v") != -1));
    } split(/,/,$msg->param(0));
}

sub _NJOIN {
    my ($this,$msg) = @_;
    my $ch_name = $msg->param(0);
    my $ch = $this->{channels}->{$ch_name};
    unless (defined $ch) {
		# Τʤͥ롣
	$ch = $this->{channels}->{$ch_name} = ChannelInfo->new($ch_name,$this->{network_name});
    }
    map {
	m/^([@+]*)(.+)$/;
	my ($mode,$nick) = ($1,$2);
	
	$ch->names($nick,
		   new PersonInChannel(
		       $this->person($nick),
		       index($mode,"@") != -1, # @@@Ʊ롣
			       index($mode,"+") != -1));
    } split(/,/,$msg->param(1));
}

sub _PART {
    my ($this,$msg) = @_;
    map {
	my $ch_name = $_;
	my $ch = $this->{channels}->{$ch_name};
	if (defined $ch) {
	    if ($msg->nick eq $this->{current_nick}) {
		# PARTΤʬä
		delete $this->{channels}->{$ch_name};
	    }
	    else {
		$ch->names($msg->nick,undef,'delete');
	    }
	}
	
	
    } split(/,/,$msg->param(0));

    # ͥnickĿʪͤʤʤĤƤ𤿤peopleä
    my $alive;
    foreach my $ch (values %{$this->{channels}}) {
	if (defined $ch->names($msg->nick)) {
	    $alive = 1;
	}
    }
    if (!$alive) {
	delete $this->{people}{$msg->nick};
    }
}

sub _NICK {
    my ($this,$msg) = @_;
    # PersonalInfoChannelInfonickäƤΤǽ񤭴롣
    my ($old,$new) = ($msg->nick,$msg->param(0));

    if (!defined $this->{people}->{$old}) {
	return;
    }

    $this->{people}->{$old}->nick($new);
    $this->{people}->{$new} = $this->{people}->{$old};
    delete $this->{people}->{$old};

    my @channels = grep {
	defined $_->names($old);
    } values %{$this->{channels}};

    # NICKƶڤܤͥ̾ΥꥹȤ
    # "affected-channels"Ȥդ롣
    my @affected = map {
	my $ch = $_;
	$ch->names($new,$ch->names($old));
	$ch->names($old,undef,'delete');
	$ch->name;
    } @channels;
    $msg->remark('affected-channels',\@affected);
}

sub _QUIT {
    my ($this,$msg) = @_;
    # peopleڤchannels롣
    delete $this->{people}->{$msg->nick};

    my @channels = grep {
	defined $_->names($msg->nick);
    } values %{$this->{channels}};

    # NICKƶڤܤͥ̾ΥꥹȤ
    # "affected-channels"Ȥդ롣
    my @affected = map {
	my $ch = $_;
	$ch->names($msg->nick,undef,'delete');
	$ch->name;
    } @channels;
    $msg->remark('affected-channels',\@affected);
}

sub _TOPIC {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(0)};
    if (defined $ch) {
	# Ťȥԥå"old-topic"Ȥդ롣
	$msg->remark('old-topic', $ch->topic);
	$ch->topic($msg->param(1));
    }
}

sub _RPL_NAMREPLY {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(2)};
    return unless defined $ch;

    my $receiving_namreply = $this->{receiving_namreply}->{$msg->param(2)};
    unless (defined $receiving_namreply &&
	    $receiving_namreply == 1) {
	# NAMES
	$ch->names(undef,undef,'clear');
	# NAMREPLYե饰ΩƤ
	$this->{receiving_namreply}->{$msg->param(2)} = 1;
    }
    
    if (defined $ch) {
	# @ʤ+s,*ʤ+p=ʤ餽ΤɤǤʤꤷƤ롣
	my $ch_property = $msg->param(1);
	if ($ch_property eq '@') {
	    $ch->switches('s',1);
	    $ch->switches('p',undef,'delete');	   
	}
	elsif ($ch_property eq '*') {
	    $ch->switches('s',undef,'delete');
	    $ch->switches('p',1);
	}
	else {
	    $ch->switches('s',undef,'delete');
	    $ch->switches('p',undef,'delete');
	}
	
	my @people = map {
	    m/^([@\+]{0,2})(.+)$/;
	    my ($mode,$nick) = ($1,$2);
	    
	    $ch->names($nick,
		       new PersonInChannel(
			   $this->person($nick),
			   index($mode,"@") != -1,
			   index($mode,"+") != -1));
	} split(/ /,$msg->param(3));
    }
}

sub _RPL_ENDOFNAMES {
    my ($this,$msg) = @_;
    delete $this->{receiving_namreply}->{$msg->param(1)};
}

sub _RPL_WHOISUSER {
    my ($this,$msg) = @_;
    my $p = $this->{people}->{$msg->param(1)};
    if (defined $p) {
	$p->username($msg->param(2));
	$p->userhost($msg->param(3));
	$p->realname($msg->param(5));
    }
}

sub _RPL_WHOISSERVER {
    my ($this,$msg) = @_;
    my $p = $this->{people}->{$msg->param(1)};
    if (defined $p) {
	$p->server($msg->param(2));
    }
}

sub _RPL_NOTOPIC {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(1)};
    if (defined $ch) {
	$ch->topic('');
    }
}

sub _RPL_TOPIC {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(1)};
    if (defined $ch) {
	$ch->topic($msg->param(2));
    }
}

sub _RPL_INVITELIST {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(1)};
    
    my $receiving_invitelist = $this->{receiving_invitelist}->{$msg->param(1)};
    if (defined $receiving_invitelist &&
	$receiving_invitelist == 1) {
	# +IꥹȤ
	$ch->invitelist(undef,undef,'clear');
	# INVITELISTե饰ΩƤ
	$this->{receiving_invitelist}->{$msg->param(1)} = 1;
    }
    
    if (defined $ch) {
	# ʣɻߤΤᡢödeleteƤadd
	$ch->invitelist('delete',$msg->param(2));
	$ch->invitelist('add',$msg->param(2));
    }
}

sub _RPL_ENDOFINVITELIST {
    my ($this,$msg) = @_;
    delete $this->{receiving_invitelist}->{$msg->param(1)};
}

sub _RPL_EXCEPTLIST {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(1)};

    my $receiving_exceptlist = $this->{receiving_exceptlist}->{$msg->param(1)};
    if (defined $receiving_exceptlist &&
	$receiving_exceptlist == 1) {
	# +eꥹȤ
	$ch->exceptionlist(undef,undef,'clear');
	# EXCEPTLISTե饰ΩƤ
	$this->{receiving_exceptlist}->{$msg->param(1)} = 1;
    }
    
    if (defined $ch) {
	# ʣɻߤΤᡢödeleteƤadd
	$ch->exceptionlist('delete',$msg->param(2));
	$ch->exceptionlist('add',$msg->param(2));
    }
}

sub _RPL_ENDOFEXCEPTLIST {
    my ($this,$msg) = @_;
    delete $this->{receiving_exceptlist}->{$msg->param(1)};
}

sub _RPL_BANLIST {
    my ($this,$msg) = @_;
    my $ch = $this->{channels}->{$msg->param(1)};

    my $receiving_banlist = $this->{receiving_banlist}->{$msg->param(1)};
    if (defined $receiving_banlist &&
	$receiving_banlist == 1) {
	# +bꥹȤ
	$ch->banlist(undef,undef,'clear');
	# BANLISTե饰ΩƤ
	$this->{receiving_banlist}->{$msg->param(1)} = 1;
    }
    
    if (defined $ch) {
	# ʣɻߤΤᡢödeleteƤadd
	$ch->banlist('delete',$msg->param(2));
	$ch->banlist('add',$msg->param(2));
    }
}

sub _RPL_ENDOFBANLIST {
    my ($this,$msg) = @_;
    delete $this->{receiving_banlist}->{$msg->param(1)};
}

sub _RPL_WHOREPLY {
    my ($this,$msg) = @_;
    my $p = $this->{people}->{$msg->param(5)};
    if (defined $p) {
	$p->username($msg->param(2));
	$p->userhost($msg->param(3));
	$p->server($msg->param(5));
	$p->realname((split / /,$msg->param(7))[1]);
    }

    #use Data::Dumper;
    #open(LOG,"> log.txt");
    #print LOG "------- people --------\n";
    #print LOG Dumper($this->{people}),"\n";
    #print LOG "------- channels --------\n";
    #print LOG Dumper($this->{channels}),"\n";
    #close(LOG);
}

sub _RPL_CHANNELMODEIS {
    my ($this,$msg) = @_;
    # ΤΥͥʤ顢Υͥ
    # switches-are-known => 1Ȥͤդ롣
    my $ch = $this->{channels}->{$msg->param(1)};
    if (defined $ch) {
	$ch->remarks('switches-are-known',1);
    }
    
    # MODE¹ԤȤˤơ_MODE˽Ԥ롣
    my @args = @{$msg->params};
    @args = @args[1 .. $#args];
    
    $this->_MODE(
	new IRCMessage(Prefix => $msg->prefix,
		       Command => 'MODE',
		       Params => \@args));
}

sub _set_to_next_nick {
    my ($this,$failed_nick) = @_;
    # failed_nickμnickޤnickʣǥ˼Ԥ˻Ȥޤ
    my $next_nick = modify_nick($failed_nick);
    
    my $msg_for_user = "Nick $failed_nick was already in use in the ".$this->network_name.". Trying ".$next_nick."...";
    $this->send_message(
	new IRCMessage(
	    Command => 'NICK',
	    Param => $next_nick));
    RunLoop->shared_loop->broadcast_to_clients(
	new IRCMessage(
	    Command => 'NOTICE',
	    Params => [RunLoop->shared_loop->current_nick,$msg_for_user]));
    main::printmsg($msg_for_user);
}

sub modify_nick {
    my $nick = shift;
    if ($nick =~ /(\d+)$/) {
	# Ǹοʸä顢򥤥󥯥
	my $base = $`;
	my $next_num = $1 + 1;
	if (length($base . $next_num) <= 9) {
	    # 9ʸ˼ޤΤǤǻ
	    $nick = $base . $next_num;
	}
	else {
	    # ޤʤΤ9ʸ˽̤롣
	    $nick = substr($base,0,9 - length($next_num)) . $next_num;
	}
    }
    elsif ($nick =~ /_$/ && length($nick) == 9) {
	# Ǹʸ_ǡʾ_դʤ硢0ˡ
	$nick =~ s/_$/0/;
    }
    else {
	# Ǹ_դ롣
	if (length($nick) == 9) {
	    $nick =~ s/.$/_/;
	}
	else {
	    $nick .= '_';
	}
    }
    return $nick;
}

1;
