# -----------------------------------------------------------------------------
# $Id: Client.pm,v 1.19 2003/08/12 01:45:34 admin Exp $
# -----------------------------------------------------------------------------
# IrcIO::Clientϥ饤Ȥ³
# IRCåꤹ륯饹Ǥ
# -----------------------------------------------------------------------------
package IrcIO::Client;
use strict;
use warnings;
use Carp;
use base qw(IrcIO);
use Net::hostent;
use Crypt;
use Configuration;
use Multicast;
use Mask;

use SelfLoader;
SelfLoader->load_stubs; # Υ饹ˤϿƥ饹뤫顣(SelfLoaderpod򻲾)
1;
__DATA__

sub new {
    my ($class,$sock) = @_;
    my $obj = $class->SUPER::new;
    $obj->{sock} = $sock;
    $obj->{connected} = 1;
    $obj->{client_host} = do {
	my $hostent = Net::hostent::gethost($sock->peerhost); # հ
	defined $hostent ? $hostent->name : $sock->peerhost;
    };
    $obj->{pass_received} = ''; # 饤Ȥäѥ
    $obj->{nick} = ''; # ˥饤Ȥänickѹʤ
    $obj->{username} = ''; # Ʊusername
    $obj->{logging_in} = 1; # ʤ1
    $obj->{options} = {}; # 饤Ȥ³$key=value$ǻꤷץ

    # ΥۥȤ³ϵĤƤ뤫
    my $allowed_host = Configuration->shared_conf->general->client_allowed;
    if (defined $allowed_host) {
	unless (Mask::match($allowed_host,$obj->{client_host})) {
	    # ޥåʤΤdie
	    die "One client at ".$obj->{client_host}." connected to me, but the host is not allowed.\n";
	}
    }
    ::printmsg("One client at ".$obj->{client_host}." connected to me.");
    $obj;
}

sub logging_in {
    shift->{logging_in};
}

sub fullname {
    # Υ饤Ȥtiarra鸫nick!username@userhostηɽ롣
    my ($this,$type) = @_;
    if (defined $type && $type eq 'error') {
	RunLoop->shared_loop->current_nick.'['.$this->{username}.'@'.$this->{client_host}.']';
    }
    else {
	RunLoop->shared_loop->current_nick.'!'.$this->{username}.'@'.$this->{client_host};
    }
}

sub fullname_from_client {
    # Υ饤Ȥ򥯥饤Ȥ鸫nick!username@userhostηɽ롣
    # δؿ֤nickϽ˼äΤǤա
    my $this = shift;
    $this->{nick}.'!'.$this->{username}.'@'.$this->{client_host};
}

sub parse_realname {
    my ($this,$realname) = @_;
    return if !defined $realname;
    # $key=value;key=value;...$
    #
    # ʲͭǡƱ̣Ǥ롣
    # $ foo = bar; key=  value$
    # $ foo=bar;key=value $
    # $foo    =bar;key=  value    $

    my $key = qr{[^=]+?}; # ȤƵѥ
    my $value = qr{[^;]*?}; # ͤȤƵѥ
    my $lastpair = qr{$key\s*=\s*$value};
    my $pair = qr{$lastpair\s*;};

    my $line = qr{^\$(?:\s*($pair)\s*)*\s*($lastpair)\s*\$$};
    if (my @pairs = ($realname =~ m/$line/g)) {
        %{$this->{options}} = map {
	    m/^\s*($key)\s*=\s*($value)\s*;?$/;
	} grep {
	    defined;
	} @pairs;
    }
}

sub option {
    # $key=value$ǻꤵ줿ץ롣
    # ꤵ줿Фͤ¸ߤʤäundef֤
    my ($this,$key) = @_;
    if (defined $key) {
	$this->{options}->{$key};
    }
    else {
	croak "IrcIO::Client->option, Arg[1] was undef.";
    }
}

sub send_message {
    my ($this,$msg) = @_;

    # ƥ⥸塼
    RunLoop->shared->notify_modules('notification_of_message_io',$msg,$this,'out');

    $this->SUPER::send_message(
	$msg,
	$this->option('encoding') || Configuration->shared->general->client_out_encoding);
}

sub receive {
    my ($this) = shift;
    $this->SUPER::receive(
	$this->option('encoding') || Configuration->shared->general->client_in_encoding);

    # ³ڤ줿顢ƥ⥸塼
    if (!$this->connected) {
	RunLoop->shared->notify_modules('client_detached',$this);
    }
}

sub pop_queue {
    my $this = shift;
    my $msg = $this->SUPER::pop_queue;
    
    # 饤Ȥʤ顢դ롣
    if (defined $msg) {
	# ƥ⥸塼
	RunLoop->shared->notify_modules('notification_of_message_io',$msg,$this,'in');
	
	# 椫
	if ($this->{logging_in}) {
	    return $this->_receive_while_logging_in($msg);
	}
	else {
	    return $this->_receive_after_logged_in($msg);
	}
    }
    return $msg;
}

sub _receive_while_logging_in {
    my ($this,$msg) = @_;
    
    # NICKڤUSERäǤΥǧȤλ롣
    my $command = $msg->command;
    if ($command eq 'PASS') {
	$this->{pass_received} = $msg->params->[0];
    }
    elsif ($command eq 'NICK') {
	$this->{nick} = $msg->params->[0];
    }
    elsif ($command eq 'USER') {
	$this->{username} = $msg->param(0);
	$this->parse_realname($msg->param(3));
    }
    elsif ($command eq 'PING') {
	$this->send_message(
	    new IRCMessage(
		Command => 'PONG',
		Param => $msg->param(0)));
    }
    elsif ($command eq 'QUIT') {
	$this->send_message(
	    IRCMessage->new(
		Command => 'ERROR',
		Param => 'Closing Link: ['.$this->fullname_from_client.'] ()'));
	$this->disconnect_after_writing;
    }
    
    if ($this->{nick} ne '' && $this->{username} ne '') {
	# general/tiarra-password
	my $valid_password = Configuration->shared_conf->general->tiarra_password;
	if (defined $valid_password && $valid_password ne '' &&
	    ! Crypt::check($this->{pass_received},$valid_password)) {
	    # ѥɤʤ
	    ::printmsg("Refused login of ".$this->fullname_from_client." because of bad password.");
	    
	    $this->send_message(
		new IRCMessage(Prefix => 'tiarra',
			       Command => '464',
			       Params => [$this->{nick},'Password incorrect']));
	    $this->send_message(
		new IRCMessage(Command => 'ERROR',
			       Param => 'Closing Link: ['.$this->fullname_from_client.'] (Bad Password)'));
		$this->disconnect_after_writing;
	}
	else {
	    # ѥɤꤵƤʤ
	    ::printmsg('Accepted login of '.$this->fullname_from_client.'.');
	    if ((my $n_options = keys %{$this->{options}}) > 0) {
		# ץ󤬻ꤵƤɽ롣
		my $options = join ' ; ',map {
		    "$_ = $this->{options}->{$_}";
		} keys %{$this->{options}};
		::printmsg('Given option'.($n_options == 1 ? '' : 's').': '.$options);
	    }
	    $this->{logging_in} = 0;

	    $this->send_message(
		new IRCMessage(Prefix => 'tiarra',
			       Command => '001',
			       Params => [$this->{nick},'Welcome to the Internet Relay Network '.$this->fullname_from_client]));

	    my $current_nick = RunLoop->shared_loop->current_nick;
	    if ($this->{nick} ne $current_nick) {
		# 饤ȤäƤnickȥnickäƤΤnick򶵤롣
		$this->send_message(
		    new IRCMessage(Prefix => $this->fullname_from_client,
				   Command => 'NICK',
				   Param => $current_nick));
	    }

	    map {
		# nickȥХnickäƤ餽λݤ롣
		my $network_name = $_->network_name;
		my $global_nick = $_->current_nick;
		if ($global_nick ne $current_nick) {
		    $this->send_message(
			new IRCMessage(Prefix => 'tiarra',
				       Command => 'NOTICE',
				       Params => [$current_nick,
						  "*** Your global nick in $network_name is currently '$global_nick'."]));					     
		}
	    } values %{RunLoop->shared_loop->networks};
	    
	    foreach my $line (main::get_credit()) {
		$this->send_message(
		    new IRCMessage(Prefix => 'tiarra',
				   Command => '002',
				   Params => [$current_nick,$line]));
	    }
	    
	    # joinƤƤΥͥξ򥯥饤롣
	    $this->inform_joinning_channels;
	    
	    # ƥ⥸塼˥饤ɲäΤФ
	    RunLoop->shared->notify_modules('client_attached',$this);
	}
    }
    # ˥饤Ȥäʤå⥵Сˤʤ
    return undef;
}

sub _receive_after_logged_in {
    my ($this,$msg) = @_;
    
    # Ǥʤ
    my $command = $msg->command;
    
    if ($command eq 'NICK') {
	# ¤NICKˤϾơRunLoopΥnickѹˤʤ롣
	# ͥåȥ̾ƤϥȤѹʤ
	my ($nick,undef,$specified) = Multicast::detatch($msg->params->[0]);
	if (Multicast::nick_p($nick)) {
	    unless ($specified) {
		#$this->send_message(
		#    new IRCMessage(
		#	Prefix => $this->fullname,
		#	Command => 'NICK',
		#	Param => $msg->params->[0]));
		RunLoop->shared->broadcast_to_clients(
		    IRCMessage->new(
			Command => 'NICK',
			Param => $msg->param(0),
			Remarks => {'fill-prefix-when-sending-to-client' => 1}));

		RunLoop->shared_loop->set_current_nick($msg->params->[0]);
	    }
	}
	else {
	    $this->send_message(
		new IRCMessage(
		    Prefix => 'tiarra',
		    Command => '432',
		    Params => [RunLoop->shared_loop->current_nick,
			       $msg->params->[0],
			       'Erroneous nickname']));
	    # ϻʤ
	    $msg = undef;
	}
    }
    elsif ($command eq 'QUIT') {
	my $quit_message = $msg->param(0);
	$quit_message = '' unless defined $quit_message;
	
	$this->send_message(
	    new IRCMessage(Command => 'ERROR',
			   Param => 'Closing Link: '.$this->fullname('error').' ('.$quit_message.')'));
	$this->disconnect_after_writing;
	
	# ³ڤ줿ˤ롣
	RunLoop->shared->notify_modules('client_detached',$this);
	
	# ϻʤ
	$msg = undef;
    }
    return $msg;
}

sub inform_joinning_channels {
    my $this = shift;
    my $multi = RunLoop->shared->multi_server_mode_p;
    my $local_nick = RunLoop->shared_loop->current_nick;
    map {
	my $network = $_;
	my $global_nick = $network->current_nick;
	my $global_to_local = sub {
	    $_[0] eq $global_nick ? $local_nick : $_[0];
	};
	
	map {
	    my $ch = $_;
	    my $ch_name = do {
		if ($multi) {
		    Multicast::attach($ch->name, $network->network_name);
		}
		else {
		    $ch->name;
		}
	    };
	    
	    # ޤJOIN
	    $this->send_message(
		IRCMessage->new(
		    Prefix => $this->fullname,
		    Command => 'JOIN',
		    Param => $ch_name));
	    # RPL_TOPIC()
	    if ($ch->topic ne '') {
		$this->send_message(
		    IRCMessage->new(
			Prefix => $this->fullname,
			Command => '332',
			Params => [$local_nick,$ch_name,$ch->topic]));
	    }
	    # RPL_NAMREPLY
	    my $ch_property_char = do {
		if ($ch->switches('s')) {
		    '@';
		}
		elsif ($ch->switches('p')) {
		    '*';
		}
		else {
		    '=';
		}
	    };
	    # ;͵򸫤nick400ХȤۤԤʬ롣
	    my $nick_enumeration = '';
	    my $flush_enum_buffer = sub {
		if ($nick_enumeration ne '') {
		    $this->send_message(
		        IRCMessage->new(
			    Prefix => $this->fullname,
			    Command => '353',
			    Params => [$local_nick,
				       $ch_property_char,
				       $ch_name,
				       $nick_enumeration]));
		    $nick_enumeration = '';
		}
	    };
	    my $append_to_enum_buffer = sub {
		my $nick_to_append = shift;
		if ($nick_enumeration eq '') {
		    $nick_enumeration = $nick_to_append;
		}
		else {
		    $nick_enumeration .= ' '.$nick_to_append;
		}
	    };
	    map {
		my $person = $_;
		my $mode_char = do {
		    if ($person->has_o) {
			'@';
		    }
		    elsif ($person->has_v) {
			'+';
		    }
		    else {
			'';
		    }
		};
		$append_to_enum_buffer->($mode_char . $global_to_local->($person->person->nick));
		if (length($nick_enumeration) > 400) {
		    $flush_enum_buffer->();
		}
	    } values %{$ch->names};
	    $flush_enum_buffer->();
	    # ǸRPL_ENDOFNAMES
	    $this->send_message(
		IRCMessage->new(
		    Prefix => $this->fullname,
		    Command => '366',
		    Params => [$local_nick,$ch_name,'End of NAMES list']));
	} values %{$network->channels};
    } values %{RunLoop->shared_loop->networks};
}

1;
