# -----------------------------------------------------------------------------
# $Id: IrcIO.pm,v 1.18 2003/06/03 17:49:47 topia Exp $
# -----------------------------------------------------------------------------
# IrcIOIRCСϥ饤Ȥ³IRCåꤹݥ饹Ǥ
# -----------------------------------------------------------------------------
package IrcIO;
use strict;
use warnings;
use Carp;
use IO::Socket::INET;
use Configuration;
use IRCMessage;
use Exception;

sub new {
    my $class = shift;
    my $obj = {
	sock => undef, # IO::Socket::INET
	connected => undef, # ɤ$sock->connectedϿѽʤ
	sendbuf => '',
	recvbuf => '',
	recv_queue => [],
	disconnect_after_writing => 0,
	remarks => {},
    };
    bless $obj,$class;
}

sub server_p {
    shift->isa('IrcIO::Server');
}

sub client_p {
    shift->isa('IrcIO::Client');
}

sub disconnect_after_writing {
    shift->{disconnect_after_writing} = 1;
}

sub disconnect {
    my $this = shift;
    $this->{sock}->shutdown(2);
    $this->{connected} = undef;
}

sub sock {
    $_[0]->{sock};
}

sub connected {
    #defined $_[0]->{sock} && $_[0]->{sock}->connected;
    shift->{connected};
}

sub need_to_send {
    # ٤ǡ1̵undef֤ޤ
    $_[0]->{sendbuf} eq '' ? undef : 1;
}

sub remark {
    my ($this,$key,$newvalue) = @_;
    if (!defined $key) {
	croak "IrcIO->remark, Arg[1] is undef.\n";
    }
    if (defined $newvalue) {
	$this->{remarks}->{$key} = $newvalue;
    }
    $this->{remarks}->{$key};
}

sub send_message {
    my ($this,$msg,$encoding) = @_;
    # ǡ褦ͽ󤹤롣åȤνäƤʤƤ֥åʤ
    
    # msgʸǤɤIRCMessageΥ󥹥󥹤Ǥɤ
    # ʸϤˤϡCRLFդƤϤʤʤ
    # ޤʸˤĤƤʸɤѴԤʤʤ
    my $data_to_send = '';
    if (ref($msg) eq '') {
	$data_to_send = "$msg\x0d\x0a";
    }
    elsif ($msg->isa('IRCMessage')) {
	$data_to_send = $msg->serialize($encoding)."\x0d\x0a";
    }
    else {
	die "IrcIO::send_message : parameter msg was invalid; $msg\n";
    }
    
    if ($this->{sock}) {
	$this->{sendbuf} .= $data_to_send;
    }
    else {
	die "IrcIO::send_message : socket is not connected.\n";
    }
}

sub send {
    my $this = shift;
    # Υ᥽åɤϥåȤΥåޤ
    # νäƤʤäϡΥ᥽åɤ֥åޤ
    # 줬ޤΤʤͽselectǽ񤭹ǧƤƲ
    if (!defined $this->{sock} || !$this->connected || !$this->{sock}->connected) {
	#die "Irc::send : socket is not connected.\n";
	return;
    }

    #my $bytes_sent = $this->{sock}->send($this->{sendbuf}) || 0;
    my $bytes_sent = $this->{sock}->syswrite($this->{sendbuf}) || 0;
    $this->{sendbuf} = substr($this->{sendbuf},$bytes_sent);

    if ($this->{disconnect_after_writing} &&
	$this->{sendbuf} eq '') {
	$this->disconnect;
    }
}

sub receive {
    my ($this,$encoding) = @_;
    # Υ᥽åɤIRCåԤļꡢIRCMessageΥ󥹥󥹤򥭥塼ίޤ
    # åȤɤǡƤʤä硢Υ᥽åɤɤ褦ˤʤޤ
    # ֥åޤ줬ޤͽselectɤǧƤƲ
    # Υ᥽åɤ¹ԤȤǻϤƥåȤĤ줿ʬäϡ
    # ᥽åɼ¹Ը夫connected᥽åɤ֤褦ˤʤޤ
    if (!defined($this->{sock}) || !$this->connected) {
	# die "IrcIO::receive : socket is not connected.\n";
	$this->disconnect;
	return ();
    }
    
    my $recvbuf = '';
    sysread($this->{sock},$recvbuf,4096); # Ȥꤢ4096ХȤɤ
    if ($recvbuf eq '') {
	# åȤĤƤ
	$this->disconnect;
    }
    else {
	$this->{recvbuf} .= $recvbuf;
    }
    
    while (1) {
	# CRLFԤνꡣ	
	my $crlf_pos = index($this->{recvbuf},"\x0d\x0a");
	if ($crlf_pos == -1) {
	    # ʬΥǡϤƤʤ
	    last;
	}

	my $current_line = substr($this->{recvbuf},0,$crlf_pos);
	$this->{recvbuf} = substr($this->{recvbuf},$crlf_pos+2);

	push @{$this->{recv_queue}},IRCMessage->new(Line => $current_line,
						    Encoding => $encoding);
    }
}

sub pop_queue {
    # Υ᥽åɤϼ塼κǤŤΤФޤ
    # 塼ʤQueueIsEmptyExceptionꤲޤ
    my ($this) = @_;
    if (@{$this->{recv_queue}} == 0) {
	QueueIsEmptyException->new->throw;
    }
    else {
	return splice @{$this->{recv_queue}},0,1;
    }
}

1;
