# -----------------------------------------------------------------------------
# $Id: InstantCapsule.pm,v 1.3 2003/07/23 07:25:30 admin Exp $
# -----------------------------------------------------------------------------
# եɤȥ᥽åɤĥ֥ȤŪ뤿Υ饹
# ˥᥽åɤμΤ򥯥Ϥޤ
# AUTOLOADtieѤƤ뤿ᡢư®٤̾Υ饹٤ǽޤ
#
# my $capsule = InstantCapsule->new(
#    Fields => {
#       # Ǥϥϥå巿֥ȤΤб
#       # 󷿤䥰ַΥ֥ȤбǤ
#	foo => 10,
#	bar => undef,
#	baz => 'string',
#    },
#    Methods => {
#	# ᥽å̾newInstantCapsuleͽ󤷤Ƥ롣
#
#	printfoo => sub {
#	    # ᥽åɤϤǽΰInstantCapsuleȡ
#	    my $this = shift;
#	    print $this->{foo},"\n";
#	},
#
#	setbar => sub {
#	    # ܰʹߤΰϡΥ᥽åɸƤӽФѤ줿ΤΤޤϤ롣
#	    my ($this,$value) = @_;
#	    $this->{bar} = $value;
#	}
#
#	DESTROY => sub {
#	    print "DESTROY called.\n";
#	}
#    });
#
# $capsule->printfoo;
# $capsule->setbar(5);
# undef $capsule; # DESTROYƤФ롣
# -----------------------------------------------------------------------------
package InstantCapsule;
use strict;
use warnings;
use Carp;
use UNIVERSAL;
use vars qw($AUTOLOAD);

sub new {
    my ($class,%args) = @_;
    my $this = {
	fields => $args{Fields},
	methods => $args{Methods},
    };

    if (!defined $this->{fields}) {
	croak "InstantCapsule->new, Arg[Fields] not defined.\n";
    }
    elsif (!ref($this->{fields}) || !UNIVERSAL::isa($this->{fields},'HASH')) {
	croak "InstantCapsule->new, Arg[Fields] is bad type.\n";
    }

    if (!defined $this->{methods}) {
	croak "InstantCapsule->new, Arg[Methods] not defined.\n";
    }
    elsif (!ref($this->{methods}) || !UNIVERSAL::isa($this->{methods},'HASH')) {
	croak "InstantCapsule->new, Arg[Methods] is bad type.\n";
    }

    # methodså
    while (my ($name,$code) = each %{$this->{methods}}) {
	if (eval qq{defined \&${class}::${name}}) {
	    croak "InstantCapsule->new, method $name is reserved for InstantCapsule itself.\n";
	}
	if (!ref($code) || ref($code) ne 'CODE') {
	    croak "InstantCapsule->new, method $name is not a valid CODE value.\n";
	}
    }

    my $obj = {};
    tie %$obj,$class,$this; # ƤʤȥեɤȽʤ
    bless $obj,$class; # ƤʤAUTOLOADȤʤ
}

sub TIEHASH {
    my ($class,$tie) = @_;
    bless $tie,$class;
}

sub FETCH {
    my ($this,$key) = @_;
    $this->{fields}->{$key};
}

sub STORE {
    my ($this,$key,$value) = @_;
    $this->{fields}->{$key} = $value;
}

sub DELETE {
    my ($this,$key) = @_;
    delete $this->{fields}->{$key};
}

sub EXISTS {
    my ($this,$key) = @_;
    exists $this->{fields}->{$key};
}

sub CLEAR {
    my $this = shift;
    %{$this->{fields}} = ();
}

sub FIRSTKEY {
    my $this = shift;
    values %{$this->{fields}}; # reset iterator
    each %{$this->{fields}};
}

sub NEXTKEY {
    my $this = shift;
    each %{$this->{fields}};
}

sub AUTOLOAD {
    my ($obj,@args) = @_;
    my $this = tied %$obj;
    (my $method = $AUTOLOAD) =~ s/.+?:://g;

    if (defined $this->{methods}->{$method}) {
	$this->{methods}->{$method}->($obj,@args);
    }
    else {
	# DESTROY̵Ƥ⹽ʤ
	if ($method ne 'DESTROY') {
	    croak "InstantCapsule->AUTOLOAD, method $method is not defined.\n";
	}
    }
}

1;
