# -----------------------------------------------------------------------------
# $Id: IRCMessage.pm,v 1.12 2003/05/15 12:11:12 admin Exp $
# -----------------------------------------------------------------------------
# IRCMessageIRCΥåɽ魯饹ǤºݤΥåUTF-8ݻޤ
# ΥåΥѡꥢ饤ƥå򥵥ݡȤޤ
# ѡȥꥢ饤ˤʸɤꤷƲɤѴޤ
# LineEncodingʳμʤǥ󥹥󥹤ݤϡ
# ѥ᡼ȤUTF-8ͤϤƲ
# -----------------------------------------------------------------------------
# ˡ
#
# $msg = new IRCMessage(Line => ':foo!~foo@hogehoge.net PRIVMSG #hoge :hoge',
#                       Encoding => 'jis');
# print $msg->command; # 'PRIVMSG'ɽ
#
# $msg = new IRCMessage(Server => 'irc.hogehoge.net', # ServerPrefixǤɤ
#                       Command => '366',
#                       Params => ['hoge','#hoge','End of /NAMES list.']);
# print $msg->serialize('jis'); # ":irc.hogehoge.net 366 hoge #hoge :End of /NAMES list."ɽ
#
# $msg = new IRCMessage(Nick => 'foo',
#                       User => '~bar',
#                       Host => 'hogehoge.net', # ʾ壳ĤΥѥ᡼Prefix => 'foo!~bar@hogehoge.net'Ǥɤ
#                       Command => 'NICK',
#                       Params => 'huga', # ParamsǤĤʤ饹顼ͤǤɤ(λParamsǤʤParamǤɤ)
#                       Remarks => {'saitama' => 'SAITAMA'}, # 󡣥ꥢ饤ˤϱƶʤ
# print $msg->serialize('jis'); # ":foo!~bar@hogehoge.net NICK :huga"ɽ
#
# $msg = new IRCMessage(Command => 'NOTICE',
#                       Params => ['foo','hugahuga']);
# print $msg->serialize('jis'); # "NOTICE foo :hugahuga"ɽ
#                       
package IRCMessage;
use strict;
use warnings;
use Carp;
use Unicode::Japanese;

sub new {
    my ($class,%args) = @_;
    my $obj = {
	prefix => undef,
	command => undef,
	params => undef,

	nick => undef,
	name => undef,
	host => undef,

	remarks => undef,
    };
    bless $obj,$class;
    
    if (exists $args{'Line'}) {
	$args{'Line'} =~ s/\x0d\x0a$//s; # crlfϾõ
	$obj->_parse($args{'Line'},$args{'Encoding'} || 'auto'); # Encodingά줿鼫ưȽ
    }
    else {
	if (exists $args{'Prefix'}) {
	    $obj->{prefix} = $args{'Prefix'}; # prefixꤵ줿
	}
	elsif (exists $args{'Server'}) {
	    $obj->{prefix} = $args{'Server'}; # prefix
	}
	elsif (exists $args{'Nick'}) {
	    $obj->{prefix} = $args{'Nick'}; # ޤnick뤳Ȥʬä
	    if (exists $args{'User'}) {
		$obj->{prefix} .= '!'.$args{'User'}; # user⤢ä
	    }
	    if (exists $args{'Host'}) {
		$obj->{prefix} .= '@'.$args{'Host'}; # host⤢ä
	    }
	}

	# CommandФ̵Фʤʤ
	if (exists $args{'Command'}) {
	    ($obj->{command} = $args{'Command'}) =~ tr/a-z/A-Z/;
	}
	else {
	    die "You can't make IRCMessage without a COMMAND.\n";
	}
	
	if (exists $args{'Params'}) {
	    # Paramsäϥ顼⤷ե
	    my $params = $args{'Params'};
	    my $type = ref($params);
	    if ($type eq '') {
		$obj->{params} = [$params];
	    }
	    elsif ($type eq 'ARRAY') {
		my @copy_of_params = @{$params};
		$obj->{params} = \@copy_of_params; # ԡǼ
	    }
	}
	elsif (exists $args{'Param'}) {
	    # Paramäϥ顼Τ
	    $obj->{params} = [$args{'Param'}];
	}
    }
    if (exists $args{'Remarks'}) {
	my %copy_of_remarks = %{$args{'Remarks'}};
	$obj->{remarks} = \%copy_of_remarks;
    }
    $obj->_parse_prefix;
    $obj;
}

sub clone {
    my $this = shift;
    my %new = %{$this};
    bless \%new,ref($this);
}

sub _parse {
    my ($this,$line,$encoding) = @_;
    delete $this->{prefix};
    delete $this->{command};
    delete $this->{params};
    
    my $pos = 0;
    # prefix
    if (substr($line,0,1) eq ':') {
	# :ǻϤޤäƤ
	my $pos_space = index($line,' ');
	$this->{prefix} = substr($line,1,$pos_space - 1);
	$pos = $pos_space + 1; # ڡμƳ
    }
    # command & params
    my $unicode = new Unicode::Japanese;
    my $add_command_or_param = sub {
	my $value_raw = shift;
	my $value = $unicode->set($value_raw,$encoding)->utf8;
	
	if ($this->{command}) {
	    # commandϤ⤦Ѥߡϥѥ᡼
	    if ($this->{params}) {
		push @{$this->{params}},$value;
	    }
	    else {
		$this->{params} = [$value];
	    }
	}
	else {
	    # ޤޥɤꤵƤʤ
	    ($this->{command} = $value) =~ tr/a-z/A-Z/;
	}
    };
    while (1) {
	my $param = '';

	my $pos_space = index($line,' ',$pos);
	if ($pos_space == -1) {
	    # λ
	    $param = substr($line,$pos);
	}
	else {
	    $param = substr($line,$pos,$pos_space - $pos);
	}

	if ($param ne '') {
	    if (substr($param,0,1) eq ':') {
		# ʹߤưĤΰ
		$add_command_or_param->(substr($line,$pos+1)); # :ϳ
		last; # ǽꡣ
	    }
	    else {
		$add_command_or_param->($param);
	    }
	}

	if ($pos_space == -1) {
	    last;
	}
	else {
	    $pos = $pos_space + 1; # ڡμƳ
	}
    }

    # ̤å
    # command̵ädie
    unless ($this->{command}) {
	die "IRCMessage parsed unvalid one, which doesn't have command.\n  $line\n";
    }
}

sub _parse_prefix {
    my $this = shift;
    if (defined $this->{prefix}) {
	$this->{prefix} =~ m/^(.+?)!(.+?)@(.+)$/;
	if (!defined($1)) {
	    $this->{nick} = $this->{prefix};
	}
	else {
	    $this->{nick} = $1;
	    $this->{name} = $2;
	    $this->{host} = $3;
	}
    }
}

sub _update_prefix {
    my $this = shift;
    if (defined $this->{nick}) {
	if (defined $this->{name}) {
	    $this->{prefix} =
		$this->{nick}.'!'.$this->{name}.'@'.$this->{host};
	}
	else {
	    $this->{prefix} = $this->{nick};
	}
    }
    else {
	delete $this->{nick};
    }
}

sub serialize {
    # encodingάutf8ˤʤ롣
    my ($this,$encoding) = @_;
    $encoding = 'utf8' unless defined $encoding;
    my $result = '';

    if ($this->{prefix}) {
	$result .= ':'.$this->{prefix}.' ';
    }
    
    $result .= $this->{command}.' ';
    
    if ($this->{params}) {
	my $unicode = new Unicode::Japanese;
	my $n_params = scalar @{$this->{params}};
	for (my $i = 0;$i < $n_params;$i++) {
	    if ($i == $n_params - 1) {
		# ǸΥѥ᥿ʤƬ˥դƸˤϥڡ֤ʤ
		# âȾѥڡĤ̵Хդʤ
		my $arg = $unicode->set($this->{params}->[$i])->conv($encoding);
		$result .= (index($arg,' ') != -1 ? ':' : '').$arg;
		# CTCPå򳰤ƥ󥳡ɤ٤Τʤ
	    }
	    else {
		# ǸΥѥ᥿Ǥʤи˥ڡ֤
		$result .= $unicode->set($this->{params}->[$i])->conv($encoding).' ';
	    }
	}
    }

    return $result;
}

sub prefix {
    my ($this,$new_val) = @_;
    $this->{prefix} = $new_val if defined($new_val);
    $this->{prefix};
}

sub nick {
    my ($this,$new_val) = @_;
    if (defined $new_val) {
	$this->{nick} = $new_val;
	$this->_update_prefix;
    }
    $this->{nick};
}

sub name {
    my ($this,$new_val) = @_;
    if (defined $new_val) {
	$this->{name} = $new_val;
	$this->_update_prefix;
    }
    $this->{name};
}

sub host {
    my ($this,$new_val) = @_;
    if (defined $new_val) {
	$this->{host} = $new_val;
	$this->_update_prefix;
    }
    $this->{host};
}

sub command {
    my ($this,$new_val) = @_;
    $this->{command} = $new_val if defined($new_val);
    $this->{command};
}

sub params {
    croak "Parameter specified to params(). You must mistaked with param().\n" if (@_ > 1);
    $_[0]->{params};
}

sub n_params {
    scalar @{$_[0]->{params}};
}

sub param {
    my ($this,$index,$new_value) = @_;
    croak "Parameter index wasn't specified to param(). You must be mistaken with params().\n" if (@_ <= 1);
    if (defined $new_value) {
	$this->{params}->[$index] = $new_value;
    }
    $this->{params}->[$index];
}

sub remark {
    my ($this,$key,$value) = @_;
    # remark() -> HASH*
    # remark('key') -> SCALAR
    # remark('key','value') -> 'value'
    if (!defined($key)) {
	$this->{remarks} || {};
    }
    else {
	if (defined $value) {
	    if (defined $this->{remarks}) {
		$this->{remarks}->{$key} = $value;
	    }
	    else {
		$this->{remarks} = {$key => $value};
	    }
	}
	defined $this->{remarks} ?
	    $this->{remarks}->{$key} : undef;
    }
}

1;
