# -----------------------------------------------------------------------------
# $Id: LexicalAnalyzer.pm,v 1.1 2003/03/02 15:52:19 admin Exp $
# -----------------------------------------------------------------------------
# confեλϴ
# ʸ̮˱ƥȡϤƤ
# -----------------------------------------------------------------------------
package Configuration::LexicalAnalyzer;
use strict;
use warnings;

sub new {
    # $body: Ϥ
    my ($class,$body) = @_;
    my $this = {
	body => $body, # ȡ󤬲Ϥ٤ˡϤ줿ȡ󤬾äƤ
	linecount => 0, # ߤɤιԤϤƤ뤫ξϥ顼ˤȤʤ
	rollbackcount => 0, # ߲Ԥɤ߲᤮Ƥ뤫
    };
    bless $this;
}

sub linecount {
    shift->{linecount};
}

sub next {
    # Υȡ롣⤦ĤäƤʤundef֤
    # $contenxt: 'outside' | 'block'
    #
    # outside: ֥åγ¦˵򼨤
    # block: ֥å˵򼨤
    #
    # : (ȡ,)
    # פȤƤϼΤ褦ʤΤ롣
    # 'label' => ֥åΥ٥
    # 'blockstart' => ֥åλϤޤ
    # 'blockend' => ֥åν
    # 'pair' => ͤΥڥ
    my ($this,$context) = @_;

    my $method = "_context_$context";
    if ($this->can($method)) {
	my ($token,$type) = eval {
	    $this->$method;
	}; if ($@) {
	    die "Exception in analyzing token: line $this->{linecount}\n$@\n";
	}
	($token,$type);
    }
    else {
	die "Illegal context: $context\n";
    }
}

sub _context_outside {
    my $this = shift;

    my $labelchar = qr{[^\s{}]}; # ֥å̾ȤƵʸ
    my $label = qr{^(?:(?:\+|\-)\s+)?$labelchar+}; # ֥åΥ٥

    my $blockstart = qr|^{|; # ֥åγ

    my $line = $this->_nextline;
    if (defined $line) {
	my ($token,$type) = do {
	    if ($line =~ s/($label)//) {
		($1,'label');
	    }
	    elsif ($line =~ s/($blockstart)//) {
		($1,'blockstart');
	    }
	    else {
		# ʥȡ
		die "Syntax error: $line\n";
	    }
	};
	# ɬפʤĤʬХå
	$this->rollback($line);
	($token,$type);
    }
    else {
	undef;
    }
}

sub _context_block {
    my $this = shift;

    my $keychar = qr{[^\s{}:]}; # ȤƵʸ
    my $pair = qr{^$keychar+\s*:.*$}; # ͤΥڥ

    my $labelchar = qr{[^\s{}:]}; # ֥å֥åΥ٥ȤƵʸ
    my $label = qr{^$labelchar+}; # ֥åΥ٥

    my $blockstart = qr|^{|; # ֥åγ
    my $blockend = qr|^}|; # ֥åνλ

    my $line = $this->_nextline;
    if (defined $line) {
	my ($token,$type) = do {
	    if ($line =~ s/($pair)//) {
		($1,'pair');
	    }
	    elsif ($line =~ s/($label)//) {
		($1,'label');
	    }
	    elsif ($line =~ s/($blockstart)//) {
		($1,'blockstart');
	    }
	    elsif ($line =~ s/($blockend)//) {
		($1,'blockend');
	    }
	    else {
		# ʥȡ
		die "Syntax error: $line\n";
	    }
	};
	# ɬפʤĤʬХå
	$this->rollback($line);
	($token,$type);
    }
    else {
	undef;
    }
}

sub _nextline {
    my $this = shift;

    while (1) {
	if ($this->{body} eq '') {
	    # ⤦Ԥ̵
	    return undef;
	}

	# ȤꤢƬԤ
	$this->{body} =~ s/^(.*?)(?:\n|$)//s;
	my $line = $1;

	if (defined $line) {
	    # ޤԤĤäƤ롣
	    # ǽȺǸζ
	    if ($this->{rollbackcount} > 0) {
		# ɤ߲᤮ƤΤǥȤʤ
		$this->{rollbackcount}--;
	    }
	    else {
		$this->{linecount}++;
	    }
	    $line =~ s/^\s*|\s*$//g;
	    
	    # ιԤ䥳ȹԤʤФƼء
	    if ($line eq '' || $line =~ m/^#/) {
		next;
	    }
	    else {
		return $line;
	    }
	}
	else {
	    # ⤦Ԥ̵
	    return undef;
	}
    }
}

sub rollback {
    my ($this,$line) = @_;

    # ǽȺǸζ
    $line =~ s/^\s*|\s*$//g;

    # ޤȤĤäƤХ󥿤Ƚ᤹
    if ($line ne '') {
	$this->{body} = "$line\n$this->{body}";
	$this->{rollbackcount}++;
    }
}

1;
