# -----------------------------------------------------------------------------
# $Id: Block.pm,v 1.8 2003/07/03 13:49:24 admin Exp $
# -----------------------------------------------------------------------------
package Configuration::Block;
use strict;
use warnings;
use vars qw($AUTOLOAD);
use UNIVERSAL;
use Unicode::Japanese;
# ͤˤget᥽åɤѤ¾ȥ̾򤽤Τޤޥ᥽åɤȤƸƤֻޤ
#
# $block->hoge;
# ǥѥ᡼hoge֤ͤhoge̤ʤundef֤ͤ
# hogeͤĤä餽֤ʣͤ¸ߤ餽Ƭ֤ͤ
# ֥ͤåä顢Υ֥å֤
#
# $block->hoge('all');
# ѥ᡼hogeƤ֤ͤhoge̤ʤ֤
# ͤĤ̵ͤĤ֤
#
# $block->foo_bar;
# $block->foo_bar('all');
# ѥ᡼"foo-bar"֤ͤ"foo_bar"ǤϤʤ
#
# $block->foo('random');
# ѥ᡼fooʣСΤΰĤ֤
# Ĥ̵undef֤
#
# $block->get('foo_bar');
# $block->get('foo_bar','all');
# ѥ᡼"foo_bar"֤ͤ
#
# ʾλ顢Configuration::Blocknew,block_name,set,get,
# reinterpret-encoding,AUTOLOADȤä°get()Ǥɤʤ
# ޤ°̾˥°get()Ǥɤʤ

sub new {
    my ($class,$block_name) = @_;
    my $obj = {
	block_name => $block_name,
	table => {}, # ٥ -> (ե⤷ϥ顼)
    };
    bless $obj,$class;
}

sub block_name {
    my ($this,$newvalue) = @_;
    if (defined $newvalue) {
	$this->{block_name} = $newvalue;
    }
    $this->{block_name};
}

sub equals {
    # ĤConfiguration::Blockʤ1֤
    my ($this,$that) = @_;
    # ֥å̾
    if ($this->{block_name} ne $that->{block_name}) {
	return undef;
    }
    # ο
    my @this_keys = keys %{$this->{table}};
    my @that_keys = keys %{$that->{table}};
    if (@this_keys != @that_keys) {
	return undef;
    }
    # 
    my $size = @this_keys;
    for (my $i = 0; $i < $size; $i++) {
	# 
	if ($this_keys[$i] ne $that_keys[$i]) {
	    return undef;
	}
	# ͤη
	my $this_value = $this->{table}->{$this_keys[$i]};
	my $that_value = $that->{table}->{$that_keys[$i]};
	if (ref($this_value) ne ref($that_value)) {
	    return undef;
	}
	# 
	if (ref($this_value) eq 'ARRAY') {
	    # ʤΤǿǤӡ
	    if (@$this_value != @$that_value) {
		return undef;
	    }
	    my $valsize = @$this_value;
	    for (my $j = 0; $j < $valsize; $j++) {
		if ($this_value->[$j] ne $that_value->[$j]) {
		    return undef;
		}
	    }
	}
	elsif (UNIVERSAL::isa($this_value,'Configuration::Block')) {
	    # ֥åʤΤǺƵŪӡ
	    return $this_value->equals($that_value);
	}
	else {
	    if ($this_value ne $that_value) {
		return undef;
	    }
	}
    }
    return 1;
}

sub eval_code {
    # Ϥ줿ʸΡƤ%CODE{ ... }EDOC%ɾ֤
    my ($this,$str) = @_;

    if (ref($str)) {
	return $str; # ʸǤʤä餽Τޤ֤
    }

    my $eval = sub {
	my $script = shift;
	no strict; no warnings;
	my $result = eval "package Configuration::Implanted; $script";
	use warnings; use strict;
	if ($@) {
	    die "\%CODE{ }EDOC\% interpretation error.\n".
		"block: $this->{block_name}\n".
		"origianl: $str\n".
		"$@\n";
	}
	$result;
    };
    (my $evaluated = $str) =~ s/\%CODE{(.*?)}EDOC\%/$eval->($1)/eg;
    $evaluated;
}

sub get {
    my ($this,$key,$option) = @_;

    unless (exists $this->{table}->{$key}) {
	# Τ褦ͤƤʤ
	if ($option && $option eq 'all') {
	    return ();
	}	
	else {
	    return undef;
	}
    }

    my $value = $this->{table}->{$key};
    if ($option && $option eq 'all') {
	if (ref($value) eq 'ARRAY') {
	    return map {
		$this->eval_code($_);
	    } @{$value}; # եʤջȤ֤
	}
	else {
	    return $this->eval_code($value);
	}
    }
    elsif ($option && $option eq 'random') {
	if (ref($value) eq 'ARRAY') {
	    # եʤ֤
	    return $this->eval_code(
		$value->[int(rand(0xffffffff)) % @$value]);
	}
	else {
	    return $this->eval_code($value);
	}
    }
    else {
	if (ref($value) eq 'ARRAY') {
	    return $this->eval_code($value->[0]); # եʤƬ֤ͤ
	}
	else {
	    return $this->eval_code($value);
	}
    }
}

sub set {
    # Ťͤо񤭤롣
    my ($this,$key,$value) = @_;
    $this->{table}->{$key} = $value;
    $this;
}

sub add {
    # ŤͤФɲä롣
    my ($this,$key,$value) = @_;
    if (defined $this->{table}->{$key}) {
	# Ѥߡ
	if (ref($this->{table}->{$key}) eq 'ARRAY') {
	    # ʣͤäƤΤǤɲä롣
	    push @{$this->{table}->{$key}},$value;
	}
	else {
	    # ѹ롣
	    $this->{table}->{$key} = [$this->{table}->{$key},$value];
	}
    }
    else {
	# ѤߤǤʤ
	$this->{table}->{$key} = $value;
    }
}

sub reinterpret_encoding {
    # Υ֥åƤǤꤵ줿ʸ󥳡ǥ󥰤ǺƲ᤹롣
    # ƲUTF-8ˤʤ롣
    my ($this,$encoding) = @_;

    my $unicode = Unicode::Japanese->new;
    my $newtable = {};
    while (my ($key,$value) = each %{$this->{table}}) {
	my $newkey = $unicode->set($key,$encoding)->utf8;
	my $newvalue = do {
	    if (ref($value) eq 'ARRAY') {
		# ʤΤȤƥѴ
		my @newarray = map {
		    $unicode->set($_,$encoding)->utf8;
		} @$value;
		\@newarray;
	    }
	    elsif (UNIVERSAL::isa($value,'Configuration::Block')) {
		# ֥åʤΤǺƵŪ˥Ѵ
		$value->reinterpret_encoding($encoding);
	    }
	    else {
		$unicode->set($value,$encoding)->utf8;
	    }
	};
	$newtable->{$newkey} = $newvalue;
    }

    $this->{table} = $newtable;
    $this;
}

sub AUTOLOAD {
    my ($this,$option) = @_;
    
    if ($AUTOLOAD =~ /::DESTROY$/) {
	# DESTROYãʤ
	return;
    }

    (my $key = $AUTOLOAD) =~ s/.+?:://g;
    $key =~ s/_/-/g;
    return $this->get($key,$option);
}

1;
