# -----------------------------------------------------------------------------
# $Id: Configuration.pm,v 1.21 2003/08/12 01:45:35 admin Exp $
# -----------------------------------------------------------------------------
# Υ饹ϥեå`reloaded'Ѱդޤ
# եå`reloaded'ϡե뤬ɤ줿˸ƤФޤ
# -----------------------------------------------------------------------------
package Configuration;
# ConfigurationڤConfiguration::BlockUTF-8Хǥǡݻޤ
use strict;
use warnings;
use Unicode::Japanese;
use UNIVERSAL;
use Carp;
use Configuration::Preprocessor;
use Configuration::Parser;
use Configuration::Block;
use Hook;
our @ISA = 'HookTarget';
our $AUTOLOAD;
our $_shared_instance;
# ͤˤget᥽åɤѤ¾ȥ̾򤽤Τޤޥ᥽åɤȤƸƤֻޤ
#
# $conf->hoge;
# ֥åhoge֤hoge̤ʤundef֤ͤ

*shared = \&shared_conf;
sub shared_conf {
    unless (defined $_shared_instance) {
	$_shared_instance = _new Configuration();
    }
    $_shared_instance;
}

sub _new {
    my ($class) = @_;
    my $obj = {
	conf_file => '', # confեؤΥѥ
	time_on_load => 0, # Ǹload¹Ԥ줿
	blocks => {}, # ѥ֥å̾ -> Configuration::Block ˥⥸塼ʤ
	modules => [], # +ǻꤵ줿⥸塼Configuration::Block
    };
    bless $obj,$class;
    $obj;
}

sub get {
    my ($this,$block_name) = @_;
    # ѥ֥å򸡺

    if (!defined $block_name) {
	carp "Configuration->get, Arg[0] is undef.\n";
    }

    $this->{blocks}->{$block_name};
}

sub find_module_conf {
    my ($this,$module_name) = @_;
    # ⥸塼򸡺
    foreach my $conf (@{$this->{modules}}) {
	return $conf if $conf->block_name eq $module_name;
    }
    undef;
}

sub get_list_of_modules {
    # confǻꤵ줿֤ǡ+Ȥ줿ƤΥ⥸塼
    # Configuration::Blockؤե󥹤֤
    shift->{modules};
}

sub check_if_updated {
    # Ǹload¹ԤƤconfե뤬줿
    # ٤loadƤʤɬ1֤
    # ե̾¸Ƥʤɬ0֤
    my $this = shift;
    if ($this->{time_on_load} == 0) {
	1;
    }
    else {
	if (defined $this->{conf_file}) {
	    $this->{time_on_load} < (stat $this->{conf_file})[9];
	}
	else {
	    0;
	}
    }
}

sub load {
    # confեɤࡣեؤΥѥάȡ
    # load˻ꤵ줿ѥɤ롣
    # ե̾IO::HandleΥ֥ȤϤƤɤ
    # ξϥɤԲǽˤʤ롣
    my ($this,$conf_file) = @_;
    my $this_is_reload = !defined $conf_file;

    if (defined $conf_file) {
	if (ref($conf_file) && UNIVERSAL::isa($conf_file,'IO::Handle')) {
	    # IO::Handleä¸Ƥʤ
	    $this->{conf_file} = undef;
	}
	else {
	    # ե̾ʤΤ¸Ƥ
	    $this->{conf_file} = $conf_file;
	}
    }
    else {
	if (defined $this->{conf_file}) {
	    $conf_file = $this->{conf_file};
	}
	else {
	    croak "Configuration->load, Arg[1] was omitted or undef, but no file names were saved yet.\n";
	}
    }

    $this->{time_on_load} = time;

    # ץץƤѡ
    my $body = Configuration::Preprocessor::preprocess($conf_file);
    my $parser = Configuration::Parser->new($body);
    my $parsed = $parser->parsed;

    # Ƥʤͤϥǥեͤ롣
    &_complete_table_with_defaults($parsed);

    # general->conf-encoding򸫤ʸɤUTF-8Ѵ
    my $conf_encoding = do {
	my $result;
	foreach my $block (@$parsed) {
	    if ($block->block_name eq 'general') {
		$result = $block->conf_encoding;
		last;
	    }
	}
	$result;
    };
    foreach my $block (@$parsed) {
	$block->reinterpret_encoding($conf_encoding);
    }

    # Ȥꤢ⥸塼Υ֥åȤǤʤΤʬ롣
    my $blocks = {};
    my $modules = [];
    foreach my $block (@$parsed) {
	my $blockname = $block->block_name;

	if ($blockname =~ m/^-/) {
	    # -֥åʤΤǼΤƤ롣
	    next;
	}
	elsif ($blockname =~ m/^\+/) {
	    # +֥åʤΤ+äϿ
	    $blockname =~ s/^\+\s*//;
	    $block->block_name($blockname);

	    push @$modules,$block;
	}
	else {
	    # ̤Υ֥å
	    $blocks->{$blockname} = $block;
	}
    }

    $this->_check_required_definitions($blocks); # άԲǽĴ١⤷ͭdie롣
    $this->_check_duplicated_modules($modules); # Ʊ⥸塼뤬ʣƤdie롣

    # ޤdie줿Ȥϡ⥨顼ФʤäȤ
    # $thisϿǳꤹ롣
    $this->{blocks} = $blocks;
    $this->{modules} = $modules;

    # ɤϥեåƤ֡
    if ($this_is_reload) {
	$this->call_hooks('reloaded');
    }
}


# ǥեͤΥơ֥롣
my $defaults = {
    general => {
	'conf-encoding' => 'auto',
	'server-in-encoding' => 'jis',
	'server-out-encoding' => 'jis',
	'client-in-encoding' => 'jis',
	'client-out-encoding' => 'jis',
	'stdout-encoding' => 'euc',
    },
    networks => {
	'name' => 'main',
	# defaultΥǥեͤüʤΤǸ̽
	'multi-server-mode' => 1,
	'channel-network-separator' => '@',
	'action-when-disconnected' => 'part-and-join',
    },
};
sub _complete_table_with_defaults {
    my ($blocks) = @_;

    my $find_block = sub {
	my $name = shift;
	# ȤͿ줿֥å椫顢ꤵ줿̾ĤΤõ
	# դʤundef֤
	foreach my $block (@$blocks) {
	    if ($block->block_name eq $name) {
		return $block;
	    }
	}
	undef;
    };    
    my $copy_and_store_block = sub {
	# nameϥ顼blockϥϥå塣
	my ($name,$table) = @_;
	my $block = Configuration::Block->new($name);
	while (my ($key,$value) = each %$table) {
	    $block->add($key,$value);
	}
	push @$blocks,$block;
    };

    while (my ($default_block_name,$default_block) = each %{$defaults}) {
	# Υ֥å¸ߤƤ뤫
	unless (defined $find_block->($default_block_name)) {
	    # ֥åȾάƤΤǥǥեȤΥ֥å򥳥ԡ
	    $copy_and_store_block->($default_block_name,$default_block);
	    next; # ԡΤͤ­Ϲͤʤɤ
	}
	
	while (my ($default_key,$default_value) = each %{$default_block}) {
	    my $block = $find_block->($default_block_name);
	    # ͤ¸ߤƤ뤫
	    if (!defined $block->get($default_key)) {
		# ͤάƤΤͤ
		$block->add($default_key,$default_value);
	    }
	}
    }

    # networksdefault̽
    my $networks = $find_block->('networks');
    if (!defined $networks->default) {
	$networks->set('default',$networks->name);
    }
}


my $required = {
    general => ['nick','user','name'],
    # [ͥåȥ̾]host,port̽
};
my $required_in_each_networks = ['host','port'];
sub _check_required_definitions {
    my ($this,$blocks) = @_;
    if (!defined $blocks) {
	$blocks = $this->{blocks};
    }
    
    my $error = sub {
	my ($block_name,$key) = @_;
	die "Required definition '$key' in block '$block_name' was not found.\n";
    };
    
    # $requiredƤΤ˴ؤƥåԤʤ
    while (my ($required_block_name,$required_keys) = each %{$required}) {
	foreach my $required_key (@{$required_keys}) {
	    unless ($blocks->{$required_block_name}->get($required_key)) {
		# ɬפȤƤΤ̵ä
		$error->($required_block_name,$required_key);
	    }
	}
    }
    
    # ƥͥåȥhostportå
    my @network_names = $blocks->{networks}->name('all');
    foreach my $network_name (@network_names) {
	foreach my $required_key (@{$required_in_each_networks}) {
	    my $block = $blocks->{$network_name};
	    if (!defined $block) {
		die "Block $network_name was not found. It was enumerated in networks/name.\n";
	    }
	    if (!defined $blocks->{$network_name}->get($required_key)) {
		# ɬפȤƤΤ̵ä
		$error->($network_name,$required_key);
	    }
	}
    }
}

sub _check_duplicated_modules {
    my ($this,$modules) = @_;
    if (!defined $modules) {
	$modules = $this->{modules};
    }

    my $modnames = {};
    foreach my $block (@$modules) {
	my $modname = $block->block_name;
	if (defined $modnames->{$modname}) {
	    die "Module $modname has multiple definitions. Only one is allowed.\n";
	}
	$modnames->{$modname} = 1;
    }
}

sub AUTOLOAD {
    my $this = shift;
    if ($AUTOLOAD =~ /::DESTROY$/) {
	# DESTROYãʤ
	return;
    }

    (my $key = $AUTOLOAD) =~ s/.+?:://g;
    return $this->get($key);
}

# -----------------------------------------------------------------------------
package Configuration::Hook;
use FunctionalVariable;
use base 'Hook';

our $HOOK_TARGET_NAME = 'Configuration';
our @HOOK_NAME_CANDIDATES = 'reloaded';
our $HOOK_TARGET_DEFAULT;
FunctionalVariable::tie(
    \$HOOK_TARGET_DEFAULT,
    FETCH => sub {
	Configuration->shared;
    },
);

1;
